/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

public class GetImageServlet
extends HttpServlet {
    private static final long serialVersionUID = -7669068179452648952L;
    private static final Log LOG = LogFactory.getLog(GetImageServlet.class);

    public void doGet(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        Map pmap = request.getParameterMap();
        try {
            ServletContext context = this.getServletContext();
            final FSImage nnImage = (FSImage)context.getAttribute("name.system.image");
            final TransferFsImage ff = new TransferFsImage(pmap, request, response);
            final Configuration conf = (Configuration)this.getServletContext().getAttribute("current.conf");
            if (UserGroupInformation.isSecurityEnabled() && !this.isValidRequestor(request.getRemoteUser(), conf)) {
                response.sendError(403, "Only Namenode and Secondary Namenode may access this servlet");
                LOG.warn((Object)("Received non-NN/SNN request for image or edits from " + request.getRemoteHost()));
                return;
            }
            UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    if (ff.getImage()) {
                        response.setHeader("Content-Length", String.valueOf(nnImage.getFsImageName().length()));
                        TransferFsImage.getFileServer((OutputStream)response.getOutputStream(), nnImage.getFsImageName());
                    } else if (ff.getEdit()) {
                        response.setHeader("Content-Length", String.valueOf(nnImage.getFsEditName().length()));
                        TransferFsImage.getFileServer((OutputStream)response.getOutputStream(), nnImage.getFsEditName());
                    } else if (ff.putImage()) {
                        nnImage.validateCheckpointUpload(ff.getToken());
                        this.reloginIfNecessary().doAs(new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                TransferFsImage.getFileClient(ff.getInfoServer(), "getimage=1", nnImage.getFsImageNameCheckpoint());
                                return null;
                            }
                        });
                        nnImage.checkpointUploadDone();
                    }
                    return null;
                }

                private UserGroupInformation reloginIfNecessary() throws IOException {
                    return UserGroupInformation.loginUserFromKeytabAndReturnUGI(SecurityUtil.getServerPrincipal(conf.get("dfs.namenode.kerberos.https.principal"), NameNode.getAddress(conf).getHostName()), conf.get("dfs.namenode.keytab.file"));
                }
            });
        }
        catch (Exception ie) {
            String errMsg = "GetImage failed. " + StringUtils.stringifyException(ie);
            response.sendError(410, errMsg);
            throw new IOException(errMsg);
        }
        finally {
            response.getOutputStream().close();
        }
    }

    private boolean isValidRequestor(String remoteUser, Configuration conf) throws IOException {
        String[] validRequestors;
        if (remoteUser == null) {
            LOG.warn((Object)"Received null remoteUser while authorizing access to getImage servlet");
            return false;
        }
        for (String v : validRequestors = new String[]{SecurityUtil.getServerPrincipal(conf.get("dfs.namenode.kerberos.https.principal"), NameNode.getAddress(conf).getHostName()), SecurityUtil.getServerPrincipal(conf.get("dfs.namenode.kerberos.principal"), NameNode.getAddress(conf).getHostName()), SecurityUtil.getServerPrincipal(conf.get("dfs.secondary.namenode.kerberos.https.principal"), SecondaryNameNode.getHttpAddress(conf).getHostName()), SecurityUtil.getServerPrincipal(conf.get("dfs.secondary.namenode.kerberos.principal"), SecondaryNameNode.getHttpAddress(conf).getHostName())}) {
            if (v == null || !v.equals(remoteUser)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("isValidRequestor is allowing: " + remoteUser));
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isValidRequestor is rejecting: " + remoteUser));
        }
        return false;
    }
}

