% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/first_order.R
\name{first_order}
\alias{first_order}
\title{Calculates first-order statistical metrics for RIA_image}
\usage{
first_order(RIA_data_in, use_type = "single", use_orig = FALSE,
  use_slot = NULL, save_name = NULL, verbose_in = TRUE)
}
\arguments{
\item{RIA_data_in}{\emph{RIA_image}, created by \code{\link[RIA]{load_dicom}}.}

\item{use_type}{string, currently only "single" data processing is supported.}

\item{use_orig}{logical, indicating whether to use image present in \emph{RIA_data$orig}.
If FALSE, the modified image will be used stored in \emph{RIA_data$modif}.}

\item{use_slot}{string, name of slot where data wished to be used is. Use if the desired image
is not in the \emph{data$orig} or \emph{data$modif} slot of the \emph{RIA_image}. For example,
if the desired dataset is in \emph{RIA_image$dichotomized$ep_4}, then \emph{use_slot} should be
\emph{dichotomized$ep_4}. The results are automatically saved. If the results are not saved to
the desired slot, then please use \emph{save_name} parameter.}

\item{save_name}{string, indicating the name of subslot of \emph{$stat_fo} to save results to.
If left empty, then it will be automatically determined.}

\item{verbose_in}{logical indicating whether to print detailed information.
Most prints can also be suppresed using the \code{\link{suppressMessages}} function.}
}
\value{
\emph{RIA_image} containing the statistical information.
}
\description{
Calculates first-order statistical metrics of \emph{RIA_image}.
First-order metrics discard all spatial information. By default the \emph{$modif}
image will be used to calculate statistics. If \emph{use_slot} is given, then the data
present in \emph{RIA_image$use_slot} will be used for calculations.
Results will be saved into the \emph{$stat_fo} slot. The name of the subslot is determined
by the supplied string in \emph{$save_name}, or is automatically generated by RIA.
}
\examples{
\dontrun{
#Calculate first-order statistics on original data
RIA_image <- first_order(RIA_image, use_orig = TRUE)

#Dichotomize loaded image and then calculate first order statistics
on it and save results into the RIA_image
RIA_image <- dichotomize(RIA_image, bins_in = c(4, 8), equal_prob = TRUE,
use_orig = TRUE, write_orig = FALSE)
RIA_image <- first_order(RIA_image, use_orig = FALSE, verbose_in = TRUE)

#Use use_slot parameter to set which image to use
RIA_image <- first_order(RIA_image, use_orig = FALSE, use_slot = "dichotomized$ep_4")
}
}

