% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glrlm_stat_all.R
\encoding{UTF-8}
\name{glrlm_stat_all}
\alias{glrlm_stat_all}
\title{Aggregates GLRLM-based statistics based-on supplied function}
\usage{
glrlm_stat_all(RIA_data_in, statistic = "mean(X, na.rm = TRUE)",
  verbose_in = TRUE)
}
\arguments{
\item{RIA_data_in}{\emph{RIA_image}.}

\item{statistic}{string, defining the statistic to be calculated on the array of GLRLM statistics.
By default, statistic is set to \emph{"mean"}, however any function may be provided. The proper
syntax is: function(X, attributes). The supplied string must contain a "X", which will be replaced
with the array of the GLRLM statistics value. Further attributes of the function may also be given.
For example, if you wish to calculate the median of all GLRLMs calculated in different directions,
then it must be supplied as: \emph{median(X, na.rm = TRUE)}.}

\item{verbose_in}{logical, indicating whether to print detailed information.
Most prints can also be suppressed using the \code{\link{suppressMessages}} function.}
}
\value{
\emph{RIA_image} containing the statistical information.
}
\description{
Calculates aggregated statistics of GLRLM matrix statistics calculated on
GLRLM matrices evaluated in all different directions.
}
\examples{
\dontrun{
#Discretize loaded image and then calculate GLCM statistics for all matrices
RIA_image <- discretize(RIA_image, bins_in = c(4, 8), equal_prob = TRUE,
use_orig = TRUE, write_orig = FALSE)
RIA_image <- glrlm_all(RIA_image, use_type = "discretized")
RIA_image <- glrlm_stat(RIA_image)

#Calculate the average of the different GLCM matrices in the different directions
RIA_image <- glrlm_stat_all(RIA_image)
}

}
\references{
Márton KOLOSSVÁRY et al.
Radiomic Features Are Superior to Conventional Quantitative Computed Tomographic
Metrics to Identify Coronary Plaques With Napkin-Ring Sign
Circulation: Cardiovascular Imaging (2017).
DOI: 10.1161/circimaging.117.006843
\url{https://pubmed.ncbi.nlm.nih.gov/29233836/}

Márton KOLOSSVÁRY et al.
Cardiac Computed Tomography Radiomics: A Comprehensive Review on Radiomic Techniques.
Journal of Thoracic Imaging (2018).
DOI: 10.1097/RTI.0000000000000268
\url{https://pubmed.ncbi.nlm.nih.gov/28346329/}
}
