% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateResults.R
\name{getSubset}
\alias{getSubset}
\title{Function to group the data according to a specified feature.}
\usage{
getSubset(
  subsetDef,
  distType = FALSE,
  tableTCs,
  errorList,
  category = c("fractionPathol", "fractionPathol_cum", "N", "N_cum", "OvFreq",
    "OvFreq_cum"),
  restrict = NULL
)
}
\arguments{
\item{subsetDef}{(character) listing either the analytes or distribution types for which the result files should be parsed}

\item{distType}{(logical) indicating if parameter subsetDef refers to analytes (FALSE, default) or distribution types (TRUE)}

\item{tableTCs}{(data.frame) containing all information about the simulated test sets}

\item{errorList}{(list) containing for each method the table with the computed error measurements}

\item{category}{(character) defining the category used for creating the subsets. All defined sub-features are used for the categorization. 
Choose from "fractionPathol" (default), "N", or "OvFreq", individual or cumulative ("_cum")}

\item{restrict}{(character) indicating whether test sets should be filtered according to specified restriction, default NULL, 
e.g. fractionPathol <= 0.30}
}
\value{
(list) containing the performance measurements grouped according to specified subset definition and categories
}
\description{
The feature can either be the pathological fraction, the sample size or the overlap (category) individually or cumulative (_cum). 
For an individualized categorisation see \code{getSubsetForDefinedCats}.
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
