/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageRoi;
import ij.gui.ImageWindow;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RoiBrush;
import ij.gui.ShapeRoi;
import ij.gui.StackWindow;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.macro.MacroRunner;
import ij.plugin.WandToolOptions;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.RoiManager;
import ij.util.Java2;
import ij.util.Tools;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.List;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.IndexColorModel;
import java.util.Hashtable;
import java.util.Vector;

public class ImageCanvas
extends Canvas
implements MouseListener,
MouseMotionListener,
Cloneable {
    protected static Cursor defaultCursor = new Cursor(0);
    protected static Cursor handCursor = new Cursor(12);
    protected static Cursor moveCursor = new Cursor(13);
    protected static Cursor crosshairCursor = new Cursor(1);
    public static boolean usePointer = Prefs.usePointerCursor;
    protected ImagePlus imp;
    protected boolean imageUpdated;
    protected Rectangle srcRect;
    protected int imageWidth;
    protected int imageHeight;
    protected int xMouse;
    protected int yMouse;
    private boolean showCursorStatus = true;
    private int sx2;
    private int sy2;
    private boolean disablePopupMenu;
    private boolean showAllROIs;
    private static Color zoomIndicatorColor;
    private static Font smallFont;
    private static Font largeFont;
    private Rectangle[] labelRects;
    private boolean maxBoundsReset;
    private Overlay overlay;
    private Overlay showAllList;
    private static final int LIST_OFFSET = 100000;
    private static Color showAllColor;
    private static Color labelColor;
    private int resetMaxBoundsCount;
    private Roi currentRoi;
    protected ImageJ ij;
    protected double magnification;
    protected int dstWidth;
    protected int dstHeight;
    protected int xMouseStart;
    protected int yMouseStart;
    protected int xSrcStart;
    protected int ySrcStart;
    protected int flags;
    private Image offScreenImage;
    private int offScreenWidth = 0;
    private int offScreenHeight = 0;
    private boolean mouseExited = true;
    private boolean customRoi;
    long firstFrame;
    int frames;
    int fps;
    int count;
    private static final double[] zoomLevels;

    public ImageCanvas(ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.ij = IJ.getInstance();
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        this.imageWidth = n;
        this.imageHeight = n2;
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        this.setDrawingSize(this.imageWidth, this.imageHeight);
        this.magnification = 1.0;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this.ij);
        this.setFocusTraversalKeysEnabled(false);
    }

    void updateImage(ImagePlus imagePlus) {
        this.imp = imagePlus;
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        this.imageWidth = n;
        this.imageHeight = n2;
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        this.setDrawingSize(this.imageWidth, this.imageHeight);
        this.magnification = 1.0;
    }

    void update(ImageCanvas imageCanvas) {
        if (imageCanvas == null || imageCanvas == this || imageCanvas.imp == null) {
            return;
        }
        if (imageCanvas.imp.getWidth() != this.imageWidth || imageCanvas.imp.getHeight() != this.imageHeight) {
            return;
        }
        this.srcRect = new Rectangle(imageCanvas.srcRect.x, imageCanvas.srcRect.y, imageCanvas.srcRect.width, imageCanvas.srcRect.height);
        this.setMagnification(imageCanvas.magnification);
        this.setDrawingSize(imageCanvas.dstWidth, imageCanvas.dstHeight);
    }

    public void setSourceRect(Rectangle rectangle) {
        this.srcRect = rectangle;
    }

    public void setDrawingSize(int n, int n2) {
        this.dstWidth = n;
        this.dstHeight = n2;
        this.setSize(this.dstWidth, this.dstHeight);
    }

    public void setImageUpdated() {
        this.imageUpdated = true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Roi roi = this.imp.getRoi();
        if (roi != null || this.showAllROIs || this.overlay != null) {
            if (roi != null) {
                roi.updatePaste();
            }
            if (!IJ.isMacOSX() && this.imageWidth != 0) {
                this.paintDoubleBuffered(graphics);
                return;
            }
        }
        try {
            if (this.imageUpdated) {
                this.imageUpdated = false;
                this.imp.updateImage();
            }
            Java2.setBilinearInterpolation(graphics, Prefs.interpolateScaledImages);
            Image image = this.imp.getImage();
            if (image != null) {
                graphics.drawImage(image, 0, 0, (int)((double)this.srcRect.width * this.magnification), (int)((double)this.srcRect.height * this.magnification), this.srcRect.x, this.srcRect.y, this.srcRect.x + this.srcRect.width, this.srcRect.y + this.srcRect.height, null);
            }
            if (this.overlay != null) {
                this.drawOverlay(graphics);
            }
            if (this.showAllROIs) {
                this.drawAllROIs(graphics);
            }
            if (roi != null) {
                this.drawRoi(roi, graphics);
            }
            if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight) {
                this.drawZoomIndicator(graphics);
            }
            if (IJ.debugMode) {
                this.showFrameRate(graphics);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("Paint");
        }
    }

    private void drawRoi(Roi roi, Graphics graphics) {
        if (roi == this.currentRoi) {
            Color color = roi.getStrokeColor();
            Color color2 = roi.getFillColor();
            float f = roi.getStrokeWidth();
            roi.setStrokeColor(null);
            roi.setFillColor(null);
            roi.setStrokeWidth(1.0f);
            roi.draw(graphics);
            roi.setStrokeColor(color);
            roi.setStrokeWidth(f);
            roi.setFillColor(color2);
            this.currentRoi = null;
        } else {
            roi.draw(graphics);
        }
    }

    void drawAllROIs(Graphics graphics) {
        RoiManager roiManager = RoiManager.getInstance();
        if (roiManager == null && (roiManager = Interpreter.getBatchModeRoiManager()) != null && roiManager.getList().getItemCount() == 0) {
            roiManager = null;
        }
        if (roiManager == null) {
            if (this.showAllList != null) {
                this.overlay = this.showAllList;
            }
            this.showAllROIs = false;
            this.repaint();
            return;
        }
        this.initGraphics(graphics);
        Hashtable hashtable = roiManager.getROIs();
        List list = roiManager.getList();
        boolean bl = roiManager.getDrawLabels();
        this.currentRoi = null;
        int n = list.getItemCount();
        if (IJ.debugMode) {
            IJ.log("paint: drawing " + n + " \"Show All\" ROIs");
        }
        if (this.labelRects == null || this.labelRects.length != n) {
            this.labelRects = new Rectangle[n];
        }
        this.showAllList = !bl ? new Overlay() : null;
        for (int i = 0; i < n; ++i) {
            String string = list.getItem(i);
            Roi roi = (Roi)hashtable.get(string);
            if (roi == null) continue;
            if (this.showAllList != null) {
                this.showAllList.add(roi);
            }
            if (i < 200 && bl && this.imp != null && roi == this.imp.getRoi()) {
                this.currentRoi = roi;
            }
            if (Prefs.showAllSliceOnly && this.imp.getStackSize() > 1) {
                int n2 = this.getSliceNumber(roi.getName());
                if (n2 != -1 && n2 != this.imp.getCurrentSlice()) continue;
                this.drawRoi(graphics, roi, bl ? i : -1);
                continue;
            }
            this.drawRoi(graphics, roi, bl ? i : -1);
        }
        ((Graphics2D)graphics).setStroke(Roi.onePixelWide);
    }

    public int getSliceNumber(String string) {
        int n = -1;
        if (string.length() >= 14 && string.charAt(4) == '-' && string.charAt(9) == '-') {
            n = (int)Tools.parseDouble(string.substring(0, 4), -1.0);
        } else if (string.length() >= 17 && string.charAt(5) == '-' && string.charAt(11) == '-') {
            n = (int)Tools.parseDouble(string.substring(0, 5), -1.0);
        } else if (string.length() >= 20 && string.charAt(6) == '-' && string.charAt(13) == '-') {
            n = (int)Tools.parseDouble(string.substring(0, 6), -1.0);
        }
        return n;
    }

    void drawOverlay(Graphics graphics) {
        int n;
        if (this.imp != null && this.imp.getHideOverlay()) {
            return;
        }
        this.initGraphics(graphics);
        int n2 = this.overlay.size();
        if (IJ.debugMode) {
            IJ.log("paint: drawing " + n2 + " ROI display list");
        }
        boolean bl = this.overlay.getDrawLabels();
        int n3 = this.imp.getStackSize();
        if (n2 > 1 && n2 == n3 && this.stackLabels(this.overlay) && (n = this.imp.getCurrentSlice() - 1) < n2) {
            this.overlay.temporarilyHide(0, n - 1);
            this.overlay.temporarilyHide(n + 1, n3 - 1);
        }
        for (n = 0; n < n2 && this.overlay != null; ++n) {
            this.drawRoi(graphics, this.overlay.get(n), bl ? n + 100000 : -1);
        }
        ((Graphics2D)graphics).setStroke(Roi.onePixelWide);
    }

    public boolean stackLabels(Overlay overlay) {
        Roi roi = overlay.get(0);
        boolean bl = roi instanceof TextRoi && overlay.get(overlay.size() - 1) instanceof TextRoi;
        String string = null;
        try {
            string = ((TextRoi)roi).getText();
        }
        catch (Exception exception) {
            return false;
        }
        return bl && string.length() > 0 && (Character.isDigit(string.charAt(0)) || string.charAt(0) == ' ');
    }

    void initGraphics(Graphics graphics) {
        if (smallFont == null) {
            smallFont = new Font("SansSerif", 0, 9);
            largeFont = new Font("SansSerif", 0, 12);
        }
        if (labelColor == null) {
            int n;
            int n2;
            int n3 = showAllColor.getRed();
            labelColor = (n3 + (n2 = showAllColor.getGreen()) + (n = showAllColor.getBlue())) / 3 < 128 ? Color.white : Color.black;
        }
        graphics.setColor(showAllColor);
    }

    void drawRoi(Graphics graphics, Roi roi, int n) {
        int n2 = roi.getType();
        ImagePlus imagePlus = roi.getImage();
        roi.setImage(this.imp);
        Color color = roi.getStrokeColor();
        if (color == null) {
            roi.setStrokeColor(showAllColor);
        }
        if (roi instanceof TextRoi) {
            ((TextRoi)roi).drawText(graphics);
        } else {
            roi.drawOverlay(graphics);
        }
        roi.setStrokeColor(color);
        if (n >= 0) {
            if (roi == this.currentRoi) {
                graphics.setColor(Roi.getColor());
            } else {
                graphics.setColor(showAllColor);
            }
            this.drawRoiLabel(graphics, n, roi.getBounds());
        }
        if (imagePlus != null) {
            roi.setImage(imagePlus);
        } else {
            roi.setImage(null);
        }
    }

    void drawRoiLabel(Graphics graphics, int n, Rectangle rectangle) {
        boolean bl;
        int n2;
        int n3 = this.screenX(rectangle.x);
        int n4 = this.screenY(rectangle.y);
        double d = this.getMagnification();
        int n5 = (int)((double)rectangle.width * d);
        int n6 = (int)((double)rectangle.height * d);
        int n7 = n2 = n5 > 40 && n6 > 40 ? 12 : 9;
        if (n2 == 12) {
            graphics.setFont(largeFont);
        } else {
            graphics.setFont(smallFont);
        }
        boolean bl2 = bl = n >= 100000;
        if (bl) {
            n -= 100000;
        }
        String string = "" + (n + 1);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n8 = fontMetrics.stringWidth(string);
        n3 = n3 + n5 / 2 - n8 / 2;
        n4 = n4 + n6 / 2 + Math.max(n2 / 2, 6);
        int n9 = fontMetrics.getHeight();
        graphics.fillRoundRect(n3 - 1, n4 - n9 + 2, n8 + 1, n9 - 3, 5, 5);
        if (!bl) {
            this.labelRects[n] = new Rectangle(n3 - 1, n4 - n9 + 2, n8 + 1, n9 - 3);
        }
        graphics.setColor(labelColor);
        graphics.drawString(string, n3, n4 - 2);
        graphics.setColor(showAllColor);
    }

    void drawZoomIndicator(Graphics graphics) {
        int n = 10;
        int n2 = 10;
        double d = (double)this.imageHeight / (double)this.imageWidth;
        int n3 = 64;
        if (d > 1.0) {
            n3 = (int)((double)n3 / d);
        }
        int n4 = (int)((double)n3 * d);
        if (n3 < 4) {
            n3 = 4;
        }
        if (n4 < 4) {
            n4 = 4;
        }
        int n5 = (int)((double)n3 * ((double)this.srcRect.width / (double)this.imageWidth));
        int n6 = (int)((double)n4 * ((double)this.srcRect.height / (double)this.imageHeight));
        if (n5 < 1) {
            n5 = 1;
        }
        if (n6 < 1) {
            n6 = 1;
        }
        int n7 = (int)((double)n3 * ((double)this.srcRect.x / (double)this.imageWidth));
        int n8 = (int)((double)n4 * ((double)this.srcRect.y / (double)this.imageHeight));
        if (zoomIndicatorColor == null) {
            zoomIndicatorColor = new Color(128, 128, 255);
        }
        graphics.setColor(zoomIndicatorColor);
        ((Graphics2D)graphics).setStroke(Roi.onePixelWide);
        graphics.drawRect(n, n2, n3, n4);
        if (n5 * n6 <= 200 || n5 < 10 || n6 < 10) {
            graphics.fillRect(n + n7, n2 + n8, n5, n6);
        } else {
            graphics.drawRect(n + n7, n2 + n8, n5, n6);
        }
    }

    void paintDoubleBuffered(Graphics graphics) {
        int n = (int)((double)this.srcRect.width * this.magnification);
        int n2 = (int)((double)this.srcRect.height * this.magnification);
        if (this.offScreenImage == null || this.offScreenWidth != n || this.offScreenHeight != n2) {
            this.offScreenImage = this.createImage(n, n2);
            this.offScreenWidth = n;
            this.offScreenHeight = n2;
        }
        Roi roi = this.imp.getRoi();
        try {
            if (this.imageUpdated) {
                this.imageUpdated = false;
                this.imp.updateImage();
            }
            Graphics graphics2 = this.offScreenImage.getGraphics();
            Java2.setBilinearInterpolation(graphics2, Prefs.interpolateScaledImages);
            Image image = this.imp.getImage();
            if (image != null) {
                graphics2.drawImage(image, 0, 0, n, n2, this.srcRect.x, this.srcRect.y, this.srcRect.x + this.srcRect.width, this.srcRect.y + this.srcRect.height, null);
            }
            if (this.overlay != null) {
                this.drawOverlay(graphics2);
            }
            if (this.showAllROIs) {
                this.drawAllROIs(graphics2);
            }
            if (roi != null) {
                this.drawRoi(roi, graphics2);
            }
            if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight) {
                this.drawZoomIndicator(graphics2);
            }
            if (IJ.debugMode) {
                this.showFrameRate(graphics2);
            }
            graphics.drawImage(this.offScreenImage, 0, 0, null);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("Paint");
        }
    }

    public void resetDoubleBuffer() {
        this.offScreenImage = null;
    }

    void showFrameRate(Graphics graphics) {
        ++this.frames;
        if (System.currentTimeMillis() > this.firstFrame + 1000L) {
            this.firstFrame = System.currentTimeMillis();
            this.fps = this.frames;
            this.frames = 0;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(10, 12, 50, 15);
        graphics.setColor(Color.black);
        graphics.drawString((int)((double)this.fps + 0.5) + " fps", 10, 25);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.dstWidth, this.dstHeight);
    }

    public Point getCursorLoc() {
        return new Point(this.xMouse, this.yMouse);
    }

    public boolean cursorOverImage() {
        return !this.mouseExited;
    }

    public int getModifiers() {
        return this.flags;
    }

    public ImagePlus getImage() {
        return this.imp;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCursor(int n, int n2, int n3, int n4) {
        block14: {
            block13: {
                this.xMouse = n3;
                this.yMouse = n4;
                this.mouseExited = false;
                Roi roi = this.imp.getRoi();
                ImageWindow imageWindow = this.imp.getWindow();
                if (imageWindow == null) {
                    return;
                }
                if (IJ.spaceBarDown()) {
                    this.setCursor(handCursor);
                    return;
                }
                int n5 = Toolbar.getToolId();
                switch (Toolbar.getToolId()) {
                    case 11: {
                        this.setCursor(moveCursor);
                        return;
                    }
                    case 12: {
                        this.setCursor(handCursor);
                        return;
                    }
                }
                if (n5 == 10 || n5 >= 15) {
                    if (Prefs.usePointerCursor) {
                        this.setCursor(defaultCursor);
                        return;
                    }
                    this.setCursor(crosshairCursor);
                    return;
                }
                if (roi != null) {
                    if (roi.getState() != 0 && roi.isHandle(n, n2) >= 0) {
                        this.setCursor(handCursor);
                        return;
                    }
                }
                if (Prefs.usePointerCursor) break block13;
                if (roi == null) break block14;
                if (roi.getState() == 0 || !roi.contains(n3, n4)) break block14;
            }
            this.setCursor(defaultCursor);
            return;
        }
        this.setCursor(crosshairCursor);
    }

    public int offScreenX(int n) {
        return this.srcRect.x + (int)((double)n / this.magnification);
    }

    public int offScreenY(int n) {
        return this.srcRect.y + (int)((double)n / this.magnification);
    }

    public double offScreenXD(int n) {
        return (double)this.srcRect.x + (double)n / this.magnification;
    }

    public double offScreenYD(int n) {
        return (double)this.srcRect.y + (double)n / this.magnification;
    }

    public int screenX(int n) {
        return (int)((double)(n - this.srcRect.x) * this.magnification);
    }

    public int screenY(int n) {
        return (int)((double)(n - this.srcRect.y) * this.magnification);
    }

    public int screenXD(double d) {
        return (int)((d - (double)this.srcRect.x) * this.magnification);
    }

    public int screenYD(double d) {
        return (int)((d - (double)this.srcRect.y) * this.magnification);
    }

    public double getMagnification() {
        return this.magnification;
    }

    public void setMagnification(double d) {
        this.setMagnification2(d);
    }

    void setMagnification2(double d) {
        if (d > 32.0) {
            d = 32.0;
        }
        if (d < 0.03125) {
            d = 0.03125;
        }
        this.magnification = d;
        this.imp.setTitle(this.imp.getTitle());
    }

    public Rectangle getSrcRect() {
        return this.srcRect;
    }

    void setSrcRect(Rectangle rectangle) {
        this.srcRect = rectangle;
    }

    void resizeCanvas(int n, int n2) {
        ImageWindow imageWindow = this.imp.getWindow();
        if (!(this.maxBoundsReset || n <= this.dstWidth && n2 <= this.dstHeight || imageWindow == null || imageWindow.maxBounds == null || n == imageWindow.maxBounds.width - 10)) {
            if (this.resetMaxBoundsCount != 0) {
                this.resetMaxBounds();
            }
            ++this.resetMaxBoundsCount;
        }
        if (IJ.altKeyDown()) {
            this.fitToWindow();
            return;
        }
        if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight) {
            if ((double)n > (double)this.imageWidth * this.magnification) {
                n = (int)((double)this.imageWidth * this.magnification);
            }
            if ((double)n2 > (double)this.imageHeight * this.magnification) {
                n2 = (int)((double)this.imageHeight * this.magnification);
            }
            this.setDrawingSize(n, n2);
            this.srcRect.width = (int)((double)this.dstWidth / this.magnification);
            this.srcRect.height = (int)((double)this.dstHeight / this.magnification);
            if (this.srcRect.x + this.srcRect.width > this.imageWidth) {
                this.srcRect.x = this.imageWidth - this.srcRect.width;
            }
            if (this.srcRect.y + this.srcRect.height > this.imageHeight) {
                this.srcRect.y = this.imageHeight - this.srcRect.height;
            }
            this.repaint();
        }
    }

    public void fitToWindow() {
        ImageWindow imageWindow = this.imp.getWindow();
        if (imageWindow == null) {
            return;
        }
        Rectangle rectangle = imageWindow.getBounds();
        Insets insets = imageWindow.getInsets();
        int n = imageWindow instanceof StackWindow ? 20 : 0;
        double d = (double)(rectangle.width - 10) / (double)this.srcRect.width;
        double d2 = (double)(rectangle.height - (10 + insets.top + n)) / (double)this.srcRect.height;
        this.setMagnification(Math.min(d, d2));
        int n2 = (int)((double)this.imageWidth * this.magnification);
        int n3 = (int)((double)this.imageHeight * this.magnification);
        if (n2 == this.dstWidth && n3 == this.dstHeight) {
            return;
        }
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        this.setDrawingSize(n2, n3);
        this.getParent().doLayout();
    }

    void setMaxBounds() {
        if (this.maxBoundsReset) {
            this.maxBoundsReset = false;
            ImageWindow imageWindow = this.imp.getWindow();
            if (imageWindow != null && !IJ.isLinux() && imageWindow.maxBounds != null) {
                imageWindow.setMaximizedBounds(imageWindow.maxBounds);
                imageWindow.setMaxBoundsTime = System.currentTimeMillis();
            }
        }
    }

    void resetMaxBounds() {
        ImageWindow imageWindow = this.imp.getWindow();
        if (imageWindow != null && System.currentTimeMillis() - imageWindow.setMaxBoundsTime > 500L) {
            imageWindow.setMaximizedBounds(imageWindow.maxWindowBounds);
            this.maxBoundsReset = true;
        }
    }

    public static double getLowerZoomLevel(double d) {
        double d2 = zoomLevels[0];
        for (int i = 0; i < zoomLevels.length && zoomLevels[i] < d; ++i) {
            d2 = zoomLevels[i];
        }
        return d2;
    }

    public static double getHigherZoomLevel(double d) {
        double d2 = 32.0;
        for (int i = zoomLevels.length - 1; i >= 0 && zoomLevels[i] > d; --i) {
            d2 = zoomLevels[i];
        }
        return d2;
    }

    public void zoomIn(int n, int n2) {
        int n3;
        if (this.magnification >= 32.0) {
            return;
        }
        double d = ImageCanvas.getHigherZoomLevel(this.magnification);
        int n4 = (int)((double)this.imageWidth * d);
        Dimension dimension = this.canEnlarge(n4, n3 = (int)((double)this.imageHeight * d));
        if (dimension != null) {
            this.setDrawingSize(dimension.width, dimension.height);
            if (dimension.width != n4 || dimension.height != n3) {
                this.adjustSourceRect(d, n, n2);
            } else {
                this.setMagnification(d);
            }
            this.imp.getWindow().pack();
        } else {
            this.adjustSourceRect(d, n, n2);
        }
        this.repaint();
        if (this.srcRect.width < this.imageWidth || this.srcRect.height < this.imageHeight) {
            this.resetMaxBounds();
        }
    }

    void adjustSourceRect(double d, int n, int n2) {
        int n3;
        int n4 = (int)Math.round((double)this.dstWidth / d);
        if ((double)n4 * d < (double)this.dstWidth) {
            ++n4;
        }
        if ((double)(n3 = (int)Math.round((double)this.dstHeight / d)) * d < (double)this.dstHeight) {
            ++n3;
        }
        n = this.offScreenX(n);
        n2 = this.offScreenY(n2);
        Rectangle rectangle = new Rectangle(n - n4 / 2, n2 - n3 / 2, n4, n3);
        if (rectangle.x < 0) {
            rectangle.x = 0;
        }
        if (rectangle.y < 0) {
            rectangle.y = 0;
        }
        if (rectangle.x + n4 > this.imageWidth) {
            rectangle.x = this.imageWidth - n4;
        }
        if (rectangle.y + n3 > this.imageHeight) {
            rectangle.y = this.imageHeight - n3;
        }
        this.srcRect = rectangle;
        this.setMagnification(d);
    }

    protected Dimension canEnlarge(int n, int n2) {
        boolean bl;
        ImageWindow imageWindow = this.imp.getWindow();
        if (imageWindow == null) {
            return null;
        }
        Rectangle rectangle = imageWindow.getBounds();
        Insets insets = imageWindow.getInsets();
        Point point = this.getLocation();
        if (point.x > insets.left + 5 || point.y > insets.top + 5) {
            rectangle.width = n + insets.left + insets.right + 10;
            rectangle.height = n2 + insets.top + insets.bottom + 10;
            if (imageWindow instanceof StackWindow) {
                rectangle.height += 20;
            }
        } else {
            rectangle.width = rectangle.width - this.dstWidth + n + 10;
            rectangle.height = rectangle.height - this.dstHeight + n2 + 10;
        }
        Rectangle rectangle2 = imageWindow.getMaxWindow(rectangle.x, rectangle.y);
        boolean bl2 = rectangle.x + rectangle.width < rectangle2.x + rectangle2.width;
        boolean bl3 = bl = rectangle.y + rectangle.height < rectangle2.y + rectangle2.height;
        if (bl2 && bl) {
            return new Dimension(n, n2);
        }
        if (bl && n2 < this.dstWidth) {
            return new Dimension(this.dstWidth, n2);
        }
        if (bl2 && n < this.dstHeight) {
            return new Dimension(n, this.dstHeight);
        }
        return null;
    }

    public void zoomOut(int n, int n2) {
        if (this.magnification <= 0.03125) {
            return;
        }
        double d = this.magnification;
        double d2 = ImageCanvas.getLowerZoomLevel(this.magnification);
        double d3 = (double)this.srcRect.width / (double)this.srcRect.height;
        double d4 = (double)this.imageWidth / (double)this.imageHeight;
        double d5 = this.imp.getWindow().getInitialMagnification();
        if (Math.abs(d3 - d4) > 0.05) {
            double d6 = d / d2;
            int n3 = (int)Math.round((double)this.srcRect.width * d6);
            int n4 = (int)Math.round((double)this.srcRect.height * d6);
            if (n3 > this.imageWidth) {
                n3 = this.imageWidth;
            }
            if (n4 > this.imageHeight) {
                n4 = this.imageHeight;
            }
            int n5 = this.srcRect.x - (n3 - this.srcRect.width) / 2;
            int n6 = this.srcRect.y - (n4 - this.srcRect.height) / 2;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n6 < 0) {
                n6 = 0;
            }
            this.srcRect = new Rectangle(n5, n6, n3, n4);
            int n7 = (int)((double)this.srcRect.width * d2);
            int n8 = (int)((double)this.srcRect.height * d2);
            this.setMagnification(d2);
            this.setMaxBounds();
            if (n7 < this.dstWidth || n8 < this.dstHeight) {
                this.setDrawingSize(n7, n8);
                this.imp.getWindow().pack();
            } else {
                this.repaint();
            }
            return;
        }
        if ((double)this.imageWidth * d2 > (double)this.dstWidth) {
            int n9;
            int n10 = (int)Math.round((double)this.dstWidth / d2);
            if ((double)n10 * d2 < (double)this.dstWidth) {
                ++n10;
            }
            if ((double)(n9 = (int)Math.round((double)this.dstHeight / d2)) * d2 < (double)this.dstHeight) {
                ++n9;
            }
            n = this.offScreenX(n);
            n2 = this.offScreenY(n2);
            Rectangle rectangle = new Rectangle(n - n10 / 2, n2 - n9 / 2, n10, n9);
            if (rectangle.x < 0) {
                rectangle.x = 0;
            }
            if (rectangle.y < 0) {
                rectangle.y = 0;
            }
            if (rectangle.x + n10 > this.imageWidth) {
                rectangle.x = this.imageWidth - n10;
            }
            if (rectangle.y + n9 > this.imageHeight) {
                rectangle.y = this.imageHeight - n9;
            }
            this.srcRect = rectangle;
        } else {
            this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
            this.setDrawingSize((int)((double)this.imageWidth * d2), (int)((double)this.imageHeight * d2));
            this.imp.getWindow().pack();
        }
        this.setMagnification(d2);
        this.setMaxBounds();
        this.repaint();
    }

    public void unzoom() {
        double d = this.imp.getWindow().getInitialMagnification();
        if (this.magnification == d) {
            return;
        }
        this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
        ImageWindow imageWindow = this.imp.getWindow();
        this.setDrawingSize((int)((double)this.imageWidth * d), (int)((double)this.imageHeight * d));
        this.setMagnification(d);
        this.setMaxBounds();
        imageWindow.pack();
        this.setMaxBounds();
        this.repaint();
    }

    public void zoom100Percent() {
        if (this.magnification == 1.0) {
            return;
        }
        double d = this.imp.getWindow().getInitialMagnification();
        if (this.magnification != d) {
            this.unzoom();
        }
        if (this.magnification == 1.0) {
            return;
        }
        if (this.magnification < 1.0) {
            while (this.magnification < 1.0) {
                this.zoomIn(this.imageWidth / 2, this.imageHeight / 2);
            }
        } else if (this.magnification > 1.0) {
            while (this.magnification > 1.0) {
                this.zoomOut(this.imageWidth / 2, this.imageHeight / 2);
            }
        } else {
            return;
        }
        int n = this.xMouse;
        int n2 = this.yMouse;
        if (this.mouseExited) {
            n = this.imageWidth / 2;
            n2 = this.imageHeight / 2;
        }
        int n3 = this.screenX(n);
        int n4 = this.screenY(n2);
        this.adjustSourceRect(1.0, n3, n4);
        this.repaint();
    }

    protected void scroll(int n, int n2) {
        int n3 = this.xSrcStart + (int)((double)n / this.magnification);
        int n4 = this.ySrcStart + (int)((double)n2 / this.magnification);
        int n5 = this.xSrcStart + (this.xMouseStart - n3);
        int n6 = this.ySrcStart + (this.yMouseStart - n4);
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 + this.srcRect.width > this.imageWidth) {
            n5 = this.imageWidth - this.srcRect.width;
        }
        if (n6 + this.srcRect.height > this.imageHeight) {
            n6 = this.imageHeight - this.srcRect.height;
        }
        this.srcRect.x = n5;
        this.srcRect.y = n6;
        this.imp.draw();
        Thread.yield();
    }

    Color getColor(int n) {
        IndexColorModel indexColorModel = (IndexColorModel)this.imp.getProcessor().getColorModel();
        return new Color(indexColorModel.getRGB(n));
    }

    protected void setDrawingColor(int n, int n2, boolean bl) {
        Color color;
        int n3 = this.imp.getType();
        int[] nArray = this.imp.getPixel(n, n2);
        switch (n3) {
            case 0: {
                if (bl) {
                    this.setBackgroundColor(this.getColor(nArray[0]));
                    break;
                }
                this.setForegroundColor(this.getColor(nArray[0]));
                break;
            }
            case 1: 
            case 2: {
                double d = this.imp.getProcessor().getMin();
                double d2 = this.imp.getProcessor().getMax();
                double d3 = n3 == 2 ? (double)Float.intBitsToFloat(nArray[0]) : (double)nArray[0];
                int n4 = (int)(255.0 * ((d3 - d) / (d2 - d)));
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n4 > 255) {
                    n4 = 255;
                }
                if (bl) {
                    this.setBackgroundColor(this.getColor(n4));
                    break;
                }
                this.setForegroundColor(this.getColor(n4));
                break;
            }
            case 3: 
            case 4: {
                Color color2 = new Color(nArray[0], nArray[1], nArray[2]);
                if (bl) {
                    this.setBackgroundColor(color2);
                    break;
                }
                this.setForegroundColor(color2);
                break;
            }
        }
        if (bl) {
            color = Toolbar.getBackgroundColor();
        } else {
            color = Toolbar.getForegroundColor();
            this.imp.setColor(color);
        }
        IJ.showStatus("(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")");
    }

    private void setForegroundColor(Color color) {
        Toolbar.setForegroundColor(color);
        if (Recorder.record) {
            Recorder.record("setForegroundColor", color.getRed(), color.getGreen(), color.getBlue());
        }
    }

    private void setBackgroundColor(Color color) {
        Toolbar.setBackgroundColor(color);
        if (Recorder.record) {
            Recorder.record("setBackgroundColor", color.getRed(), color.getGreen(), color.getBlue());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Roi roi;
        if (this.ij == null) {
            return;
        }
        this.showCursorStatus = true;
        int n = Toolbar.getToolId();
        ImageWindow imageWindow = this.imp.getWindow();
        if (imageWindow != null && imageWindow.running2 && n != 11) {
            if (imageWindow instanceof StackWindow) {
                ((StackWindow)imageWindow).setAnimate(false);
            } else {
                imageWindow.running2 = false;
            }
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        this.flags = mouseEvent.getModifiers();
        if (n != 11 && (mouseEvent.isPopupTrigger() && mouseEvent.getButton() != 0 || !IJ.isMacintosh() && (this.flags & 4) != 0)) {
            this.handlePopupMenu(mouseEvent);
            return;
        }
        int n4 = this.offScreenX(n2);
        int n5 = this.offScreenY(n3);
        this.xMouse = n4;
        this.yMouse = n5;
        if (IJ.spaceBarDown()) {
            this.setupScroll(n4, n5);
            return;
        }
        if (this.showAllROIs && ((roi = this.imp.getRoi()) == null || !roi.contains(n4, n5) && roi.isHandle(n2, n3) < 0) && this.roiManagerSelect(n2, n3)) {
            return;
        }
        if (this.customRoi && this.overlay != null) {
            return;
        }
        switch (n) {
            case 11: {
                if (IJ.shiftKeyDown()) {
                    this.zoomToSelection(n4, n5);
                    break;
                }
                if ((this.flags & 0xE) != 0) {
                    this.zoomOut(n2, n3);
                    if (!(this.getMagnification() < 1.0)) break;
                    this.imp.repaintWindow();
                    break;
                }
                this.zoomIn(n2, n3);
                if (!(this.getMagnification() <= 1.0)) break;
                this.imp.repaintWindow();
                break;
            }
            case 12: {
                this.setupScroll(n4, n5);
                break;
            }
            case 13: {
                this.setDrawingColor(n4, n5, IJ.altKeyDown());
                break;
            }
            case 8: {
                int n6;
                Object object;
                roi = this.imp.getRoi();
                if (roi != null && roi.contains(n4, n5)) {
                    object = roi.getBounds();
                    if (((Rectangle)object).width == this.imageWidth && ((Rectangle)object).height == this.imageHeight) {
                        this.imp.killRoi();
                    } else if (!mouseEvent.isAltDown()) {
                        this.handleRoiMouseDown(mouseEvent);
                        return;
                    }
                }
                if (roi != null && (n6 = roi.isHandle(n2, n3)) >= 0) {
                    roi.mouseDownInHandle(n6, n2, n3);
                    return;
                }
                this.setRoiModState(mouseEvent, roi, -1);
                object = WandToolOptions.getMode();
                double d = WandToolOptions.getTolerance();
                int n7 = IJ.doWand(n4, n5, d, (String)object);
                if (!Recorder.record || n7 <= 0) break;
                if (d == 0.0 && ((String)object).equals("Legacy")) {
                    Recorder.record("doWand", n4, n5);
                    break;
                }
                Recorder.recordString("doWand(" + n4 + ", " + n5 + ", " + d + ", \"" + (String)object + "\");\n");
                break;
            }
            case 1: {
                if (Toolbar.getBrushSize() > 0) {
                    new RoiBrush();
                    break;
                }
                this.handleRoiMouseDown(mouseEvent);
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                Toolbar.getInstance().runMacroTool(n);
                break;
            }
            default: {
                this.handleRoiMouseDown(mouseEvent);
            }
        }
    }

    boolean roiManagerSelect(int n, int n2) {
        RoiManager roiManager = RoiManager.getInstance();
        if (roiManager == null) {
            return false;
        }
        Hashtable hashtable = roiManager.getROIs();
        List list = roiManager.getList();
        int n3 = list.getItemCount();
        if (this.labelRects == null || this.labelRects.length != n3) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (this.labelRects[i] == null || !this.labelRects[i].contains(n, n2)) continue;
            new MacroRunner("roiManager('select', " + i + "); roiManager('update2');");
            return true;
        }
        return false;
    }

    void zoomToSelection(int n, int n2) {
        IJ.setKeyUp(-1);
        String string = "args = split(getArgument);\nx1=parseInt(args[0]); y1=parseInt(args[1]); flags=20;\nwhile (flags&20!=0) {\ngetCursorLoc(x2, y2, z, flags);\nif (x2>=x1) x=x1; else x=x2;\nif (y2>=y1) y=y1; else y=y2;\nmakeRectangle(x, y, abs(x2-x1), abs(y2-y1));\nwait(10);\n}\nrun('To Selection');\n";
        new MacroRunner(string, n + " " + n2);
    }

    protected void setupScroll(int n, int n2) {
        this.xMouseStart = n;
        this.yMouseStart = n2;
        this.xSrcStart = this.srcRect.x;
        this.ySrcStart = this.srcRect.y;
    }

    protected void handlePopupMenu(MouseEvent mouseEvent) {
        PopupMenu popupMenu;
        if (this.disablePopupMenu) {
            return;
        }
        if (IJ.debugMode) {
            IJ.log("show popup: " + (mouseEvent.isPopupTrigger() ? "true" : "false"));
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Roi roi = this.imp.getRoi();
        if (roi != null && (roi.getType() == 2 || roi.getType() == 6 || roi.getType() == 8)) {
            if (roi.getState() == 0) {
                roi.handleMouseUp(n, n2);
                roi.handleMouseUp(n, n2);
                return;
            }
        }
        if ((popupMenu = Menus.getPopupMenu()) != null) {
            this.add(popupMenu);
            if (IJ.isMacOSX()) {
                IJ.wait(10);
            }
            popupMenu.show(this, n, n2);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        ImageWindow imageWindow = this.imp.getWindow();
        if (imageWindow != null) {
            this.setCursor(defaultCursor);
        }
        IJ.showStatus("");
        this.mouseExited = true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.xMouse = this.offScreenX(n);
        this.yMouse = this.offScreenY(n2);
        this.flags = mouseEvent.getModifiers();
        if (this.flags == 0) {
            this.flags = 16;
        }
        if (Toolbar.getToolId() == 12 || IJ.spaceBarDown()) {
            this.scroll(n, n2);
        } else {
            IJ.setInputEvent(mouseEvent);
            Roi roi = this.imp.getRoi();
            if (roi != null) {
                roi.handleMouseDrag(n, n2, this.flags);
            }
        }
    }

    protected void handleRoiMouseDown(MouseEvent mouseEvent) {
        boolean bl;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.offScreenX(n);
        int n4 = this.offScreenY(n2);
        Roi roi = this.imp.getRoi();
        int n5 = roi != null ? roi.isHandle(n, n2) : -1;
        boolean bl2 = bl = roi != null && roi instanceof PointRoi && n5 == -1 && Toolbar.getToolId() == 7 && Toolbar.getMultiPointMode();
        if (bl) {
            this.imp.setRoi(((PointRoi)roi).addPoint(n3, n4));
            return;
        }
        this.setRoiModState(mouseEvent, roi, n5);
        if (roi != null) {
            int n6;
            if (n5 >= 0) {
                roi.mouseDownInHandle(n5, n, n2);
                return;
            }
            Rectangle rectangle = roi.getBounds();
            int n7 = roi.getType();
            if (n7 == 0 && rectangle.width == this.imp.getWidth() && rectangle.height == this.imp.getHeight() && roi.getPasteMode() == -1 && !(roi instanceof ImageRoi)) {
                this.imp.killRoi();
                return;
            }
            if (roi.contains(n3, n4)) {
                if (roi.modState == 0) {
                    roi.handleMouseDown(n, n2);
                } else {
                    this.imp.killRoi();
                    this.imp.createNewRoi(n, n2);
                }
                return;
            }
            if (n7 == 2 || n7 == 6 || n7 == 8) {
                if (roi.getState() == 0) {
                    return;
                }
            }
            if (!((n6 = Toolbar.getToolId()) != 2 && n6 != 5 && n6 != 14 || IJ.shiftKeyDown() || IJ.altKeyDown())) {
                this.imp.killRoi();
                return;
            }
        }
        this.imp.createNewRoi(n, n2);
    }

    void setRoiModState(MouseEvent mouseEvent, Roi roi, int n) {
        if (roi == null || n >= 0 && roi.modState == 0) {
            return;
        }
        if (roi.state == 0) {
            return;
        }
        int n2 = Toolbar.getToolId();
        if (n2 > 3 && n2 != 8 && n2 != 7) {
            roi.modState = 0;
            return;
        }
        roi.modState = mouseEvent.isShiftDown() ? 1 : (mouseEvent.isAltDown() ? 2 : 0);
    }

    public void disablePopupMenu(boolean bl) {
        this.disablePopupMenu = bl;
    }

    public void setShowAllROIs(boolean bl) {
        this.showAllROIs = bl;
    }

    public boolean getShowAllROIs() {
        return this.showAllROIs;
    }

    public Overlay getShowAllList() {
        if (!this.showAllROIs) {
            return null;
        }
        if (this.showAllList != null) {
            return this.showAllList;
        }
        RoiManager roiManager = RoiManager.getInstance();
        if (roiManager == null) {
            return null;
        }
        Roi[] roiArray = roiManager.getRoisAsArray();
        if (roiArray.length == 0) {
            return null;
        }
        Overlay overlay = new Overlay();
        for (int i = 0; i < roiArray.length; ++i) {
            overlay.add((Roi)roiArray[i].clone());
        }
        return overlay;
    }

    public static Color getShowAllColor() {
        if (showAllColor != null && showAllColor.getRGB() == -8323073) {
            showAllColor = Color.cyan;
        }
        return showAllColor;
    }

    public static void setShowAllColor(Color color) {
        ImageCanvas imageCanvas;
        if (color == null) {
            return;
        }
        showAllColor = color;
        labelColor = null;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null && (imageCanvas = imagePlus.getCanvas()) != null && imageCanvas.getShowAllROIs()) {
            imagePlus.draw();
        }
    }

    public void setOverlay(Overlay overlay) {
        this.overlay = overlay;
        this.repaint();
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public void setDisplayList(Vector vector) {
        if (vector != null) {
            Overlay overlay = new Overlay();
            overlay.setVector(vector);
            this.setOverlay(overlay);
        } else {
            this.setOverlay(null);
        }
        if (this.overlay != null) {
            this.overlay.drawLabels(this.overlay.size() > 0 && this.overlay.get(0).getStrokeColor() == null);
        } else {
            this.customRoi = false;
        }
        this.repaint();
    }

    public void setDisplayList(Shape shape, Color color, BasicStroke basicStroke) {
        if (shape == null) {
            this.setOverlay(null);
            return;
        }
        ShapeRoi shapeRoi = new ShapeRoi(shape);
        shapeRoi.setStrokeColor(color);
        shapeRoi.setStroke(basicStroke);
        Overlay overlay = new Overlay();
        overlay.add(shapeRoi);
        this.setOverlay(overlay);
    }

    public void setDisplayList(Roi roi, Color color) {
        roi.setStrokeColor(color);
        Overlay overlay = new Overlay();
        overlay.add(roi);
        this.setOverlay(overlay);
    }

    public Vector getDisplayList() {
        if (this.overlay == null) {
            return null;
        }
        Vector<Roi> vector = new Vector<Roi>();
        for (int i = 0; i < this.overlay.size(); ++i) {
            vector.add(this.overlay.get(i));
        }
        return vector;
    }

    public void setCustomRoi(boolean bl) {
        this.customRoi = bl;
    }

    public void setShowCursorStatus(boolean bl) {
        this.showCursorStatus = bl;
        if (bl) {
            this.sy2 = -1000;
            this.sx2 = -1000;
        } else {
            this.sx2 = this.screenX(this.xMouse);
            this.sy2 = this.screenY(this.yMouse);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        this.flags = mouseEvent.getModifiers();
        this.flags &= 0xFFFFFFEF;
        this.flags &= 0xFFFFFFF7;
        this.flags &= 0xFFFFFFFB;
        Roi roi = this.imp.getRoi();
        if (roi == null) return;
        Rectangle rectangle = roi.getBounds();
        int n = roi.getType();
        if (!(rectangle.width != 0 && rectangle.height != 0 || n == 2 || n == 6 || n == 8 || n == 5 || roi instanceof TextRoi)) {
            if (roi.getState() == 0) {
                if (n != 10) {
                    this.imp.killRoi();
                    return;
                }
            }
        }
        roi.handleMouseUp(mouseEvent.getX(), mouseEvent.getY());
        if (roi.getType() != 5) return;
        if (roi.getLength() != 0.0) return;
        this.imp.killRoi();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2;
        int n3;
        int n4;
        block7: {
            Roi roi;
            block8: {
                if (this.ij == null) {
                    return;
                }
                n4 = mouseEvent.getX();
                n3 = mouseEvent.getY();
                n2 = this.offScreenX(n4);
                n = this.offScreenY(n3);
                this.flags = mouseEvent.getModifiers();
                this.setCursor(n4, n3, n2, n);
                IJ.setInputEvent(mouseEvent);
                roi = this.imp.getRoi();
                if (roi == null) break block7;
                if (roi.getType() == 2 || roi.getType() == 6) break block8;
                if (roi.getType() != 8) break block7;
            }
            if (roi.getState() == 0) {
                PolygonRoi polygonRoi = (PolygonRoi)roi;
                polygonRoi.handleMouseMove(n2, n);
                return;
            }
        }
        if (n2 < this.imageWidth && n < this.imageHeight) {
            ImageWindow imageWindow = this.imp.getWindow();
            if ((n4 - this.sx2) * (n4 - this.sx2) + (n3 - this.sy2) * (n3 - this.sy2) > 144) {
                this.showCursorStatus = true;
            }
            if (imageWindow == null) return;
            if (!this.showCursorStatus) return;
            imageWindow.mouseMoved(n2, n);
            return;
        }
        IJ.showStatus("");
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    static {
        showAllColor = Prefs.getColor("showcolor", new Color(0, 255, 255));
        zoomLevels = new double[]{0.013888888888888888, 0.020833333333333332, 0.03125, 0.041666666666666664, 0.0625, 0.08333333333333333, 0.125, 0.16666666666666666, 0.25, 0.3333333333333333, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 6.0, 8.0, 12.0, 16.0, 24.0, 32.0};
    }
}

