/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.macro.Interpreter;
import ij.process.ImageProcessor;
import ij.util.Java2;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class TextRoi
extends Roi {
    static final int MAX_LINES = 50;
    private String[] theText = new String[50];
    private static String name = "SansSerif";
    private static int style = 0;
    private static int size = 18;
    private Font instanceFont;
    private static boolean newFont = true;
    private static boolean antialiasedText = true;
    private static boolean recordSetFont = true;
    private double previousMag;
    private boolean firstChar = true;
    private boolean firstMouseUp = true;
    private int cline = 0;

    public TextRoi(int n, int n2, String string) {
        this(n, n2, string, null);
    }

    public TextRoi(int n, int n2, String string, Font font) {
        super(n, n2, 1, 1);
        String[] stringArray = Tools.split(string, "\n");
        int n3 = Math.min(stringArray.length, 50);
        for (int i = 0; i < n3; ++i) {
            this.theText[i] = stringArray[i];
        }
        if (font == null) {
            font = new Font(name, style, size);
        }
        this.instanceFont = font;
        this.firstChar = false;
        if (IJ.debugMode) {
            IJ.log("TextRoi: " + this.theText[0] + "  " + this.width + "," + this.height);
        }
    }

    public TextRoi(int n, int n2, String string, Font font, Color color) {
        super(n, n2, 1, 1);
        if (font == null) {
            font = new Font(name, style, size);
        }
        this.instanceFont = font;
        IJ.error("TextRoi", "API has changed. See updated example at\nhttp://imagej.nih.gov/ij/macros/js/TextOverlay.js");
    }

    public TextRoi(int n, int n2, ImagePlus imagePlus) {
        super(n, n2, imagePlus);
        double d;
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        double d2 = d = imageCanvas != null ? imageCanvas.getMagnification() : 1.0;
        if (d > 1.0) {
            d = 1.0;
        }
        if ((double)size < 12.0 / d) {
            size = (int)(12.0 / d);
        }
        this.theText[0] = "Type, then";
        this.theText[1] = "Ctl+D";
        if (previousRoi != null && previousRoi instanceof TextRoi) {
            this.firstMouseUp = false;
            previousRoi = null;
        }
        this.instanceFont = new Font(name, style, size);
    }

    public void addChar(char c) {
        if (this.imp == null) {
            return;
        }
        if (c < ' ' && c != '\b' && c != '\n') {
            return;
        }
        if (this.firstChar) {
            this.cline = 0;
            this.theText[this.cline] = new String("");
            for (int i = 1; i < 50; ++i) {
                this.theText[i] = null;
            }
        }
        if (c == '\b') {
            if (this.theText[this.cline].length() > 0) {
                this.theText[this.cline] = this.theText[this.cline].substring(0, this.theText[this.cline].length() - 1);
            } else if (this.cline > 0) {
                this.theText[this.cline] = null;
                --this.cline;
            }
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.firstChar = false;
            return;
        }
        if (c == '\n') {
            if (this.cline < 49) {
                ++this.cline;
            }
        } else {
            char[] cArray = new char[]{c};
            int n = this.cline;
            this.theText[n] = this.theText[n] + new String(cArray);
            this.updateBounds(null);
            this.updateText();
            this.firstChar = false;
            return;
        }
        this.theText[this.cline] = "";
        this.updateBounds(null);
        this.updateText();
    }

    Font getScaledFont() {
        if (this.nonScalable) {
            return this.instanceFont;
        }
        if (this.instanceFont == null) {
            this.instanceFont = new Font(name, style, size);
        }
        double d = this.ic != null ? this.ic.getMagnification() : 1.0;
        return this.instanceFont.deriveFont((float)((double)this.instanceFont.getSize() * d));
    }

    public void drawPixels(ImageProcessor imageProcessor) {
        imageProcessor.setFont(this.instanceFont);
        imageProcessor.setAntialiasedText(antialiasedText);
        FontMetrics fontMetrics = imageProcessor.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getDescent();
        int n3 = 0;
        int n4 = 0;
        while (n3 < 50 && this.theText[n3] != null) {
            imageProcessor.drawString(this.theText[n3], this.x, this.y + n4 + n);
            ++n3;
            n4 += n;
        }
    }

    public void draw(Graphics graphics) {
        if (IJ.debugMode) {
            IJ.log("draw: " + this.theText[0] + "  " + this.width + "," + this.height);
        }
        if (this.ic == null) {
            return;
        }
        if (Interpreter.isBatchMode() && this.ic.getDisplayList() != null) {
            return;
        }
        if (newFont || this.width == 1) {
            this.updateBounds(graphics);
        }
        super.draw(graphics);
        double d = this.ic.getMagnification();
        int n = this.ic.screenX(this.x);
        int n2 = this.ic.screenY(this.y);
        int n3 = (int)((double)this.width * d);
        int n4 = (int)((double)this.height * d);
        Rectangle rectangle = null;
        rectangle = graphics.getClipBounds();
        graphics.setClip(n, n2, n3, n4);
        this.drawText(graphics);
        if (rectangle != null) {
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    void drawText(Graphics graphics) {
        if (this.hide) {
            this.hide = false;
            return;
        }
        graphics.setColor(this.strokeColor != null ? this.strokeColor : ROIColor);
        Java2.setAntialiasedText(graphics, antialiasedText);
        if (newFont || this.width == 1) {
            this.updateBounds(graphics);
        }
        double d = this.ic.getMagnification();
        int n = this.nonScalable ? this.x : this.ic.screenX(this.x);
        int n2 = this.nonScalable ? this.y : this.ic.screenY(this.y);
        Font font = this.getScaledFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n3 = fontMetrics.getHeight();
        int n4 = fontMetrics.getDescent();
        graphics.setFont(font);
        int n5 = 0;
        if (this.fillColor != null) {
            Color color;
            if (this.getStrokeWidth() < 10.0f) {
                color = this.fillColor;
                this.setStrokeWidth(10.0f);
                this.fillColor = color;
            }
            this.updateBounds(graphics);
            color = graphics.getColor();
            int n6 = this.fillColor.getAlpha();
            graphics.setColor(this.fillColor);
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n7 = this.nonScalable ? this.width : (int)(this.ic.getMagnification() * (double)this.width);
            int n8 = this.nonScalable ? this.height : (int)(this.ic.getMagnification() * (double)this.height);
            graphics.fillRect(n - 5, n2 - 5, n7 + 10, n8 + 10);
            graphics.setColor(color);
        }
        while (n5 < 50 && this.theText[n5] != null) {
            graphics.drawString(this.theText[n5], n, n2 + n3 - n4);
            ++n5;
            n2 += n3;
        }
    }

    public static String getFont() {
        return name;
    }

    public static int getSize() {
        return size;
    }

    public static int getStyle() {
        return style;
    }

    public void setCurrentFont(Font font) {
        this.instanceFont = font;
        this.updateBounds(null);
    }

    public Font getCurrentFont() {
        return this.instanceFont;
    }

    public static boolean isAntialiased() {
        return antialiasedText;
    }

    public static void setFont(String string, int n, int n2) {
        recordSetFont = true;
        TextRoi.setFont(string, n, n2, true);
    }

    public static void setFont(String string, int n, int n2, boolean bl) {
        Roi roi;
        recordSetFont = true;
        name = string;
        size = n;
        style = n2;
        antialiasedText = bl;
        newFont = true;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null && (roi = imagePlus.getRoi()) instanceof TextRoi) {
            ((TextRoi)roi).setCurrentFont(new Font(name, style, size));
            imagePlus.draw();
        }
    }

    protected void handleMouseUp(int n, int n2) {
        super.handleMouseUp(n, n2);
        if (this.firstMouseUp) {
            this.updateBounds(null);
            this.updateText();
            this.firstMouseUp = false;
        } else if (this.width < 5 || this.height < 5) {
            this.imp.killRoi();
        }
    }

    void updateBounds(Graphics graphics) {
        boolean bl;
        if (this.ic == null) {
            return;
        }
        double d = this.ic.getMagnification();
        if (this.nonScalable) {
            d = 1.0;
        }
        Font font = this.getScaledFont();
        newFont = false;
        boolean bl2 = bl = graphics == null;
        if (bl) {
            graphics = this.ic.getGraphics();
        }
        Java2.setAntialiasedText(graphics, true);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = (int)((double)fontMetrics.getHeight() / d);
        int n2 = fontMetrics.getDescent();
        int n3 = 0;
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.width = 10;
        for (int i = 0; i < 50 && this.theText[i] != null; ++i) {
            ++n3;
            int n4 = (int)((double)this.stringWidth(this.theText[i], fontMetrics, graphics) / d);
            if (n4 <= this.width) continue;
            this.width = n4;
        }
        if (bl) {
            graphics.dispose();
        }
        this.width += 2;
        if (this.xMax != 0 && this.x + this.width > this.xMax) {
            this.x = this.xMax - this.width;
        }
        this.height = n3 * n + 2;
        if (this.yMax != 0) {
            if (this.height > this.yMax) {
                this.height = this.yMax;
            }
            if (this.y + this.height > this.yMax) {
                this.y = this.yMax - this.height;
            }
        }
    }

    void updateText() {
        if (this.imp != null) {
            this.updateClipRect();
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        }
    }

    int stringWidth(String string, FontMetrics fontMetrics, Graphics graphics) {
        return Java2.getStringWidth(string, fontMetrics, graphics);
    }

    public String getMacroCode(ImageProcessor imageProcessor) {
        Object object;
        String string = "";
        if (recordSetFont) {
            object = "";
            if (style == 1) {
                object = (String)object + "bold";
            }
            if (style == 2) {
                object = (String)object + " italic";
            }
            if (antialiasedText) {
                object = (String)object + " antialiased";
            }
            if (((String)object).equals("")) {
                object = "plain";
            }
            string = string + "setFont(\"" + name + "\", " + size + ", \"" + (String)object + "\");\n";
            recordSetFont = false;
        }
        object = imageProcessor.getFontMetrics();
        int n = ((FontMetrics)object).getHeight();
        String string2 = "";
        for (int i = 0; i < 50 && this.theText[i] != null; ++i) {
            string2 = string2 + this.theText[i];
            if (this.theText[i + 1] == null) continue;
            string2 = string2 + "\\n";
        }
        string = string + "makeText(\"" + string2 + "\", " + this.x + ", " + (this.y + n) + ");\n";
        string = string + "//drawString(\"" + string2 + "\", " + this.x + ", " + (this.y + n) + ");\n";
        return string;
    }

    public String getText() {
        String string = "";
        for (int i = 0; i < 50 && this.theText[i] != null; ++i) {
            string = string + this.theText[i] + "\n";
        }
        return string;
    }

    public static void recordSetFont() {
        recordSetFont = true;
    }

    public boolean isDrawingTool() {
        return true;
    }

    public synchronized Object clone() {
        TextRoi textRoi = (TextRoi)super.clone();
        textRoi.theText = new String[50];
        for (int i = 0; i < 50; ++i) {
            textRoi.theText[i] = this.theText[i];
        }
        return textRoi;
    }
}

