/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.Resizer;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Scaler
implements PlugIn,
TextListener,
FocusListener {
    private ImagePlus imp;
    private static String xstr = "0.5";
    private static String ystr = "0.5";
    private String zstr = "1.0";
    private static int newWidth;
    private static int newHeight;
    private int newDepth;
    private static boolean averageWhenDownsizing;
    private static boolean newWindow;
    private static int interpolationMethod;
    private String[] methods = ImageProcessor.getInterpolationMethods();
    private static boolean fillWithBackground;
    private static boolean processStack;
    private double xscale;
    private double yscale;
    private double zscale;
    private String title = "Untitled";
    private Vector fields;
    private double bgValue;
    private boolean constainAspectRatio = true;
    private TextField xField;
    private TextField yField;
    private TextField zField;
    private TextField widthField;
    private TextField heightField;
    private TextField depthField;
    private Rectangle r;
    private Object fieldWithFocus;
    private int oldDepth;

    public void run(String string) {
        ImageProcessor imageProcessor;
        this.imp = IJ.getImage();
        Roi roi = this.imp.getRoi();
        if (roi != null && !roi.isArea()) {
            this.imp.killRoi();
        }
        if (!this.showDialog(imageProcessor = this.imp.getProcessor())) {
            return;
        }
        if (this.newDepth > 0 && this.newDepth != this.imp.getStackSize()) {
            newWindow = true;
            processStack = true;
        }
        if (imageProcessor.getWidth() > 1 && imageProcessor.getHeight() > 1) {
            imageProcessor.setInterpolationMethod(interpolationMethod);
        } else {
            imageProcessor.setInterpolationMethod(0);
        }
        imageProcessor.setBackgroundValue(this.bgValue);
        this.imp.startTiming();
        try {
            if (newWindow && this.imp.getStackSize() > 1 && processStack) {
                this.createNewStack(this.imp, imageProcessor);
            } else {
                this.scale(imageProcessor);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("Scale");
        }
        IJ.showProgress(1.0);
    }

    void createNewStack(ImagePlus imagePlus, ImageProcessor imageProcessor) {
        Object object;
        int n = imagePlus.getStackSize();
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        ImagePlus imagePlus2 = imagePlus.createImagePlus();
        if (newWidth != n2 || newHeight != n3) {
            object = imageProcessor.getRoi();
            boolean bl = ((Rectangle)object).width != imagePlus.getWidth() || ((Rectangle)object).height != imagePlus.getHeight();
            ImageStack imageStack = imagePlus.getStack();
            ImageStack imageStack2 = new ImageStack(newWidth, newHeight);
            int n4 = interpolationMethod;
            if (n2 == 1 || n3 == 1) {
                n4 = 0;
            }
            for (int i = 1; i <= n; ++i) {
                IJ.showStatus("Scale: " + i + "/" + n);
                ImageProcessor imageProcessor2 = imageStack.getProcessor(i);
                String string = imageStack.getSliceLabel(i);
                if (bl) {
                    imageProcessor2.setRoi((Rectangle)object);
                    imageProcessor2 = imageProcessor2.crop();
                }
                imageProcessor2.setInterpolationMethod(n4);
                ImageProcessor imageProcessor3 = imageProcessor2.resize(newWidth, newHeight, averageWhenDownsizing);
                if (imageProcessor3 != null) {
                    imageStack2.addSlice(string, imageProcessor3);
                }
                IJ.showProgress(i, n);
            }
            imagePlus2.setStack(this.title, imageStack2);
            Calibration calibration = imagePlus2.getCalibration();
            if (calibration.scaled()) {
                calibration.pixelWidth *= 1.0 / this.xscale;
                calibration.pixelHeight *= 1.0 / this.yscale;
            }
            IJ.showProgress(1.0);
        } else {
            imagePlus2.setStack(this.title, imagePlus.getStack());
        }
        object = imagePlus.getDimensions();
        imagePlus2.setDimensions((int)object[2], (int)object[3], (int)object[4]);
        if (imagePlus.isComposite()) {
            imagePlus2 = new CompositeImage(imagePlus2, ((CompositeImage)imagePlus).getMode());
            ((CompositeImage)imagePlus2).copyLuts(imagePlus);
        }
        if (imagePlus.isHyperStack()) {
            imagePlus2.setOpenAsHyperStack(true);
        }
        if (this.newDepth > 0 && this.newDepth != this.oldDepth) {
            imagePlus2 = new Resizer().zScale(imagePlus2, this.newDepth, interpolationMethod);
        }
        if (imagePlus2 != null) {
            imagePlus2.show();
            imagePlus2.changes = true;
        }
    }

    void scale(ImageProcessor imageProcessor) {
        if (newWindow) {
            Rectangle rectangle = imageProcessor.getRoi();
            ImagePlus imagePlus = this.imp.createImagePlus();
            imagePlus.setProcessor(this.title, imageProcessor.resize(newWidth, newHeight, averageWhenDownsizing));
            Calibration calibration = imagePlus.getCalibration();
            if (calibration.scaled()) {
                calibration.pixelWidth *= 1.0 / this.xscale;
                calibration.pixelHeight *= 1.0 / this.yscale;
            }
            imagePlus.show();
            this.imp.trimProcessor();
            imagePlus.trimProcessor();
            imagePlus.changes = true;
        } else {
            if (processStack && this.imp.getStackSize() > 1) {
                Undo.reset();
                StackProcessor stackProcessor = new StackProcessor(this.imp.getStack(), imageProcessor);
                stackProcessor.scale(this.xscale, this.yscale, this.bgValue);
            } else {
                imageProcessor.snapshot();
                Undo.setup(1, this.imp);
                imageProcessor.setSnapshotCopyMode(true);
                imageProcessor.scale(this.xscale, this.yscale);
                imageProcessor.setSnapshotCopyMode(false);
            }
            this.imp.killRoi();
            this.imp.updateAndDraw();
            this.imp.changes = true;
        }
    }

    boolean showDialog(ImageProcessor imageProcessor) {
        String string = Macro.getOptions();
        if (string != null) {
            if (string.indexOf(" interpolate") != -1) {
                string.replaceAll(" interpolate", " interpolation=Bilinear");
            } else if (string.indexOf(" interpolation=") == -1) {
                string = string + " interpolation=None";
            }
            Macro.setOptions(string);
        }
        int n = this.imp.getBitDepth();
        int n2 = this.imp.getStackSize();
        boolean bl = n2 > 1;
        this.oldDepth = n2;
        if (bl) {
            xstr = "1.0";
            ystr = "1.0";
            this.zstr = "1.0";
        }
        this.r = imageProcessor.getRoi();
        int n3 = newWidth;
        if (n3 == 0) {
            n3 = this.r.width;
        }
        int n4 = (int)((double)n3 * (double)this.r.height / (double)this.r.width);
        this.xscale = Tools.parseDouble(xstr, 0.0);
        this.yscale = Tools.parseDouble(ystr, 0.0);
        this.zscale = 1.0;
        if (this.xscale != 0.0 && this.yscale != 0.0) {
            n3 = (int)((double)this.r.width * this.xscale);
            n4 = (int)((double)this.r.height * this.yscale);
        } else {
            xstr = "-";
            ystr = "-";
        }
        GenericDialog genericDialog = new GenericDialog("Scale");
        genericDialog.addStringField("X Scale:", xstr);
        genericDialog.addStringField("Y Scale:", ystr);
        if (bl) {
            genericDialog.addStringField("Z Scale:", this.zstr);
        }
        genericDialog.setInsets(5, 0, 5);
        genericDialog.addStringField("Width (pixels):", "" + n3);
        genericDialog.addStringField("Height (pixels):", "" + n4);
        if (bl) {
            String string2 = "Depth (images):";
            if (this.imp.isHyperStack()) {
                int n5 = this.imp.getNSlices();
                int n6 = this.imp.getNFrames();
                if (n5 == 1 && n6 > 1) {
                    string2 = "Depth (frames):";
                    this.oldDepth = n6;
                } else {
                    string2 = "Depth (slices):";
                    this.oldDepth = n5;
                }
            }
            genericDialog.addStringField(string2, "" + this.oldDepth);
        }
        this.fields = genericDialog.getStringFields();
        for (int i = 0; i < this.fields.size(); ++i) {
            ((TextField)this.fields.elementAt(i)).addTextListener(this);
            ((TextField)this.fields.elementAt(i)).addFocusListener(this);
        }
        this.xField = (TextField)this.fields.elementAt(0);
        this.yField = (TextField)this.fields.elementAt(1);
        if (bl) {
            this.zField = (TextField)this.fields.elementAt(2);
            this.widthField = (TextField)this.fields.elementAt(3);
            this.heightField = (TextField)this.fields.elementAt(4);
            this.depthField = (TextField)this.fields.elementAt(5);
        } else {
            this.widthField = (TextField)this.fields.elementAt(2);
            this.heightField = (TextField)this.fields.elementAt(3);
        }
        this.fieldWithFocus = this.xField;
        genericDialog.addChoice("Interpolation:", this.methods, this.methods[interpolationMethod]);
        if (n == 8 || n == 24) {
            genericDialog.addCheckbox("Fill with background color", fillWithBackground);
        }
        genericDialog.addCheckbox("Average when downsizing", averageWhenDownsizing);
        if (bl) {
            genericDialog.addCheckbox("Process entire stack", processStack);
        }
        genericDialog.addCheckbox("Create new window", newWindow);
        this.title = WindowManager.getUniqueName(this.imp.getTitle());
        genericDialog.setInsets(10, 0, 0);
        genericDialog.addStringField("Title:", this.title, 12);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        xstr = genericDialog.getNextString();
        ystr = genericDialog.getNextString();
        this.xscale = Tools.parseDouble(xstr, 0.0);
        this.yscale = Tools.parseDouble(ystr, 0.0);
        if (bl) {
            this.zstr = genericDialog.getNextString();
            this.zscale = Tools.parseDouble(ystr, 0.0);
        }
        String string3 = genericDialog.getNextString();
        newWidth = (int)Tools.parseDouble(string3, 0.0);
        newHeight = (int)Tools.parseDouble(genericDialog.getNextString(), 0.0);
        if (newHeight != 0 && (string3.equals("-") || string3.equals("0"))) {
            newWidth = (int)((double)newHeight * (double)this.r.width / (double)this.r.height);
        }
        if (newWidth == 0 || newHeight == 0) {
            IJ.error("Scaler", "Width or height is 0");
            return false;
        }
        if (this.xscale > 25.0) {
            this.xscale = 25.0;
        }
        if (this.yscale > 25.0) {
            this.yscale = 25.0;
        }
        if (this.xscale > 0.0 && this.yscale > 0.0) {
            newWidth = (int)((double)this.r.width * this.xscale);
            newHeight = (int)((double)this.r.height * this.yscale);
        }
        if (bl) {
            this.newDepth = (int)Tools.parseDouble(genericDialog.getNextString(), 0.0);
        }
        interpolationMethod = genericDialog.getNextChoiceIndex();
        if (n == 8 || n == 24) {
            fillWithBackground = genericDialog.getNextBoolean();
        }
        averageWhenDownsizing = genericDialog.getNextBoolean();
        if (bl) {
            processStack = genericDialog.getNextBoolean();
        }
        newWindow = genericDialog.getNextBoolean();
        if (this.xscale == 0.0) {
            this.xscale = (double)newWidth / (double)this.r.width;
            this.yscale = (double)newHeight / (double)this.r.height;
        }
        this.title = genericDialog.getNextString();
        if (fillWithBackground) {
            Color color = Toolbar.getBackgroundColor();
            if (n == 8) {
                this.bgValue = imageProcessor.getBestIndex(color);
            } else if (n == 24) {
                this.bgValue = color.getRGB();
            }
        } else {
            this.bgValue = 0.0;
        }
        return true;
    }

    public void textValueChanged(TextEvent textEvent) {
        int n;
        Object object = textEvent.getSource();
        double d = this.xscale;
        double d2 = this.yscale;
        double d3 = this.zscale;
        if (object == this.xField && this.fieldWithFocus == this.xField) {
            String string = this.xField.getText();
            d = Tools.parseDouble(string, 0.0);
            if (d == 0.0) {
                return;
            }
            if (d != this.xscale) {
                int n2 = (int)(d * (double)this.r.width);
                this.widthField.setText("" + n2);
                if (this.constainAspectRatio) {
                    this.yField.setText(string);
                    int n3 = (int)(d * (double)this.r.height);
                    this.heightField.setText("" + n3);
                }
            }
        } else if (object == this.yField && this.fieldWithFocus == this.yField) {
            String string = this.yField.getText();
            d2 = Tools.parseDouble(string, 0.0);
            if (d2 == 0.0) {
                return;
            }
            if (d2 != this.yscale) {
                int n4 = (int)(d2 * (double)this.r.height);
                this.heightField.setText("" + n4);
            }
        } else if (object == this.zField && this.fieldWithFocus == this.zField) {
            String string = this.zField.getText();
            d3 = Tools.parseDouble(string, 0.0);
            if (d3 == 0.0) {
                return;
            }
            if (d3 != this.zscale) {
                int n5 = (int)(d3 * (double)this.imp.getStackSize());
                this.depthField.setText("" + n5);
            }
        } else if (object == this.widthField && this.fieldWithFocus == this.widthField) {
            int n6 = (int)Tools.parseDouble(this.widthField.getText(), 0.0);
            if (n6 != 0) {
                int n7 = (int)((double)n6 * (double)this.r.height / (double)this.r.width);
                this.heightField.setText("" + n7);
                this.xField.setText("-");
                this.yField.setText("-");
                d = 0.0;
                d2 = 0.0;
            }
        } else if (object == this.depthField && this.fieldWithFocus == this.depthField && (n = (int)Tools.parseDouble(this.depthField.getText(), 0.0)) != 0) {
            this.zField.setText("-");
            d3 = 0.0;
        }
        this.xscale = d;
        this.yscale = d2;
        this.zscale = d3;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.fieldWithFocus = focusEvent.getSource();
        if (this.fieldWithFocus == this.widthField) {
            this.constainAspectRatio = true;
        } else if (this.fieldWithFocus == this.yField) {
            this.constainAspectRatio = false;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    static {
        averageWhenDownsizing = true;
        newWindow = true;
        interpolationMethod = 1;
        processStack = true;
    }
}

