/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.PlugIn;

public class StackReverser
implements PlugIn {
    public void run(String string) {
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus.getStackSize() == 1) {
            IJ.error("Flip Z", "This command requires a stack");
            return;
        }
        if (imagePlus.isHyperStack()) {
            IJ.error("Flip Z", "This command does not currently work with hyperstacks.");
            return;
        }
        this.flipStack(imagePlus);
    }

    public void flipStack(ImagePlus imagePlus) {
        int n;
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = imagePlus.createEmptyStack();
        while ((n = imageStack.getSize()) > 0) {
            imageStack2.addSlice(imageStack.getSliceLabel(n), imageStack.getProcessor(n));
            imageStack.deleteLastSlice();
        }
        imagePlus.setStack(null, imageStack2);
    }
}

