/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.gui.Toolbar;
import ij.process.ColorProcessor;
import java.awt.Color;

class ColorGenerator
extends ColorProcessor {
    int w;
    int h;
    int[] colors = new int[]{0xFF0000, 65280, 255, 0xFFFFFF, 65535, 0xFF00FF, 0xFFFF00, 0};

    public ColorGenerator(int n, int n2, int[] nArray) {
        super(n, n2, nArray);
    }

    void drawColors(int n, int n2, int n3, int n4) {
        this.w = n;
        this.h = n2;
        this.setColor(0xFFFFFF);
        this.setRoi(0, 0, 110, 320);
        this.fill();
        this.drawRamp();
        this.resetBW();
        this.flipper();
        this.drawLine(0, 256, 110, 256);
        int n5 = 1;
        int n6 = 0;
        this.refreshBackground();
        this.refreshForeground();
        float f = 1.0f;
        float f2 = 1.0f;
        double d = n;
        double d2 = n2;
        for (n5 = 2; n5 < 10; ++n5) {
            for (n6 = 0; n6 < 32; ++n6) {
                float f3 = (float)((double)n6 / (2.0 * d2) - 0.15);
                if (n5 < 6) {
                    f = 1.0f;
                    f2 = (float)((double)(n5 * 4) / d);
                } else {
                    f = 1.0f - (float)((double)((5 - n5) * -4) / d);
                    f2 = 1.0f;
                }
                Color color = Color.getHSBColor(f3, f, f2);
                this.setRoi(n5 * (int)(d / 2.0), n6 * (int)(d2 / 2.0), (int)d / 2, (int)d2 / 2);
                this.setColor(color);
                this.fill();
            }
        }
        this.drawSpectrum(d2);
        this.resetRoi();
    }

    void drawColor(int n, int n2, Color color) {
        this.setRoi(n * this.w, n2 * this.h, this.w, this.h);
        this.setColor(color);
        this.fill();
    }

    public void refreshBackground() {
        this.setColor(0x444444);
        this.drawRect(this.w * 2 - 12, 276, this.w * 2 + 4, this.h * 2 + 4);
        this.setColor(0x999999);
        this.drawRect(this.w * 2 - 11, 277, this.w * 2 + 2, this.h * 2 + 2);
        this.setRoi(this.w * 2 - 10, 278, this.w * 2, this.h * 2);
        this.setColor(Toolbar.getBackgroundColor());
        this.fill();
    }

    public void refreshForeground() {
        this.setColor(0x444444);
        this.drawRect(8, 266, this.w * 2 + 4, this.h * 2 + 4);
        this.setColor(0x999999);
        this.drawRect(9, 267, this.w * 2 + 2, this.h * 2 + 2);
        this.setRoi(10, 268, this.w * 2, this.h * 2);
        this.setColor(Toolbar.getForegroundColor());
        this.fill();
    }

    void drawSpectrum(double d) {
        for (int i = 5; i < 7; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = (float)((double)j / (2.0 * d) - 0.15);
                Color color = Color.getHSBColor(f, 1.0f, 1.0f);
                this.setRoi(i * (this.w / 2), j * (int)(d / 2.0), this.w / 2, (int)d / 2);
                this.setColor(color);
                this.fill();
            }
        }
        this.setRoi(55, 32, 22, 16);
        this.setColor(0xFF0000);
        this.fill();
        this.setRoi(55, 120, 22, 16);
        this.setColor(65280);
        this.fill();
        this.setRoi(55, 208, 22, 16);
        this.setColor(255);
        this.fill();
        this.setRoi(55, 80, 22, 8);
        this.setColor(0xFFFF00);
        this.fill();
        this.setRoi(55, 168, 22, 8);
        this.setColor(65535);
        this.fill();
        this.setRoi(55, 248, 22, 8);
        this.setColor(0xFF00FF);
        this.fill();
    }

    void drawRamp() {
        for (int i = 0; i < this.w; ++i) {
            for (double d = 0.0; d < (double)(this.h * 16); d += 1.0) {
                byte by;
                byte by2 = by = (byte)d;
                byte by3 = by;
                this.pixels[(int)d * this.width + i] = 0xFF000000 | by3 << 16 & 0xFF0000 | by2 << 8 & 0xFF00 | by & 0xFF;
            }
        }
    }

    void resetBW() {
        this.setColor(0);
        this.drawRect(92, 300, 9, 7);
        this.setColor(0);
        this.setRoi(88, 297, 9, 7);
        this.fill();
    }

    void flipper() {
        int n = 90;
        int n2 = 272;
        this.setColor(0);
        this.drawLine(n, n2, n + 9, n2 + 9);
        this.drawLine(n + 1, n2, n + 9, n2 + 8);
        this.drawLine(n, n2 + 1, n + 8, n2 + 9);
        this.drawLine(n, n2, n, n2 + 5);
        this.drawLine(n + 1, n2 + 1, n + 1, n2 + 6);
        this.drawLine(n, n2, n + 5, n2);
        this.drawLine(n + 1, n2 + 1, n + 6, n2 + 1);
        this.drawLine(n + 9, n2 + 9, n + 9, n2 + 4);
        this.drawLine(n + 8, n2 + 8, n + 8, n2 + 3);
        this.drawLine(n + 9, n2 + 9, n + 4, n2 + 9);
        this.drawLine(n + 8, n2 + 8, n + 3, n2 + 8);
    }
}

