/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.TextRoi;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

public class Fonts
extends PlugInFrame
implements PlugIn,
ItemListener {
    public static final String LOC_KEY = "fonts.loc";
    private static String[] sizes = new String[]{"8", "9", "10", "12", "14", "18", "24", "28", "36", "48", "60", "72"};
    private static int[] isizes = new int[]{8, 9, 10, 12, 14, 18, 24, 28, 36, 48, 60, 72};
    private Panel panel;
    private Choice font;
    private Choice size;
    private Choice style;
    private Checkbox checkbox;
    private static Frame instance;

    public Fonts() {
        super("Fonts");
        String string;
        int n;
        if (instance != null) {
            instance.toFront();
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        this.setLayout(new FlowLayout(1, 10, 5));
        this.font = new Choice();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        this.font.add("SansSerif");
        this.font.add("Serif");
        this.font.add("Monospaced");
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (string.equals("SansSerif") || string.equals("Serif") || string.equals("Monospaced")) continue;
            this.font.add(string);
        }
        this.font.select(TextRoi.getFont());
        this.font.addItemListener(this);
        this.add(this.font);
        this.size = new Choice();
        for (n = 0; n < sizes.length; ++n) {
            this.size.add(sizes[n]);
        }
        this.size.select(this.getSizeIndex());
        this.size.addItemListener(this);
        this.add(this.size);
        this.style = new Choice();
        this.style.add("Plain");
        this.style.add("Bold");
        this.style.add("Italic");
        this.style.add("Bold+Italic");
        n = TextRoi.getStyle();
        string = "Plain";
        if (n == 1) {
            string = "Bold";
        } else if (n == 2) {
            string = "Italic";
        } else if (n == 3) {
            string = "Bold+Italic";
        }
        this.style.select(string);
        this.style.addItemListener(this);
        this.add(this.style);
        this.checkbox = new Checkbox("Smooth", TextRoi.isAntialiased());
        this.add(this.checkbox);
        this.checkbox.addItemListener(this);
        this.pack();
        Point point = Prefs.getLocation(LOC_KEY);
        if (point != null) {
            this.setLocation(point);
        } else {
            GUI.center(this);
        }
        this.show();
        IJ.register(Fonts.class);
    }

    int getSizeIndex() {
        int n = TextRoi.getSize();
        int n2 = 0;
        for (int i = 0; i < isizes.length; ++i) {
            if (n < isizes[i]) continue;
            n2 = i;
        }
        return n2;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.font.getSelectedItem();
        int n = Integer.parseInt(this.size.getSelectedItem());
        String string2 = this.style.getSelectedItem();
        int n2 = 0;
        if (string2.equals("Bold")) {
            n2 = 1;
        } else if (string2.equals("Italic")) {
            n2 = 2;
        } else if (string2.equals("Bold+Italic")) {
            n2 = 3;
        }
        TextRoi.setFont(string, n, n2, this.checkbox.getState());
        IJ.showStatus(n + " point " + string + " " + string2);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.close();
        instance = null;
        Prefs.saveLocation(LOC_KEY, this.getLocation());
    }
}

