/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.Prefs;
import ij.plugin.filter.Convolver;
import ij.process.BinaryProcessor;
import ij.process.ByteBlitter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Random;

public class ByteProcessor
extends ImageProcessor {
    static final int ERODE = 10;
    static final int DILATE = 11;
    protected byte[] pixels;
    protected byte[] snapshotPixels;
    private int bgColor = 255;
    private boolean bgColorSet;
    private int min = 0;
    private int max = 255;
    private int binaryCount;
    private int binaryBackground;
    static double oldx;
    static double oldy;

    public ByteProcessor(Image image) {
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.resetRoi();
        this.pixels = new byte[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println(interruptedException);
        }
        this.cm = pixelGrabber.getColorModel();
        if (this.cm instanceof IndexColorModel) {
            this.pixels = (byte[])pixelGrabber.getPixels();
        } else {
            System.err.println("ByteProcessor: not 8-bit image");
        }
        if (((IndexColorModel)this.cm).getTransparentPixel() != -1) {
            IndexColorModel indexColorModel = (IndexColorModel)this.cm;
            int n = indexColorModel.getMapSize();
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            this.cm = new IndexColorModel(8, n, byArray, byArray2, byArray3);
        }
    }

    public ByteProcessor(int n, int n2) {
        this(n, n2, new byte[n * n2], null);
    }

    public ByteProcessor(int n, int n2, byte[] byArray, ColorModel colorModel) {
        if (byArray != null && n * n2 != byArray.length) {
            throw new IllegalArgumentException("width*height!=pixels.length");
        }
        this.width = n;
        this.height = n2;
        this.resetRoi();
        this.pixels = byArray;
        this.cm = colorModel;
    }

    public ByteProcessor(BufferedImage bufferedImage) {
        if (bufferedImage.getType() != 10) {
            throw new IllegalArgumentException("Type!=TYPE_BYTE_GRAYY");
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        this.pixels = ((DataBufferByte)dataBuffer).getData();
        this.width = writableRaster.getWidth();
        this.height = writableRaster.getHeight();
    }

    public Image createImage() {
        if (this.cm == null) {
            this.cm = this.getDefaultColorModel();
        }
        if (IJ.isJava16()) {
            return this.createBufferedImage();
        }
        if (this.source == null) {
            this.source = new MemoryImageSource(this.width, this.height, this.cm, this.pixels, 0, this.width);
            this.source.setAnimated(true);
            this.source.setFullBufferUpdates(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.source);
        } else if (this.newPixels) {
            this.source.newPixels(this.pixels, this.cm, 0, this.width);
            this.newPixels = false;
        } else {
            this.source.newPixels();
        }
        return this.img;
    }

    Image createBufferedImage() {
        if (this.raster == null) {
            SampleModel sampleModel = this.getIndexSampleModel();
            DataBufferByte dataBufferByte = new DataBufferByte(this.pixels, this.width * this.height, 0);
            this.raster = Raster.createWritableRaster(sampleModel, dataBufferByte, null);
        }
        if (this.image == null || this.cm != this.cm2) {
            if (this.cm == null) {
                this.cm = this.getDefaultColorModel();
            }
            this.image = new BufferedImage(this.cm, this.raster, false, null);
            this.cm2 = this.cm;
        }
        return this.image;
    }

    public BufferedImage getBufferedImage() {
        if (this.isDefaultLut()) {
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 10);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(this.createImage(), 0, 0, null);
            return bufferedImage;
        }
        return (BufferedImage)this.createBufferedImage();
    }

    public ImageProcessor createProcessor(int n, int n2) {
        ByteProcessor byteProcessor = new ByteProcessor(n, n2, new byte[n * n2], this.getColorModel());
        if (this.baseCM != null) {
            ((ImageProcessor)byteProcessor).setMinAndMax(this.min, this.max);
        }
        byteProcessor.setInterpolationMethod(this.interpolationMethod);
        return byteProcessor;
    }

    public ImageProcessor crop() {
        ImageProcessor imageProcessor = this.createProcessor(this.roiWidth, this.roiHeight);
        byte[] byArray = (byte[])imageProcessor.getPixels();
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n = (i - this.roiY) * this.roiWidth;
            int n2 = i * this.width + this.roiX;
            for (int j = 0; j < this.roiWidth; ++j) {
                byArray[n++] = this.pixels[n2++];
            }
        }
        return imageProcessor;
    }

    public synchronized ImageProcessor duplicate() {
        ImageProcessor imageProcessor = this.createProcessor(this.width, this.height);
        byte[] byArray = (byte[])imageProcessor.getPixels();
        System.arraycopy(this.pixels, 0, byArray, 0, this.width * this.height);
        return imageProcessor;
    }

    public void snapshot() {
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
        if (this.snapshotPixels == null || this.snapshotPixels != null && this.snapshotPixels.length != this.pixels.length) {
            this.snapshotPixels = new byte[this.width * this.height];
        }
        System.arraycopy(this.pixels, 0, this.snapshotPixels, 0, this.width * this.height);
    }

    public void reset() {
        if (this.snapshotPixels == null) {
            return;
        }
        System.arraycopy(this.snapshotPixels, 0, this.pixels, 0, this.width * this.height);
    }

    public void reset(ImageProcessor imageProcessor) {
        if (imageProcessor == null || this.snapshotPixels == null) {
            return;
        }
        if (imageProcessor.getWidth() != this.roiWidth || imageProcessor.getHeight() != this.roiHeight) {
            throw new IllegalArgumentException(this.maskSizeError(imageProcessor));
        }
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n = this.roiY;
        int n2 = 0;
        while (n < this.roiY + this.roiHeight) {
            int n3 = n * this.width + this.roiX;
            int n4 = n2 * this.roiWidth;
            for (int i = this.roiX; i < this.roiX + this.roiWidth; ++i) {
                if (byArray[n4++] == 0) {
                    this.pixels[n3] = this.snapshotPixels[n3];
                }
                ++n3;
            }
            ++n;
            ++n2;
        }
    }

    public void setSnapshotPixels(Object object) {
        this.snapshotPixels = (byte[])object;
        this.snapshotWidth = this.width;
        this.snapshotHeight = this.height;
    }

    public Object getSnapshotPixels() {
        return this.snapshotPixels;
    }

    public void fill(ImageProcessor imageProcessor) {
        if (imageProcessor == null) {
            this.fill();
            return;
        }
        int n = this.roiWidth;
        int n2 = this.roiHeight;
        int n3 = this.roiX;
        int n4 = this.roiY;
        if (!(imageProcessor.getWidth() == n && imageProcessor.getHeight() == n2 || (imageProcessor = this.getMask()) != null && imageProcessor.getWidth() == n && imageProcessor.getHeight() == n2)) {
            return;
        }
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n5 = n4;
        int n6 = 0;
        while (n5 < n4 + n2) {
            int n7 = n5 * this.width + n3;
            int n8 = n6 * n;
            for (int i = n3; i < n3 + n; ++i) {
                if (byArray[n8++] != 0) {
                    this.pixels[n7] = (byte)this.fgColor;
                }
                ++n7;
            }
            ++n5;
            ++n6;
        }
    }

    public int getPixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.pixels[n2 * this.width + n] & 0xFF;
        }
        return 0;
    }

    public final int get(int n, int n2) {
        return this.pixels[n2 * this.width + n] & 0xFF;
    }

    public final void set(int n, int n2, int n3) {
        this.pixels[n2 * this.width + n] = (byte)n3;
    }

    public final int get(int n) {
        return this.pixels[n] & 0xFF;
    }

    public final void set(int n, int n2) {
        this.pixels[n] = (byte)n2;
    }

    public final float getf(int n, int n2) {
        return this.pixels[n2 * this.width + n] & 0xFF;
    }

    public final void setf(int n, int n2, float f) {
        this.pixels[n2 * this.width + n] = (byte)f;
    }

    public final float getf(int n) {
        return this.pixels[n] & 0xFF;
    }

    public final void setf(int n, float f) {
        this.pixels[n] = (byte)f;
    }

    public double getInterpolatedPixel(double d, double d2) {
        if (this.interpolationMethod == 2) {
            return this.getBicubicInterpolatedPixel(d, d2, this);
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d >= (double)this.width - 1.0) {
            d = (double)this.width - 1.001;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 >= (double)this.height - 1.0) {
            d2 = (double)this.height - 1.001;
        }
        return this.getInterpolatedPixel(d, d2, this.pixels);
    }

    public final int getPixelInterpolated(double d, double d2) {
        if (this.interpolationMethod == 1) {
            if (d < 0.0 || d2 < 0.0 || d >= (double)(this.width - 1) || d2 >= (double)(this.height - 1)) {
                return 0;
            }
            return (int)Math.round(this.getInterpolatedPixel(d, d2, this.pixels));
        }
        if (this.interpolationMethod == 2) {
            int n = (int)(this.getBicubicInterpolatedPixel(d, d2, this) + 0.5);
            if (n < 0) {
                n = 0;
            }
            if (n > 255) {
                n = 255;
            }
            return n;
        }
        return this.getPixel((int)(d + 0.5), (int)(d2 + 0.5));
    }

    public float getPixelValue(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            if (this.cTable == null) {
                return this.pixels[n2 * this.width + n] & 0xFF;
            }
            return this.cTable[this.pixels[n2 * this.width + n] & 0xFF];
        }
        return 0.0f;
    }

    public void setColor(Color color) {
        this.drawingColor = color;
        this.fgColor = this.getBestIndex(color);
    }

    public void setValue(double d) {
        this.fgColor = (int)d;
        if (this.fgColor < 0) {
            this.fgColor = 0;
        }
        if (this.fgColor > 255) {
            this.fgColor = 255;
        }
    }

    public void setBackgroundValue(double d) {
        this.bgColor = (int)d;
        if (this.bgColor < 0) {
            this.bgColor = 0;
        }
        if (this.bgColor > 255) {
            this.bgColor = 255;
        }
        this.bgColorSet = true;
    }

    public double getBackgroundValue() {
        return this.bgColor;
    }

    public void putPixelValue(int n, int n2, double d) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            if (d > 255.0) {
                d = 255.0;
            } else if (d < 0.0) {
                d = 0.0;
            }
            this.pixels[n2 * this.width + n] = (byte)(d + 0.5);
        }
    }

    public final void putPixel(int n, int n2, int n3) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            if (n3 > 255) {
                n3 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            this.pixels[n2 * this.width + n] = (byte)n3;
        }
    }

    public void drawPixel(int n, int n2) {
        if (n >= this.clipXMin && n <= this.clipXMax && n2 >= this.clipYMin && n2 <= this.clipYMax) {
            this.pixels[n2 * this.width + n] = (byte)this.fgColor;
        }
    }

    public Object getPixels() {
        return this.pixels;
    }

    public Object getPixelsCopy() {
        if (this.snapshotPixels != null && this.snapshotCopyMode) {
            this.snapshotCopyMode = false;
            return this.snapshotPixels;
        }
        byte[] byArray = new byte[this.width * this.height];
        System.arraycopy(this.pixels, 0, byArray, 0, this.width * this.height);
        return byArray;
    }

    public void setPixels(Object object) {
        if (object != null && this.pixels != null && ((byte[])object).length != this.pixels.length) {
            throw new IllegalArgumentException("");
        }
        this.pixels = (byte[])object;
        this.resetPixels(object);
        if (object == null) {
            this.snapshotPixels = null;
        }
        this.raster = null;
        this.image = null;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMinAndMax(double d, double d2) {
        if (d2 < d) {
            return;
        }
        this.min = (int)d;
        this.max = (int)d2;
        if (this.rLUT1 == null) {
            if (this.cm == null) {
                this.makeDefaultColorModel();
            }
            this.baseCM = this.cm;
            IndexColorModel indexColorModel = (IndexColorModel)this.cm;
            this.rLUT1 = new byte[256];
            this.gLUT1 = new byte[256];
            this.bLUT1 = new byte[256];
            indexColorModel.getReds(this.rLUT1);
            indexColorModel.getGreens(this.gLUT1);
            indexColorModel.getBlues(this.bLUT1);
            this.rLUT2 = new byte[256];
            this.gLUT2 = new byte[256];
            this.bLUT2 = new byte[256];
        }
        for (int i = 0; i < 256; ++i) {
            if ((double)i < d) {
                this.rLUT2[i] = this.rLUT1[0];
                this.gLUT2[i] = this.gLUT1[0];
                this.bLUT2[i] = this.bLUT1[0];
                continue;
            }
            if ((double)i > d2) {
                this.rLUT2[i] = this.rLUT1[255];
                this.gLUT2[i] = this.gLUT1[255];
                this.bLUT2[i] = this.bLUT1[255];
                continue;
            }
            int n = i - this.min;
            if ((n = (int)(256.0 * (double)n / (d2 - d))) < 0) {
                n = 0;
            }
            if (n > 255) {
                n = 255;
            }
            this.rLUT2[i] = this.rLUT1[n];
            this.gLUT2[i] = this.gLUT1[n];
            this.bLUT2[i] = this.bLUT1[n];
        }
        this.cm = new IndexColorModel(8, 256, this.rLUT2, this.gLUT2, this.bLUT2);
        this.newPixels = true;
        if (d == 0.0 && d2 == 255.0) {
            this.source = null;
        }
        this.minThreshold = -808080.0;
    }

    public void resetMinAndMax() {
        this.setMinAndMax(0.0, 255.0);
    }

    public void setThreshold(double d, double d2, int n) {
        super.setThreshold(d, d2, n);
        if (this.minThreshold < 0.0) {
            this.minThreshold = 0.0;
        }
        if (this.maxThreshold > 255.0) {
            this.maxThreshold = 255.0;
        }
    }

    public void copyBits(ImageProcessor imageProcessor, int n, int n2, int n3) {
        imageProcessor = imageProcessor.convertToByte(true);
        new ByteBlitter(this).copyBits(imageProcessor, n, n2, n3);
    }

    public void applyTable(int[] nArray) {
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n;
            int n2 = i * this.width + this.roiX;
            int n3 = n = n2 + this.roiWidth;
            while (--n3 >= n2) {
                this.pixels[n3] = (byte)nArray[this.pixels[n3] & 0xFF];
            }
        }
    }

    public void convolve3x3(int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = nArray[3];
        int n7 = nArray[4];
        int n8 = nArray[5];
        int n9 = nArray[6];
        int n10 = nArray[7];
        int n11 = nArray[8];
        for (n = 0; n < nArray.length; ++n) {
            n2 += nArray[n];
        }
        if (n2 == 0) {
            n2 = 1;
        }
        if ((n = this.roiHeight / 25) < 1) {
            n = 1;
        }
        byte[] byArray = (byte[])this.getPixelsCopy();
        int n12 = this.roiX + this.roiWidth;
        int n13 = this.roiY + this.roiHeight;
        for (int i = this.roiY; i < n13; ++i) {
            int n14 = this.roiX + i * this.width;
            int n15 = n14 - (this.roiX > 0 ? 1 : 0);
            int n16 = n15 - (i > 0 ? this.width : 0);
            int n17 = n15 + (i < this.height - 1 ? this.width : 0);
            int n18 = byArray[n16] & 0xFF;
            int n19 = byArray[n15] & 0xFF;
            int n20 = byArray[n17] & 0xFF;
            if (this.roiX > 0) {
                ++n16;
                ++n15;
                ++n17;
            }
            int n21 = byArray[n16] & 0xFF;
            int n22 = byArray[n15] & 0xFF;
            int n23 = byArray[n17] & 0xFF;
            int n24 = this.roiX;
            while (n24 < n12) {
                if (n24 < this.width - 1) {
                    ++n16;
                    ++n15;
                    ++n17;
                }
                int n25 = n18;
                n18 = n21;
                n21 = byArray[n16] & 0xFF;
                int n26 = n19;
                n19 = n22;
                n22 = byArray[n15] & 0xFF;
                int n27 = n20;
                n20 = n23;
                n23 = byArray[n17] & 0xFF;
                int n28 = n3 * n25 + n4 * n18 + n5 * n21 + n6 * n26 + n7 * n19 + n8 * n22 + n9 * n27 + n10 * n20 + n11 * n23;
                if ((n28 = (n28 + n2 / 2) / n2) > 255) {
                    n28 = 255;
                }
                if (n28 < 0) {
                    n28 = 0;
                }
                this.pixels[n14] = (byte)n28;
                ++n24;
                ++n14;
            }
            if (i % n != 0) continue;
            this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
        }
        this.showProgress(1.0);
    }

    public void filter(int n) {
        int n2 = this.roiHeight / 25;
        if (n2 < 1) {
            n2 = 1;
        }
        byte[] byArray = (byte[])this.getPixelsCopy();
        if (this.width == 1) {
            this.filterEdge(n, byArray, this.roiHeight, this.roiX, this.roiY, 0, 1);
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[10];
        if (n == 2) {
            nArray = new int[10];
        }
        int n5 = this.width;
        int n6 = 255 - this.binaryBackground;
        for (int i = this.yMin; i <= this.yMax; ++i) {
            int n7 = this.xMin + i * this.width;
            int n8 = byArray[n7 - n5 - 1] & 0xFF;
            int n9 = byArray[n7 - n5] & 0xFF;
            int n10 = byArray[n7 - 1] & 0xFF;
            int n11 = byArray[n7] & 0xFF;
            int n12 = byArray[n7 + n5 - 1] & 0xFF;
            int n13 = byArray[n7 + n5] & 0xFF;
            for (int j = this.xMin; j <= this.xMax; ++j) {
                int n14 = n8;
                n8 = n9;
                n9 = byArray[n7 - n5 + 1] & 0xFF;
                int n15 = n10;
                n10 = n11;
                n11 = byArray[n7 + 1] & 0xFF;
                int n16 = n12;
                n12 = n13;
                n13 = byArray[n7 + n5 + 1] & 0xFF;
                switch (n) {
                    case 0: {
                        n4 = (n14 + n8 + n9 + n15 + n10 + n11 + n16 + n12 + n13 + 4) / 9;
                        break;
                    }
                    case 1: {
                        int n17 = n14 + 2 * n8 + n9 - n16 - 2 * n12 - n13;
                        n3 = n14 + 2 * n15 + n16 - n9 - 2 * n11 - n13;
                        n4 = (int)Math.sqrt(n17 * n17 + n3 * n3);
                        if (n4 <= 255) break;
                        n4 = 255;
                        break;
                    }
                    case 2: {
                        nArray[1] = n14;
                        nArray[2] = n8;
                        nArray[3] = n9;
                        nArray[4] = n15;
                        nArray[5] = n10;
                        nArray[6] = n11;
                        nArray[7] = n16;
                        nArray[8] = n12;
                        nArray[9] = n13;
                        n4 = this.findMedian(nArray);
                        break;
                    }
                    case 3: {
                        n4 = n10;
                        if (n14 < n4) {
                            n4 = n14;
                        }
                        if (n8 < n4) {
                            n4 = n8;
                        }
                        if (n9 < n4) {
                            n4 = n9;
                        }
                        if (n15 < n4) {
                            n4 = n15;
                        }
                        if (n11 < n4) {
                            n4 = n11;
                        }
                        if (n16 < n4) {
                            n4 = n16;
                        }
                        if (n12 < n4) {
                            n4 = n12;
                        }
                        if (n13 >= n4) break;
                        n4 = n13;
                        break;
                    }
                    case 4: {
                        n4 = n10;
                        if (n14 > n4) {
                            n4 = n14;
                        }
                        if (n8 > n4) {
                            n4 = n8;
                        }
                        if (n9 > n4) {
                            n4 = n9;
                        }
                        if (n15 > n4) {
                            n4 = n15;
                        }
                        if (n11 > n4) {
                            n4 = n11;
                        }
                        if (n16 > n4) {
                            n4 = n16;
                        }
                        if (n12 > n4) {
                            n4 = n12;
                        }
                        if (n13 <= n4) break;
                        n4 = n13;
                        break;
                    }
                    case 10: {
                        if (n10 == this.binaryBackground) {
                            n4 = this.binaryBackground;
                            break;
                        }
                        int n18 = 0;
                        if (n14 == this.binaryBackground) {
                            ++n18;
                        }
                        if (n8 == this.binaryBackground) {
                            ++n18;
                        }
                        if (n9 == this.binaryBackground) {
                            ++n18;
                        }
                        if (n15 == this.binaryBackground) {
                            ++n18;
                        }
                        if (n11 == this.binaryBackground) {
                            ++n18;
                        }
                        if (n16 == this.binaryBackground) {
                            ++n18;
                        }
                        if (n12 == this.binaryBackground) {
                            ++n18;
                        }
                        if (n13 == this.binaryBackground) {
                            ++n18;
                        }
                        if (n18 >= this.binaryCount) {
                            n4 = this.binaryBackground;
                            break;
                        }
                        n4 = n6;
                        break;
                    }
                    case 11: {
                        if (n10 == n6) {
                            n4 = n6;
                            break;
                        }
                        int n18 = 0;
                        if (n14 == n6) {
                            ++n18;
                        }
                        if (n8 == n6) {
                            ++n18;
                        }
                        if (n9 == n6) {
                            ++n18;
                        }
                        if (n15 == n6) {
                            ++n18;
                        }
                        if (n11 == n6) {
                            ++n18;
                        }
                        if (n16 == n6) {
                            ++n18;
                        }
                        if (n12 == n6) {
                            ++n18;
                        }
                        if (n13 == n6) {
                            ++n18;
                        }
                        n4 = n18 >= this.binaryCount ? n6 : this.binaryBackground;
                    }
                }
                this.pixels[n7++] = (byte)n4;
            }
        }
        if (this.xMin == 1) {
            this.filterEdge(n, byArray, this.roiHeight, this.roiX, this.roiY, 0, 1);
        }
        if (this.yMin == 1) {
            this.filterEdge(n, byArray, this.roiWidth, this.roiX, this.roiY, 1, 0);
        }
        if (this.xMax == this.width - 2) {
            this.filterEdge(n, byArray, this.roiHeight, this.width - 1, this.roiY, 0, 1);
        }
        if (this.yMax == this.height - 2) {
            this.filterEdge(n, byArray, this.roiWidth, this.roiX, this.height - 1, 1, 0);
        }
    }

    void filterEdge(int n, byte[] byArray, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 255 - this.binaryBackground;
        int n9 = this.binaryBackground;
        int n10 = n8;
        for (int i = 0; i < n2; ++i) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            if (!Prefs.padEdges && n == 10 || n == 11) {
                n19 = this.getEdgePixel0(byArray, n9, n3 - 1, n4 - 1);
                n18 = this.getEdgePixel0(byArray, n9, n3, n4 - 1);
                n17 = this.getEdgePixel0(byArray, n9, n3 + 1, n4 - 1);
                n16 = this.getEdgePixel0(byArray, n9, n3 - 1, n4);
                n15 = this.getEdgePixel0(byArray, n9, n3, n4);
                n14 = this.getEdgePixel0(byArray, n9, n3 + 1, n4);
                n13 = this.getEdgePixel0(byArray, n9, n3 - 1, n4 + 1);
                n12 = this.getEdgePixel0(byArray, n9, n3, n4 + 1);
                n11 = this.getEdgePixel0(byArray, n9, n3 + 1, n4 + 1);
            } else if (Prefs.padEdges && n == 10) {
                n19 = this.getEdgePixel1(byArray, n10, n3 - 1, n4 - 1);
                n18 = this.getEdgePixel1(byArray, n10, n3, n4 - 1);
                n17 = this.getEdgePixel1(byArray, n10, n3 + 1, n4 - 1);
                n16 = this.getEdgePixel1(byArray, n10, n3 - 1, n4);
                n15 = this.getEdgePixel1(byArray, n10, n3, n4);
                n14 = this.getEdgePixel1(byArray, n10, n3 + 1, n4);
                n13 = this.getEdgePixel1(byArray, n10, n3 - 1, n4 + 1);
                n12 = this.getEdgePixel1(byArray, n10, n3, n4 + 1);
                n11 = this.getEdgePixel1(byArray, n10, n3 + 1, n4 + 1);
            } else {
                n19 = this.getEdgePixel(byArray, n3 - 1, n4 - 1);
                n18 = this.getEdgePixel(byArray, n3, n4 - 1);
                n17 = this.getEdgePixel(byArray, n3 + 1, n4 - 1);
                n16 = this.getEdgePixel(byArray, n3 - 1, n4);
                n15 = this.getEdgePixel(byArray, n3, n4);
                n14 = this.getEdgePixel(byArray, n3 + 1, n4);
                n13 = this.getEdgePixel(byArray, n3 - 1, n4 + 1);
                n12 = this.getEdgePixel(byArray, n3, n4 + 1);
                n11 = this.getEdgePixel(byArray, n3 + 1, n4 + 1);
            }
            switch (n) {
                case 0: {
                    n7 = (n19 + n18 + n17 + n16 + n15 + n14 + n13 + n12 + n11 + 4) / 9;
                    break;
                }
                case 1: {
                    int n20 = n19 + 2 * n18 + n17 - n13 - 2 * n12 - n11;
                    int n21 = n19 + 2 * n16 + n13 - n17 - 2 * n14 - n11;
                    n7 = (int)Math.sqrt(n20 * n20 + n21 * n21);
                    if (n7 <= 255) break;
                    n7 = 255;
                    break;
                }
                case 3: {
                    n7 = n15;
                    if (n19 < n7) {
                        n7 = n19;
                    }
                    if (n18 < n7) {
                        n7 = n18;
                    }
                    if (n17 < n7) {
                        n7 = n17;
                    }
                    if (n16 < n7) {
                        n7 = n16;
                    }
                    if (n14 < n7) {
                        n7 = n14;
                    }
                    if (n13 < n7) {
                        n7 = n13;
                    }
                    if (n12 < n7) {
                        n7 = n12;
                    }
                    if (n11 >= n7) break;
                    n7 = n11;
                    break;
                }
                case 4: {
                    n7 = n15;
                    if (n19 > n7) {
                        n7 = n19;
                    }
                    if (n18 > n7) {
                        n7 = n18;
                    }
                    if (n17 > n7) {
                        n7 = n17;
                    }
                    if (n16 > n7) {
                        n7 = n16;
                    }
                    if (n14 > n7) {
                        n7 = n14;
                    }
                    if (n13 > n7) {
                        n7 = n13;
                    }
                    if (n12 > n7) {
                        n7 = n12;
                    }
                    if (n11 <= n7) break;
                    n7 = n11;
                    break;
                }
                case 10: {
                    if (n15 == this.binaryBackground) {
                        n7 = this.binaryBackground;
                        break;
                    }
                    int n22 = 0;
                    if (n19 == this.binaryBackground) {
                        ++n22;
                    }
                    if (n18 == this.binaryBackground) {
                        ++n22;
                    }
                    if (n17 == this.binaryBackground) {
                        ++n22;
                    }
                    if (n16 == this.binaryBackground) {
                        ++n22;
                    }
                    if (n14 == this.binaryBackground) {
                        ++n22;
                    }
                    if (n13 == this.binaryBackground) {
                        ++n22;
                    }
                    if (n12 == this.binaryBackground) {
                        ++n22;
                    }
                    if (n11 == this.binaryBackground) {
                        ++n22;
                    }
                    if (n22 >= this.binaryCount) {
                        n7 = this.binaryBackground;
                        break;
                    }
                    n7 = n8;
                    break;
                }
                case 11: {
                    if (n15 == n8) {
                        n7 = n8;
                        break;
                    }
                    int n22 = 0;
                    if (n19 == n8) {
                        ++n22;
                    }
                    if (n18 == n8) {
                        ++n22;
                    }
                    if (n17 == n8) {
                        ++n22;
                    }
                    if (n16 == n8) {
                        ++n22;
                    }
                    if (n14 == n8) {
                        ++n22;
                    }
                    if (n13 == n8) {
                        ++n22;
                    }
                    if (n12 == n8) {
                        ++n22;
                    }
                    if (n11 == n8) {
                        ++n22;
                    }
                    n7 = n22 >= this.binaryCount ? n8 : this.binaryBackground;
                }
            }
            this.pixels[n3 + n4 * this.width] = (byte)n7;
            n3 += n5;
            n4 += n6;
        }
    }

    final int getEdgePixel(byte[] byArray, int n, int n2) {
        if (n <= 0) {
            n = 0;
        }
        if (n >= this.width) {
            n = this.width - 1;
        }
        if (n2 <= 0) {
            n2 = 0;
        }
        if (n2 >= this.height) {
            n2 = this.height - 1;
        }
        return byArray[n + n2 * this.width] & 0xFF;
    }

    final int getEdgePixel1(byte[] byArray, int n, int n2, int n3) {
        if (n2 < 0 || n2 > this.width - 1 || n3 < 0 || n3 > this.height - 1) {
            return n;
        }
        return byArray[n2 + n3 * this.width] & 0xFF;
    }

    final int getEdgePixel0(byte[] byArray, int n, int n2, int n3) {
        if (n2 < 0 || n2 > this.width - 1 || n3 < 0 || n3 > this.height - 1) {
            return n;
        }
        return byArray[n2 + n3 * this.width] & 0xFF;
    }

    public void erode() {
        if (this.isInvertedLut()) {
            this.filter(3);
        } else {
            this.filter(4);
        }
    }

    public void dilate() {
        if (this.isInvertedLut()) {
            this.filter(4);
        } else {
            this.filter(3);
        }
    }

    public void erode(int n, int n2) {
        this.binaryCount = n;
        this.binaryBackground = n2;
        this.filter(10);
    }

    public void dilate(int n, int n2) {
        this.binaryCount = n;
        this.binaryBackground = n2;
        this.filter(11);
    }

    public void outline() {
        new BinaryProcessor(this).outline();
    }

    public void skeletonize() {
        new BinaryProcessor(this).skeletonize();
    }

    private final int findMedian(int[] nArray) {
        int n;
        int n2;
        for (n2 = 1; n2 <= 4; ++n2) {
            n = 0;
            int n3 = 1;
            for (int i = 1; i <= 9; ++i) {
                if (nArray[i] <= n) continue;
                n = nArray[i];
                n3 = i;
            }
            nArray[n3] = 0;
        }
        n2 = 0;
        for (n = 1; n <= 9; ++n) {
            if (nArray[n] <= n2) continue;
            n2 = nArray[n];
        }
        return n2;
    }

    public void medianFilter() {
        this.filter(2);
    }

    public void noise(double d) {
        Random random = new Random();
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n = i * this.width + this.roiX;
            for (int j = this.roiX; j < this.roiX + this.roiWidth; ++j) {
                boolean bl = false;
                do {
                    int n2;
                    int n3;
                    boolean bl2 = bl = (n3 = (this.pixels[n] & 0xFF) + (n2 = (int)Math.round(random.nextGaussian() * d))) >= 0 && n3 <= 255;
                    if (!bl) continue;
                    this.pixels[n] = (byte)n3;
                } while (!bl);
                ++n;
            }
            if (i % 20 != 0) continue;
            this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
        }
        this.showProgress(1.0);
    }

    public void scale(double d, double d2) {
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        double d3 = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d4 = (double)this.roiY + (double)this.roiHeight / 2.0;
        if (!this.bgColorSet && this.isInvertedLut()) {
            this.bgColor = 0;
        }
        if (d > 1.0 && d2 > 1.0) {
            n4 = (int)(d3 - (d3 - (double)this.roiX) * d);
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = n4 + (int)((double)this.roiWidth * d) - 1) >= this.width) {
                n3 = this.width - 1;
            }
            if ((n2 = (int)(d4 - (d4 - (double)this.roiY) * d2)) < 0) {
                n2 = 0;
            }
            if ((n = n2 + (int)((double)this.roiHeight * d2) - 1) >= this.height) {
                n = this.height - 1;
            }
        } else {
            n4 = this.roiX;
            n3 = this.roiX + this.roiWidth - 1;
            n2 = this.roiY;
            n = this.roiY + this.roiHeight - 1;
        }
        byte[] byArray = (byte[])this.getPixelsCopy();
        ByteProcessor byteProcessor = null;
        if (this.interpolationMethod == 2) {
            byteProcessor = new ByteProcessor(this.getWidth(), this.getHeight(), byArray, null);
            ((ImageProcessor)byteProcessor).setBackgroundValue(this.getBackgroundValue());
        }
        boolean bl2 = bl = d < 1.0 || d2 < 1.0;
        if (this.interpolationMethod == 2) {
            for (int i = n2; i <= n; ++i) {
                double d5 = ((double)i - d4) / d2 + d4;
                int n5 = i * this.width + n4;
                int n6 = this.width * (int)d5;
                for (int j = n4; j <= n3; ++j) {
                    double d6 = ((double)j - d3) / d + d3;
                    int n7 = (int)(this.getBicubicInterpolatedPixel(d6, d5, byteProcessor) + 0.5);
                    if (n7 < 0) {
                        n7 = 0;
                    }
                    if (n7 > 255) {
                        n7 = 255;
                    }
                    this.pixels[n5++] = (byte)n7;
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)(i - n2) / (double)this.height);
            }
        } else {
            double d7 = (double)this.width - 1.0;
            double d8 = (double)this.width - 1.001;
            double d9 = (double)this.height - 1.0;
            double d10 = (double)this.height - 1.001;
            for (int i = n2; i <= n; ++i) {
                double d11 = ((double)i - d4) / d2 + d4;
                int n8 = (int)d11;
                if (d11 < 0.0) {
                    d11 = 0.0;
                }
                if (d11 >= d9) {
                    d11 = d10;
                }
                int n9 = i * this.width + n4;
                int n10 = this.width * (int)d11;
                for (int j = n4; j <= n3; ++j) {
                    double d12 = ((double)j - d3) / d + d3;
                    int n11 = (int)d12;
                    if (bl && (n11 < n4 || n11 > n3 || n8 < n2 || n8 > n)) {
                        this.pixels[n9++] = (byte)this.bgColor;
                        continue;
                    }
                    if (this.interpolationMethod == 1) {
                        if (d12 < 0.0) {
                            d12 = 0.0;
                        }
                        if (d12 >= d7) {
                            d12 = d8;
                        }
                        this.pixels[n9++] = (byte)((int)(this.getInterpolatedPixel(d12, d11, byArray) + 0.5) & 0xFF);
                        continue;
                    }
                    this.pixels[n9++] = byArray[n10 + n11];
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)(i - n2) / (double)this.height);
            }
        }
        this.showProgress(1.0);
    }

    private final double getInterpolatedPixel(double d, double d2, byte[] byArray) {
        int n = (int)d;
        int n2 = (int)d2;
        double d3 = d - (double)n;
        double d4 = d2 - (double)n2;
        int n3 = n2 * this.width + n;
        int n4 = byArray[n3] & 0xFF;
        int n5 = byArray[n3 + 1] & 0xFF;
        int n6 = byArray[n3 + this.width + 1] & 0xFF;
        int n7 = byArray[n3 + this.width] & 0xFF;
        double d5 = (double)n7 + d3 * (double)(n6 - n7);
        double d6 = (double)n4 + d3 * (double)(n5 - n4);
        return d6 + d4 * (d5 - d6);
    }

    public ImageProcessor resize(int n, int n2) {
        if (this.roiWidth == n && this.roiHeight == n2) {
            return this.crop();
        }
        double d = (double)this.roiX + (double)this.roiWidth / 2.0;
        double d2 = (double)this.roiY + (double)this.roiHeight / 2.0;
        double d3 = (double)n / 2.0;
        double d4 = (double)n2 / 2.0;
        double d5 = (double)n / (double)this.roiWidth;
        double d6 = (double)n2 / (double)this.roiHeight;
        if (this.interpolationMethod != 0) {
            d3 += d5 / 2.0;
            d4 += d6 / 2.0;
        }
        ImageProcessor imageProcessor = this.createProcessor(n, n2);
        byte[] byArray = (byte[])imageProcessor.getPixels();
        if (this.interpolationMethod == 2) {
            for (int i = 0; i <= n2 - 1; ++i) {
                double d7 = ((double)i - d4) / d6 + d2;
                int n3 = this.width * (int)d7;
                int n4 = i * n;
                for (int j = 0; j <= n - 1; ++j) {
                    double d8 = ((double)j - d3) / d5 + d;
                    int n5 = (int)(this.getBicubicInterpolatedPixel(d8, d7, this) + 0.5);
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n5 > 255) {
                        n5 = 255;
                    }
                    byArray[n4++] = (byte)n5;
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)i / (double)n2);
            }
        } else {
            double d9 = (double)this.width - 1.0;
            double d10 = (double)this.width - 1.001;
            double d11 = (double)this.height - 1.0;
            double d12 = (double)this.height - 1.001;
            for (int i = 0; i <= n2 - 1; ++i) {
                double d13 = ((double)i - d4) / d6 + d2;
                if (this.interpolationMethod == 1) {
                    if (d13 < 0.0) {
                        d13 = 0.0;
                    }
                    if (d13 >= d11) {
                        d13 = d12;
                    }
                }
                int n6 = this.width * (int)d13;
                int n7 = i * n;
                for (int j = 0; j <= n - 1; ++j) {
                    double d14 = ((double)j - d3) / d5 + d;
                    if (this.interpolationMethod == 1) {
                        if (d14 < 0.0) {
                            d14 = 0.0;
                        }
                        if (d14 >= d9) {
                            d14 = d10;
                        }
                        byArray[n7++] = (byte)((int)(this.getInterpolatedPixel(d14, d13, this.pixels) + 0.5) & 0xFF);
                        continue;
                    }
                    byArray[n7++] = this.pixels[n6 + (int)d14];
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)i / (double)n2);
            }
        }
        this.showProgress(1.0);
        return imageProcessor;
    }

    public void rotate(double d) {
        if (d % 360.0 == 0.0) {
            return;
        }
        byte[] byArray = (byte[])this.getPixelsCopy();
        ByteProcessor byteProcessor = null;
        if (this.interpolationMethod == 2) {
            byteProcessor = new ByteProcessor(this.getWidth(), this.getHeight(), byArray, null);
            ((ImageProcessor)byteProcessor).setBackgroundValue(this.getBackgroundValue());
        }
        double d2 = (double)this.roiX + (double)(this.roiWidth - 1) / 2.0;
        double d3 = (double)this.roiY + (double)(this.roiHeight - 1) / 2.0;
        int n = this.roiX + this.roiWidth - 1;
        if (!this.bgColorSet && this.isInvertedLut()) {
            this.bgColor = 0;
        }
        double d4 = -d / 57.29577951308232;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        double d7 = d3 * d6 - d2 * d5;
        double d8 = -d2 * d6 - d3 * d5;
        double d9 = this.width;
        double d10 = this.height;
        double d11 = (double)this.width - 1.0;
        double d12 = (double)this.width - 1.001;
        double d13 = (double)this.height - 1.0;
        double d14 = (double)this.height - 1.001;
        if (this.interpolationMethod == 2) {
            for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
                int n2 = i * this.width + this.roiX;
                double d15 = d7 - (double)i * d6 + d2;
                double d16 = d8 + (double)i * d5 + d3;
                for (int j = this.roiX; j <= n; ++j) {
                    double d17 = (double)j * d5 + d15;
                    double d18 = (double)j * d6 + d16;
                    int n3 = (int)(this.getBicubicInterpolatedPixel(d17, d18, byteProcessor) + 0.5);
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if (n3 > 255) {
                        n3 = 255;
                    }
                    this.pixels[n2++] = (byte)n3;
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
            }
        } else {
            for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
                int n4 = i * this.width + this.roiX;
                double d19 = d7 - (double)i * d6 + d2;
                double d20 = d8 + (double)i * d5 + d3;
                for (int j = this.roiX; j <= n; ++j) {
                    double d21 = (double)j * d5 + d19;
                    double d22 = (double)j * d6 + d20;
                    if (d21 >= -0.01 && d21 < d9 && d22 >= -0.01 && d22 < d10) {
                        if (this.interpolationMethod == 1) {
                            if (d21 < 0.0) {
                                d21 = 0.0;
                            }
                            if (d21 >= d11) {
                                d21 = d12;
                            }
                            if (d22 < 0.0) {
                                d22 = 0.0;
                            }
                            if (d22 >= d13) {
                                d22 = d14;
                            }
                            this.pixels[n4++] = (byte)(this.getInterpolatedPixel(d21, d22, byArray) + 0.5);
                            continue;
                        }
                        int n5 = (int)(d21 + 0.5);
                        int n6 = (int)(d22 + 0.5);
                        if (n5 >= this.width) {
                            n5 = this.width - 1;
                        }
                        if (n6 >= this.height) {
                            n6 = this.height - 1;
                        }
                        this.pixels[n4++] = byArray[this.width * n6 + n5];
                        continue;
                    }
                    this.pixels[n4++] = (byte)this.bgColor;
                }
                if (i % 30 != 0) continue;
                this.showProgress((double)(i - this.roiY) / (double)this.roiHeight);
            }
        }
        this.showProgress(1.0);
    }

    public void flipVertical() {
        for (int i = 0; i < this.roiHeight / 2; ++i) {
            int n = (this.roiY + i) * this.width + this.roiX;
            int n2 = (this.roiY + this.roiHeight - 1 - i) * this.width + this.roiX;
            for (int j = 0; j < this.roiWidth; ++j) {
                byte by = this.pixels[n];
                this.pixels[n++] = this.pixels[n2];
                this.pixels[n2++] = by;
            }
        }
    }

    public int[] getHistogram() {
        if (this.mask != null) {
            return this.getHistogram(this.mask);
        }
        int[] nArray = new int[256];
        for (int i = this.roiY; i < this.roiY + this.roiHeight; ++i) {
            int n = i * this.width + this.roiX;
            for (int j = this.roiX; j < this.roiX + this.roiWidth; ++j) {
                int n2;
                int n3 = n2 = this.pixels[n++] & 0xFF;
                nArray[n3] = nArray[n3] + 1;
            }
        }
        return nArray;
    }

    public int[] getHistogram(ImageProcessor imageProcessor) {
        int n = this.roiX;
        int n2 = this.roiY;
        int n3 = this.roiWidth;
        int n4 = this.roiHeight;
        if (imageProcessor.getWidth() != n3 || imageProcessor.getHeight() != n4) {
            throw new IllegalArgumentException(this.maskSizeError(imageProcessor));
        }
        int[] nArray = new int[256];
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n5 = n2;
        int n6 = 0;
        while (n5 < n2 + n4) {
            int n7 = n5 * this.width + n;
            int n8 = n6 * n3;
            for (int i = n; i < n + n3; ++i) {
                if (byArray[n8++] != 0) {
                    int n9;
                    int n10 = n9 = this.pixels[n7] & 0xFF;
                    nArray[n10] = nArray[n10] + 1;
                }
                ++n7;
            }
            ++n5;
            ++n6;
        }
        return nArray;
    }

    public void threshold(int n) {
        for (int i = 0; i < this.width * this.height; ++i) {
            this.pixels[i] = (this.pixels[i] & 0xFF) <= n ? 0 : -1;
        }
    }

    public void applyLut() {
        if (this.rLUT2 == null) {
            return;
        }
        if (this.isInvertedLut()) {
            for (int i = 0; i < this.width * this.height; ++i) {
                this.pixels[i] = (byte)(255 - this.rLUT2[this.pixels[i] & 0xFF]);
            }
        } else {
            for (int i = 0; i < this.width * this.height; ++i) {
                this.pixels[i] = this.rLUT2[this.pixels[i] & 0xFF];
            }
        }
        this.setMinAndMax(0.0, 255.0);
    }

    public void convolve(float[] fArray, int n, int n2) {
        ImageProcessor imageProcessor = this.convertToFloat();
        imageProcessor.setRoi(this.getRoi());
        new Convolver().convolve(imageProcessor, fArray, n, n2);
        imageProcessor = imageProcessor.convertToByte(false);
        byte[] byArray = (byte[])imageProcessor.getPixels();
        System.arraycopy(byArray, 0, this.pixels, 0, this.pixels.length);
    }

    public FloatProcessor[] toFloatProcessors() {
        FloatProcessor[] floatProcessorArray = new FloatProcessor[]{(FloatProcessor)this.convertToFloat()};
        return floatProcessorArray;
    }

    public void setFromFloatProcessors(FloatProcessor[] floatProcessorArray) {
        ImageProcessor imageProcessor = floatProcessorArray[0].convertToByte(false);
        this.setPixels(imageProcessor.getPixels());
    }

    public float[][] toFloatArrays() {
        float[][] fArrayArray = new float[1][];
        ImageProcessor imageProcessor = this.convertToFloat();
        fArrayArray[0] = (float[])imageProcessor.getPixels();
        return fArrayArray;
    }

    public void setFromFloatArrays(float[][] fArray) {
        ImageProcessor imageProcessor = new FloatProcessor(this.roiWidth, this.roiHeight, fArray[0], null);
        imageProcessor = imageProcessor.convertToByte(false);
        this.setPixels(imageProcessor.getPixels());
    }

    public FloatProcessor toFloat(int n, FloatProcessor floatProcessor) {
        int n2 = this.width * this.height;
        if (floatProcessor == null || floatProcessor.getWidth() != this.width || floatProcessor.getHeight() != this.height) {
            floatProcessor = new FloatProcessor(this.width, this.height, new float[n2], this.cm);
        }
        float[] fArray = (float[])floatProcessor.getPixels();
        for (int i = 0; i < n2; ++i) {
            fArray[i] = this.pixels[i] & 0xFF;
        }
        floatProcessor.setRoi(this.getRoi());
        floatProcessor.setMask(this.mask);
        floatProcessor.setMinAndMax(this.min, this.max);
        floatProcessor.setThreshold(this.minThreshold, this.maxThreshold, 2);
        return floatProcessor;
    }

    public void setPixels(int n, FloatProcessor floatProcessor) {
        float[] fArray = (float[])floatProcessor.getPixels();
        int n2 = this.width * this.height;
        for (int i = 0; i < n2; ++i) {
            float f = fArray[i] + 0.5f;
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 255.0f) {
                f = 255.0f;
            }
            this.pixels[i] = (byte)f;
        }
        this.setMinAndMax(floatProcessor.getMin(), floatProcessor.getMax());
    }

    public boolean isBinary() {
        for (int i = 0; i < this.width * this.height; ++i) {
            if (this.pixels[i] == 0 || this.pixels[i] == -1) continue;
            return false;
        }
        return true;
    }

    byte[] create8BitImage() {
        return this.pixels;
    }
}

