/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class ByteStatistics
extends ImageStatistics {
    public ByteStatistics(ImageProcessor imageProcessor) {
        this(imageProcessor, 27, null);
    }

    public ByteStatistics(ImageProcessor imageProcessor, int n, Calibration calibration) {
        float[] fArray;
        int n2;
        int n3;
        ByteProcessor byteProcessor = (ByteProcessor)imageProcessor;
        this.histogram = byteProcessor.getHistogram();
        this.setup(imageProcessor, calibration);
        double d = imageProcessor.getMinThreshold();
        if ((n & 0x100) == 0 || d == -808080.0) {
            n3 = 0;
            n2 = 255;
        } else {
            n3 = (int)d;
            n2 = (int)imageProcessor.getMaxThreshold();
        }
        float[] fArray2 = fArray = calibration != null ? calibration.getCTable() : null;
        if (fArray != null) {
            this.getCalibratedStatistics(n3, n2, fArray);
        } else {
            this.getRawStatistics(n3, n2);
        }
        if ((n & 0x10) != 0) {
            if (fArray != null) {
                this.getCalibratedMinAndMax(n3, n2, fArray);
            } else {
                this.getRawMinAndMax(n3, n2);
            }
        }
        if ((n & 0x800) != 0 || (n & 0x2000) != 0) {
            this.fitEllipse(imageProcessor);
        } else if ((n & 0x20) != 0) {
            this.getCentroid(imageProcessor, n3, n2);
        }
        if ((n & 0x60040) != 0) {
            this.calculateMoments(imageProcessor, n3, n2, fArray);
        }
        if ((n & 0x10000) != 0) {
            this.calculateMedian(this.histogram, n3, n2, calibration);
        }
        if ((n & 0x80000) != 0) {
            this.calculateAreaFraction(imageProcessor, this.histogram);
        }
    }

    void getCalibratedStatistics(int n, int n2, float[] fArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = n; i <= n2; ++i) {
            int n3 = this.histogram[i];
            double d4 = fArray[i];
            if (n3 <= 0 || Double.isNaN(d4)) continue;
            this.pixelCount += n3;
            d += d4 * (double)n3;
            d3 += (double)(i * n3);
            d2 += d4 * d4 * (double)n3;
            if (n3 <= this.maxCount) continue;
            this.maxCount = n3;
            this.mode = i;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.mean = d / (double)this.pixelCount;
        this.umean = d3 / (double)this.pixelCount;
        this.dmode = fArray[this.mode];
        this.calculateStdDev(this.pixelCount, d, d2);
        this.histMin = 0.0;
        this.histMax = 255.0;
    }

    void getCentroid(ImageProcessor imageProcessor, int n, int n2) {
        byte[] byArray = (byte[])imageProcessor.getPixels();
        byte[] byArray2 = imageProcessor.getMaskArray();
        boolean bl = n > 0 || n2 < 255;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = 0;
        int n4 = this.ry;
        int n5 = 0;
        while (n4 < this.ry + this.rh) {
            int n6 = n4 * this.width + this.rx;
            int n7 = n5 * this.rw;
            for (int i = this.rx; i < this.rx + this.rw; ++i) {
                if (byArray2 == null || byArray2[n7++] != 0) {
                    if (bl) {
                        int n8 = byArray[n6] & 0xFF;
                        if (n8 >= n && n8 <= n2) {
                            ++n3;
                            d += (double)i;
                            d2 += (double)n4;
                        }
                    } else {
                        ++n3;
                        d += (double)i;
                        d2 += (double)n4;
                    }
                }
                ++n6;
            }
            ++n4;
            ++n5;
        }
        this.xCentroid = d / (double)n3 + 0.5;
        this.yCentroid = d2 / (double)n3 + 0.5;
        if (this.cal != null) {
            this.xCentroid = this.cal.getX(this.xCentroid);
            this.yCentroid = this.cal.getY(this.yCentroid, this.height);
        }
    }

    void calculateMoments(ImageProcessor imageProcessor, int n, int n2, float[] fArray) {
        byte[] byArray = (byte[])imageProcessor.getPixels();
        byte[] byArray2 = imageProcessor.getMaskArray();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n3 = this.ry;
        int n4 = 0;
        while (n3 < this.ry + this.rh) {
            int n5 = n3 * this.width + this.rx;
            int n6 = n4 * this.rw;
            for (int i = this.rx; i < this.rx + this.rw; ++i) {
                int n7;
                if ((byArray2 == null || byArray2[n6++] != 0) && (n7 = byArray[n5] & 0xFF) >= n && n7 <= n2) {
                    double d7 = (double)(fArray != null ? fArray[n7] : (float)n7) + Double.MIN_VALUE;
                    double d8 = d7 * d7;
                    d += d7;
                    d2 += d8;
                    d3 += d7 * d8;
                    d4 += d8 * d8;
                    d5 += (double)i * d7;
                    d6 += (double)n3 * d7;
                }
                ++n5;
            }
            ++n3;
            ++n4;
        }
        double d9 = this.mean * this.mean;
        double d10 = d2 / (double)this.pixelCount - d9;
        double d11 = Math.sqrt(d10);
        this.skewness = ((d3 - 3.0 * this.mean * d2) / (double)this.pixelCount + 2.0 * this.mean * d9) / (d10 * d11);
        this.kurtosis = ((d4 - 4.0 * this.mean * d3 + 6.0 * d9 * d2) / (double)this.pixelCount - 3.0 * d9 * d9) / (d10 * d10) - 3.0;
        this.xCenterOfMass = d5 / d + 0.5;
        this.yCenterOfMass = d6 / d + 0.5;
        if (this.cal != null) {
            this.xCenterOfMass = this.cal.getX(this.xCenterOfMass);
            this.yCenterOfMass = this.cal.getY(this.yCenterOfMass, this.height);
        }
    }

    void getCalibratedMinAndMax(int n, int n2, float[] fArray) {
        if (this.pixelCount == 0) {
            this.min = 0.0;
            this.max = 0.0;
            return;
        }
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        double d = 0.0;
        for (int i = n; i <= n2; ++i) {
            if (this.histogram[i] <= 0) continue;
            d = fArray[i];
            if (d < this.min) {
                this.min = d;
            }
            if (!(d > this.max)) continue;
            this.max = d;
        }
    }
}

