/*
 * Decompiled with CFR 0.152.
 */
package ij.util;

public class Levenshtein {
    protected int w;
    protected int s;
    protected int a;
    protected int d;
    protected int b;
    protected int e;

    public Levenshtein(int n, int n2, int n3, int n4, int n5, int n6) {
        this.w = n;
        this.s = n2;
        this.a = n3;
        this.d = n4;
        this.b = n5;
        this.e = n6;
    }

    protected static boolean equals(String string, int n, String string2, int n2) {
        return string.charAt(n) == string2.charAt(n2);
    }

    protected static int different(String string, int n, String string2, int n2) {
        return string.charAt(n) == string2.charAt(n2) ? 0 : 1;
    }

    public int cost(String string, String string2) {
        int n;
        int n2 = string.length();
        int n3 = string2.length();
        int[] nArray = new int[n3 + 1];
        int[] nArray2 = new int[n3 + 1];
        int[] nArray3 = new int[n3 + 1];
        for (n = 0; n <= n3; ++n) {
            nArray2[n] = Math.min(n * Math.min(this.a, this.b), (n3 - n) * this.e);
        }
        for (n = 0; n < n2; ++n) {
            nArray3[0] = (n + 1) * this.d;
            for (int i = 0; i < n3; ++i) {
                nArray3[i + 1] = nArray2[i] + this.s * Levenshtein.different(string, n, string2, i);
                if (n > 0 && i > 0 && Levenshtein.equals(string, n - 1, string2, i) && Levenshtein.equals(string, n, string2, i - 1) && nArray3[i + 1] > nArray[i - 1] + this.w) {
                    nArray3[i + 1] = nArray[i - 1] + this.w;
                }
                if (nArray3[i + 1] > nArray2[i + 1] + this.d) {
                    nArray3[i + 1] = nArray2[i + 1] + this.d;
                }
                if (nArray3[i + 1] <= nArray3[i] + this.a) continue;
                nArray3[i + 1] = nArray3[i] + this.a;
            }
            int[] nArray4 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
            nArray3 = nArray4;
        }
        return nArray2[n3];
    }

    public static void main(String[] stringArray) {
        Levenshtein levenshtein = new Levenshtein(stringArray.length > 2 ? Integer.parseInt(stringArray[0]) : 0, stringArray.length > 3 ? Integer.parseInt(stringArray[0]) : 10, stringArray.length > 4 ? Integer.parseInt(stringArray[0]) : 1, stringArray.length > 5 ? Integer.parseInt(stringArray[0]) : 5, stringArray.length > 6 ? Integer.parseInt(stringArray[0]) : 0, stringArray.length > 7 ? Integer.parseInt(stringArray[0]) : 0);
        System.out.println("distance between " + stringArray[0] + " and " + stringArray[1] + " is " + levenshtein.cost(stringArray[0], stringArray[1]));
    }
}

