% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/read.ijroi.R
\name{read.ijroi}
\alias{read.ijroi}
\title{Read an ImageJ ROI file}
\usage{
read.ijroi(file, verbose = FALSE)
}
\arguments{
\item{file}{Name of ImageJ ROI file to read}

\item{verbose}{Whether to report information}
}
\value{
A structure of class \code{ijroi} containing the ROI information
}
\description{
Read an ImageJ ROI file. This returns a structure containing the
ImageJ data.
}
\examples{
library(png)
path <- file.path(system.file(package = "RImageJROI"), "extdata", "ijroi")
im <- as.raster(readPNG(file.path(path, "imagej-logo.png")))
plot(NA, NA, xlim=c(0, ncol(im)), ylim=c(nrow(im), 0), asp=1)
rasterImage(im, 0,  nrow(im), ncol(im), 0, interpolate=FALSE)
r <- read.ijroi(file.path(path, "rect.roi"))
plot(r, TRUE)
r <- read.ijroi(file.path(path, "polygon.roi"))
plot(r, TRUE)
r <- read.ijroi(file.path(path, "oval.roi"))
plot(r, TRUE)
}
\author{
David Sterratt
}
\seealso{
\code{\link{plot.ijroi}} for plotting single ROI objects.

\code{\link{read.ijzip}} for reading several ROI objects from .zip files.
}

