/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling;

import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.PreadjustmentVariable;
import ec.tstoolkit.modelling.UserVariable;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.regression.Constant;
import ec.tstoolkit.timeseries.regression.DiffConstant;
import ec.tstoolkit.timeseries.regression.ICalendarVariable;
import ec.tstoolkit.timeseries.regression.IEasterVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITsModifier;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.InterventionVariable;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.regression.Ramp;
import ec.tstoolkit.timeseries.regression.Sequence;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.ConstTransformation;
import ec.tstoolkit.timeseries.simplets.ExpTransformation;
import ec.tstoolkit.timeseries.simplets.ITsDataTransformation;
import ec.tstoolkit.timeseries.simplets.LengthOfPeriodTransformation;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class DeterministicComponent
implements IProcResults {
    public static final int FCAST_YEAR = 1;
    private TsData original_;
    private TsData y_;
    private LengthOfPeriodType lp_ = LengthOfPeriodType.None;
    private DefaultTransformationType function_ = DefaultTransformationType.None;
    private final List<PreadjustmentVariable> x_ = new ArrayList<PreadjustmentVariable>();
    private DataBlock b_;
    private double units_ = 1.0;
    public static final String LOG = "log";
    public static final String ADJUST = "adjust";
    public static final String EASTER = "easter";
    public static final String NTD = "ntd";
    public static final String NMH = "nmh";
    private static final InformationMapping<DeterministicComponent> MAPPING = new InformationMapping<DeterministicComponent>(DeterministicComponent.class);

    public TsData getOriginal() {
        return this.original_.clone();
    }

    public TsData getY() {
        return this.y_;
    }

    public TsVariableList getX() {
        TsVariableList x = new TsVariableList();
        this.x_.stream().forEach(var -> x.add(var.getVariable()));
        return x;
    }

    public void setOriginal(TsData s) {
        this.original_ = s;
    }

    public void setY(TsData s) {
        this.y_ = s;
    }

    public void add(PreadjustmentVariable var) {
        this.x_.add(var);
    }

    public void clearX() {
        this.x_.clear();
    }

    public static ComponentType getType(IOutlierVariable var) {
        OutlierType ot = var.getOutlierType();
        switch (ot) {
            case AO: 
            case TC: 
            case WO: {
                return ComponentType.Irregular;
            }
            case LS: {
                return ComponentType.Trend;
            }
            case SO: {
                return ComponentType.Seasonal;
            }
        }
        return ComponentType.Undefined;
    }

    public static ComponentType getType(InterventionVariable var) {
        if (var.getDeltaS() > 0.0 && var.getDelta() > 0.0) {
            return ComponentType.Undefined;
        }
        Sequence[] sequences = var.getSequences();
        int maxseq = 0;
        for (int i = 0; i < sequences.length; ++i) {
            int len = sequences[i].end.difference(sequences[i].start) / 365;
            if (len <= maxseq) continue;
            maxseq = len;
        }
        if (maxseq > 0) {
            return var.getDeltaS() == 0.0 ? ComponentType.Trend : ComponentType.Undefined;
        }
        if (var.getDeltaS() > 0.0) {
            return ComponentType.Seasonal;
        }
        if (var.getDelta() > 0.8) {
            return ComponentType.Trend;
        }
        return ComponentType.Irregular;
    }

    public static ComponentType getType(ITsVariable var) {
        if (var instanceof IOutlierVariable) {
            return DeterministicComponent.getType((IOutlierVariable)var);
        }
        if (var instanceof ICalendarVariable) {
            return ComponentType.CalendarEffect;
        }
        if (var instanceof IMovingHolidayVariable) {
            return ComponentType.CalendarEffect;
        }
        if (var instanceof InterventionVariable) {
            return DeterministicComponent.getType((InterventionVariable)var);
        }
        if (var instanceof Ramp) {
            return ComponentType.Trend;
        }
        if (var instanceof UserVariable) {
            return ((UserVariable)var).getType();
        }
        if (var instanceof Constant || var instanceof DiffConstant) {
            return ComponentType.Trend;
        }
        if (var instanceof ITsModifier) {
            ITsModifier m = (ITsModifier)var;
            return DeterministicComponent.getType(m.getVariable());
        }
        return ComponentType.Undefined;
    }

    public TsDomain getSeriesDomain() {
        return this.original_.getDomain();
    }

    public TsDomain getEstimationDomain() {
        return this.y_.getDomain();
    }

    public int getFrequency() {
        return this.y_.getFrequency().intValue();
    }

    public DefaultTransformationType getTransformation() {
        return this.function_;
    }

    public LengthOfPeriodType getLengthOfPeriodAdjustment() {
        return this.lp_;
    }

    public double getUnits() {
        return this.units_;
    }

    public void setTransformation(DefaultTransformationType fn) {
        this.function_ = fn;
    }

    public void setLengthOfPeriodAdjustment(LengthOfPeriodType lp) {
        this.lp_ = lp;
    }

    public void setUnits(double u) {
        this.units_ = u;
    }

    public List<ITsDataTransformation> backTransformations(boolean T2, boolean S) {
        ArrayList<ITsDataTransformation> tr = new ArrayList<ITsDataTransformation>();
        if (this.function_ == DefaultTransformationType.Log) {
            tr.add(new ExpTransformation());
        }
        if (S && this.lp_ != LengthOfPeriodType.None) {
            tr.add(new LengthOfPeriodTransformation(this.lp_).converse());
        }
        if (this.units_ != 1.0 && (this.function_ == DefaultTransformationType.Log || T2)) {
            tr.add(ConstTransformation.unit(1.0 / this.units_));
        }
        return tr;
    }

    public void backTransform(TsData s, boolean T2, boolean S) {
        if (s == null) {
            return;
        }
        List<ITsDataTransformation> back = this.backTransformations(T2, S);
        for (ITsDataTransformation t : back) {
            t.transform(s, null);
        }
    }

    public TsData interpolatedSeries(boolean bTransformed) {
        TsData y = this.y_.clone();
        if (!bTransformed) {
            this.backTransform(y, true, true);
        }
        return y;
    }

    public TsData linearizedSeries() {
        TsData interp = this.interpolatedSeries(true);
        TsData regs = this.regressionEffect(this.getSeriesDomain());
        return TsData.subtract(interp, regs);
    }

    public <T extends ITsVariable> TsData regressionEffect(TsDomain domain) {
        if (this.b_ == null) {
            return new TsData(domain, 0.0);
        }
        DataBlock sum = PreadjustmentVariable.regressionEffect(this.x_.stream(), domain);
        if (sum == null) {
            sum = new DataBlock(domain.getLength());
        }
        TsData rslt = new TsData(domain.getStart(), sum.getData(), false);
        return rslt;
    }

    public <T extends ITsVariable> TsData regressionEffect(TsDomain domain, Class<T> tclass) {
        DataBlock sum = PreadjustmentVariable.regressionEffect(this.x_.stream(), domain, tclass);
        if (sum == null) {
            sum = new DataBlock(domain.getLength());
        }
        TsData rslt = new TsData(domain.getStart(), sum.getData(), false);
        return rslt;
    }

    private TsData regressionEffect(TsDomain domain, Predicate<PreadjustmentVariable> selector) {
        DataBlock sum = PreadjustmentVariable.regressionEffect(this.x_.stream(), domain, selector);
        return new TsData(domain.getStart(), sum.getData(), false);
    }

    public TsData outliersEffect(TsDomain domain) {
        return this.regressionEffect(domain, (PreadjustmentVariable reg) -> reg.isOutlier());
    }

    public TsData outliersEffect(TsDomain domain, ComponentType type) {
        if (type == ComponentType.Undefined) {
            return this.regressionEffect(domain, (PreadjustmentVariable reg) -> reg.isOutlier());
        }
        return this.regressionEffect(domain, (PreadjustmentVariable reg) -> reg.getType() == type && reg.isOutlier());
    }

    public List<TsData> regressors(TsDomain domain) {
        ArrayList<TsData> regs = new ArrayList<TsData>();
        this.x_.stream().forEach(var -> {
            DataBlock z = new DataBlock(domain.getLength());
            var.addEffect(z, domain);
            regs.add(new TsData(domain.getStart(), z.getData(), false));
        });
        return regs;
    }

    public TsData deterministicEffect(TsDomain domain, ComponentType type) {
        return this.regressionEffect(domain, (PreadjustmentVariable reg) -> reg.getType() == type);
    }

    public TsData userEffect(TsDomain domain, ComponentType type) {
        return this.regressionEffect(domain, (PreadjustmentVariable reg) -> reg.getType() == type && reg.isUser());
    }

    public int countVariables(Predicate<PreadjustmentVariable> pred) {
        int n = 0;
        for (PreadjustmentVariable var : this.x_) {
            if (!pred.test(var)) continue;
            ++n;
        }
        return n;
    }

    public int countRegressors(Predicate<PreadjustmentVariable> pred) {
        int n = 0;
        for (PreadjustmentVariable var : this.x_) {
            if (!pred.test(var)) continue;
            n += var.getVariable().getDim();
        }
        return n;
    }

    @Override
    public Map<String, Class> getDictionary() {
        return DeterministicComponent.dictionary(false);
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        if (MAPPING.contains(id)) {
            return MAPPING.getData(this, id, tclass);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String id) {
        InformationMapping<DeterministicComponent> informationMapping = MAPPING;
        synchronized (informationMapping) {
            return MAPPING.contains(id);
        }
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.EMPTY_LIST;
    }

    public static void fillDictionary(String prefix, Map<String, Class> map, boolean compact) {
        MAPPING.fillDictionary(prefix, map, compact);
        ModelEstimation.fillDictionary(prefix, map, compact);
    }

    public static Map<String, Class> dictionary(boolean compact) {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        DeterministicComponent.fillDictionary(null, map, compact);
        return map;
    }

    private TsData op(TsData l, TsData r) {
        if (this.function_ == DefaultTransformationType.Log) {
            return TsData.multiply(l, r);
        }
        return TsData.add(l, r);
    }

    private TsData inv_op(TsData l, TsData r) {
        if (this.function_ == DefaultTransformationType.Log) {
            return TsData.divide(l, r);
        }
        return TsData.subtract(l, r);
    }

    private int getForecastCount() {
        return 1 * this.getFrequency();
    }

    private TsDomain domain(boolean fcast) {
        if (fcast) {
            TsDomain dom = this.getSeriesDomain();
            return new TsDomain(dom.getEnd(), 1 * dom.getFrequency().intValue());
        }
        return this.getSeriesDomain();
    }

    public boolean isMultiplicative() {
        return this.function_ == DefaultTransformationType.Log;
    }

    public boolean setCoefficients(IReadDataBlock c) {
        if (c.getLength() != this.countRegressors(reg -> true)) {
            return false;
        }
        int cur = 0;
        for (PreadjustmentVariable var : this.x_) {
            int n = var.getCoefficients().length;
            c.rextract(cur, n).copyTo(var.getCoefficients(), 0);
            cur += n;
        }
        return true;
    }

    public static InformationMapping<DeterministicComponent> getMapping() {
        return MAPPING;
    }

    public static <T> void setMapping(String name, Class<T> tclass, Function<DeterministicComponent, T> extractor) {
        MAPPING.set(name, tclass, extractor);
    }

    public static <T> void setTsData(String name, Function<DeterministicComponent, TsData> extractor) {
        MAPPING.set(name, extractor);
    }

    static {
        MAPPING.set(LOG, Boolean.class, source -> source.isMultiplicative());
        MAPPING.set(ADJUST, Boolean.class, source -> source.getLengthOfPeriodAdjustment() != LengthOfPeriodType.None);
        MAPPING.set("y", source -> source.getOriginal());
        MAPPING.set("yc", source -> source.interpolatedSeries(false));
        MAPPING.set("y_lin", source -> source.linearizedSeries());
        MAPPING.set("l", source -> source.linearizedSeries());
        MAPPING.set("ycal", source -> {
            TsData td = source.regressionEffect(source.domain(true), ICalendarVariable.class);
            TsData mh = source.regressionEffect(source.domain(true), IMovingHolidayVariable.class);
            TsData cal = TsData.add(td, mh);
            source.backTransform(cal, false, true);
            return source.inv_op(source.interpolatedSeries(false), cal);
        });
        MAPPING.set("det", source -> {
            TsData reg = source.regressionEffect(source.domain(false));
            source.backTransform(reg, false, true);
            return reg;
        });
        MAPPING.set("det_f", source -> {
            TsData reg = source.regressionEffect(source.domain(true));
            source.backTransform(reg, false, true);
            return reg;
        });
        MAPPING.set("cal", source -> {
            TsData td = source.regressionEffect(source.domain(false), ICalendarVariable.class);
            TsData mh = source.regressionEffect(source.domain(false), IMovingHolidayVariable.class);
            TsData cal = TsData.add(td, mh);
            source.backTransform(cal, false, true);
            return cal;
        });
        MAPPING.set("cal_f", source -> {
            TsData td = source.regressionEffect(source.domain(true), ICalendarVariable.class);
            TsData mh = source.regressionEffect(source.domain(true), IMovingHolidayVariable.class);
            TsData cal = TsData.add(td, mh);
            source.backTransform(cal, false, true);
            return cal;
        });
        MAPPING.set("tde", source -> {
            TsData cal = source.regressionEffect(source.domain(false), ICalendarVariable.class);
            source.backTransform(cal, false, true);
            return cal;
        });
        MAPPING.set("tde_f", source -> {
            TsData cal = source.regressionEffect(source.domain(true), ICalendarVariable.class);
            source.backTransform(cal, false, true);
            return cal;
        });
        MAPPING.set("ee", source -> {
            TsData cal = source.regressionEffect(source.domain(false), IEasterVariable.class);
            source.backTransform(cal, false, false);
            return cal;
        });
        MAPPING.set("ee_f", source -> {
            TsData cal = source.regressionEffect(source.domain(true), IEasterVariable.class);
            source.backTransform(cal, false, false);
            return cal;
        });
        MAPPING.set("omhe", source -> {
            TsData cal = source.regressionEffect(source.domain(false), (PreadjustmentVariable var) -> var instanceof IMovingHolidayVariable && !(var instanceof IEasterVariable));
            source.backTransform(cal, false, false);
            return cal;
        });
        MAPPING.set("omhe_f", source -> {
            TsData cal = source.regressionEffect(source.domain(true), (PreadjustmentVariable var) -> var instanceof IMovingHolidayVariable && !(var instanceof IEasterVariable));
            source.backTransform(cal, false, false);
            return cal;
        });
        MAPPING.set("mhe", source -> {
            TsData cal = source.regressionEffect(source.domain(false), IMovingHolidayVariable.class);
            source.backTransform(cal, false, false);
            return cal;
        });
        MAPPING.set("mhe_f", source -> {
            TsData cal = source.regressionEffect(source.domain(true), IMovingHolidayVariable.class);
            source.backTransform(cal, false, false);
            return cal;
        });
        MAPPING.set("out", source -> {
            TsData o = source.outliersEffect(source.domain(false));
            source.backTransform(o, false, false);
            return o;
        });
        MAPPING.set("out_f", source -> {
            TsData o = source.outliersEffect(source.domain(true));
            source.backTransform(o, false, false);
            return o;
        });
        MAPPING.set("out_i", source -> {
            TsData o = source.outliersEffect(source.domain(false), ComponentType.Irregular);
            source.backTransform(o, false, false);
            return o;
        });
        MAPPING.set("out_i_f", source -> {
            TsData o = source.outliersEffect(source.domain(true), ComponentType.Irregular);
            source.backTransform(o, false, false);
            return o;
        });
        MAPPING.set("out_t", source -> {
            TsData o = source.outliersEffect(source.domain(false), ComponentType.Trend);
            source.backTransform(o, false, false);
            return o;
        });
        MAPPING.set("out_t_f", source -> {
            TsData o = source.outliersEffect(source.domain(true), ComponentType.Trend);
            source.backTransform(o, false, false);
            return o;
        });
        MAPPING.set("out_s", source -> {
            TsData o = source.outliersEffect(source.domain(false), ComponentType.Seasonal);
            source.backTransform(o, false, false);
            return o;
        });
        MAPPING.set("out_s_f", source -> {
            TsData o = source.outliersEffect(source.domain(true), ComponentType.Seasonal);
            source.backTransform(o, false, false);
            return o;
        });
        MAPPING.set("reg", source -> {
            TsData r = source.regressionEffect(source.domain(false), UserVariable.class);
            source.backTransform(r, false, false);
            return r;
        });
        MAPPING.set("reg_f", source -> {
            TsData r = source.regressionEffect(source.domain(true), UserVariable.class);
            source.backTransform(r, false, false);
            return r;
        });
        MAPPING.set("reg_t", source -> {
            TsData r = source.userEffect(source.domain(false), ComponentType.Trend);
            source.backTransform(r, false, false);
            return r;
        });
        MAPPING.set("reg_t_f", source -> {
            TsData r = source.userEffect(source.domain(true), ComponentType.Trend);
            source.backTransform(r, false, false);
            return r;
        });
        MAPPING.set("reg_s", source -> {
            TsData r = source.userEffect(source.domain(false), ComponentType.Seasonal);
            source.backTransform(r, false, false);
            return r;
        });
        MAPPING.set("reg_s_f", source -> {
            TsData r = source.userEffect(source.domain(true), ComponentType.Seasonal);
            source.backTransform(r, false, false);
            return r;
        });
        MAPPING.set("reg_i", source -> {
            TsData r = source.userEffect(source.domain(false), ComponentType.Irregular);
            source.backTransform(r, false, false);
            return r;
        });
        MAPPING.set("reg_i_f", source -> {
            TsData r = source.userEffect(source.domain(true), ComponentType.Irregular);
            source.backTransform(r, false, false);
            return r;
        });
        MAPPING.set("reg_sa", source -> {
            TsData r = source.userEffect(source.domain(false), ComponentType.SeasonallyAdjusted);
            source.backTransform(r, false, false);
            return r;
        });
        MAPPING.set("reg_sa_f", source -> {
            TsData r = source.userEffect(source.domain(true), ComponentType.SeasonallyAdjusted);
            source.backTransform(r, false, false);
            return r;
        });
        MAPPING.set("reg_y", source -> {
            TsData r = source.userEffect(source.domain(false), ComponentType.Series);
            source.backTransform(r, false, false);
            return r;
        });
        MAPPING.set("reg_y_f", source -> {
            TsData r = source.userEffect(source.domain(true), ComponentType.Series);
            source.backTransform(r, false, false);
            return r;
        });
        MAPPING.set(NTD, Integer.class, source -> source.countRegressors(reg -> reg.isCalendar()));
        MAPPING.set(NMH, Integer.class, source -> source.countRegressors(reg -> reg.isMovingHoliday()));
    }
}

