/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.sarima;

import ec.tstoolkit.Parameter;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.arima.AbstractArimaComponent;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import java.util.Arrays;

public class SarimaComponent
extends AbstractArimaComponent
implements Cloneable {
    private int m_D;
    private int m_BD;
    private int m_S;
    private Parameter[] m_phi;
    private Parameter[] m_theta;
    private Parameter[] m_bphi;
    private Parameter[] m_btheta;

    public SarimaComponent() {
    }

    public SarimaComponent(int freq) {
        this.m_S = freq;
    }

    @Override
    public SarimaComponent clone() {
        try {
            SarimaComponent cmp = (SarimaComponent)super.clone();
            cmp.m_phi = Parameter.clone(this.m_phi);
            cmp.m_bphi = Parameter.clone(this.m_bphi);
            cmp.m_theta = Parameter.clone(this.m_theta);
            cmp.m_btheta = Parameter.clone(this.m_btheta);
            return cmp;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public void setParameterType(ParameterType type) {
        int i;
        if (this.m_phi != null) {
            for (i = 0; i < this.m_phi.length; ++i) {
                this.m_phi[i].setType(type);
            }
        }
        if (this.m_bphi != null) {
            for (i = 0; i < this.m_bphi.length; ++i) {
                this.m_bphi[i].setType(type);
            }
        }
        if (this.m_theta != null) {
            for (i = 0; i < this.m_theta.length; ++i) {
                this.m_theta[i].setType(type);
            }
        }
        if (this.m_btheta != null) {
            for (i = 0; i < this.m_btheta.length; ++i) {
                this.m_btheta[i].setType(type);
            }
        }
    }

    public void clearParameters() {
        int i;
        if (this.m_phi != null) {
            for (i = 0; i < this.m_phi.length; ++i) {
                this.m_phi[i] = new Parameter();
            }
        }
        if (this.m_bphi != null) {
            for (i = 0; i < this.m_bphi.length; ++i) {
                this.m_bphi[i] = new Parameter();
            }
        }
        if (this.m_theta != null) {
            for (i = 0; i < this.m_theta.length; ++i) {
                this.m_theta[i] = new Parameter();
            }
        }
        if (this.m_btheta != null) {
            for (i = 0; i < this.m_btheta.length; ++i) {
                this.m_btheta[i] = new Parameter();
            }
        }
    }

    public void clearFreeParameters() {
        int i;
        if (this.m_phi != null) {
            for (i = 0; i < this.m_phi.length; ++i) {
                if (this.m_phi[i] != null && this.m_phi[i].isFixed()) continue;
                this.m_phi[i] = new Parameter();
            }
        }
        if (this.m_bphi != null) {
            for (i = 0; i < this.m_bphi.length; ++i) {
                if (this.m_bphi[i] != null && this.m_bphi[i].isFixed()) continue;
                this.m_bphi[i] = new Parameter();
            }
        }
        if (this.m_theta != null) {
            for (i = 0; i < this.m_theta.length; ++i) {
                if (this.m_theta[i] != null && this.m_theta[i].isFixed()) continue;
                this.m_theta[i] = new Parameter();
            }
        }
        if (this.m_btheta != null) {
            for (i = 0; i < this.m_btheta.length; ++i) {
                if (this.m_btheta[i] != null && this.m_btheta[i].isFixed()) continue;
                this.m_btheta[i] = new Parameter();
            }
        }
    }

    public void updateParameters(SarimaComponent aspec) {
        this.updateParameters(this.m_phi, aspec.m_phi);
        this.updateParameters(this.m_theta, aspec.m_theta);
        this.updateParameters(this.m_bphi, aspec.m_bphi);
        this.updateParameters(this.m_btheta, aspec.m_btheta);
    }

    private void updateParameters(Parameter[] target, Parameter[] source) {
        if (target == null || source == null || target.length != source.length) {
            return;
        }
        for (int i = 0; i < target.length; ++i) {
            if (target[i] != null && target[i].getType() == ParameterType.Fixed || source[i] == null) continue;
            target[i] = source[i].clone();
        }
    }

    public void airline(int freq) {
        this.m_S = freq;
        this.setP(0);
        this.m_D = 1;
        this.setQ(1);
        this.setBP(0);
        this.m_BD = 1;
        this.setBQ(1);
        this.setMean(false);
    }

    public void airlineWithMean(int freq) {
        this.m_S = freq;
        this.setP(0);
        this.m_D = 1;
        this.setQ(1);
        this.setBP(0);
        this.m_BD = 1;
        this.setBQ(1);
        this.setMean(true);
    }

    public int getP() {
        return this.m_phi == null ? 0 : this.m_phi.length;
    }

    public void setP(int value) {
        this.m_phi = Parameter.create(value);
    }

    public int getD() {
        return this.m_D;
    }

    public void setD(int value) {
        this.m_D = value;
    }

    public int getQ() {
        return this.m_theta == null ? 0 : this.m_theta.length;
    }

    public void setQ(int value) {
        this.m_theta = Parameter.create(value);
    }

    public int getS() {
        return this.m_S;
    }

    public void setS(int value) {
        this.m_S = value;
        if (this.m_S == 1) {
            this.m_BD = 0;
            this.m_bphi = null;
            this.m_btheta = null;
        }
    }

    public int getBP() {
        return this.m_bphi == null ? 0 : this.m_bphi.length;
    }

    public void setBP(int value) {
        this.m_bphi = Parameter.create(value);
    }

    public int getBD() {
        return this.m_BD;
    }

    public void setBD(int value) {
        this.m_BD = value;
    }

    public int getBQ() {
        return this.m_btheta == null ? 0 : this.m_btheta.length;
    }

    public void setBQ(int value) {
        this.m_btheta = Parameter.create(value);
    }

    public Parameter[] getPhi() {
        return this.m_phi;
    }

    public void setPhi(Parameter[] value) {
        this.m_phi = Parameter.clone(value);
    }

    public Parameter[] getTheta() {
        return this.m_theta;
    }

    public void setTheta(Parameter[] value) {
        this.m_theta = Parameter.clone(value);
    }

    public Parameter[] getBPhi() {
        return this.m_bphi;
    }

    public void setBPhi(Parameter[] value) {
        this.m_bphi = Parameter.clone(value);
    }

    public Parameter[] getBTheta() {
        return this.m_btheta;
    }

    public void setBTheta(Parameter[] value) {
        this.m_btheta = Parameter.clone(value);
    }

    public int getDifferencingOrder() {
        return this.m_D + this.m_BD * this.m_S;
    }

    public BackFilter getDifferencingFilter() {
        int i;
        UnitRoots ur = new UnitRoots();
        if (this.m_S > 1) {
            for (i = 0; i < this.m_BD; ++i) {
                ur.add(this.m_S);
            }
        }
        for (i = 0; i < this.m_D; ++i) {
            ur.add(1);
        }
        return new BackFilter(ur.toPolynomial());
    }

    public int getFrequency() {
        return this.m_S;
    }

    public void setFrequency(int freq) {
        this.m_S = freq;
        if (freq == 1) {
            this.m_BD = 0;
            this.m_bphi = null;
            this.m_btheta = null;
        }
    }

    public SarimaModel getModel() {
        int i;
        SarimaSpecification spec = new SarimaSpecification(this.m_S);
        spec.setP(this.getP());
        spec.setD(this.m_D);
        spec.setQ(this.getQ());
        spec.setBP(this.getBP());
        spec.setBD(this.m_BD);
        spec.setBQ(this.getBQ());
        SarimaModel sarima = new SarimaModel(spec);
        Parameter[] p = this.m_phi;
        for (i = 0; i < spec.getP(); ++i) {
            if (p[i] == null || p[i].getType() == ParameterType.Undefined) continue;
            sarima.setPhi(i + 1, p[i].getValue());
        }
        p = this.m_theta;
        for (i = 0; i < spec.getQ(); ++i) {
            if (p[i] == null || p[i].getType() == ParameterType.Undefined) continue;
            sarima.setTheta(i + 1, p[i].getValue());
        }
        p = this.m_bphi;
        for (i = 0; i < spec.getBP(); ++i) {
            if (p[i] == null || p[i].getType() == ParameterType.Undefined) continue;
            sarima.setBPhi(i + 1, p[i].getValue());
        }
        p = this.m_btheta;
        for (i = 0; i < spec.getBQ(); ++i) {
            if (p[i] == null || p[i].getType() == ParameterType.Undefined) continue;
            sarima.setBTheta(i + 1, p[i].getValue());
        }
        return sarima;
    }

    public SarimaSpecification getSpecification() {
        SarimaSpecification spec = new SarimaSpecification(this.m_S);
        spec.setP(this.getP());
        spec.setD(this.m_D);
        spec.setQ(this.getQ());
        spec.setBP(this.getBP());
        spec.setBD(this.m_BD);
        spec.setBQ(this.getBQ());
        return spec;
    }

    public boolean isDefined() {
        return Parameter.isDefined(this.m_phi) && Parameter.isDefined(this.m_theta) && Parameter.isDefined(this.m_bphi) && Parameter.isDefined(this.m_btheta);
    }

    public boolean isUndefined() {
        return Parameter.isDefault(this.m_phi) && Parameter.isDefault(this.m_theta) && Parameter.isDefault(this.m_bphi) && Parameter.isDefault(this.m_btheta);
    }

    public void setSpecification(SarimaSpecification spec) {
        this.setP(spec.getP());
        this.m_D = spec.getD();
        this.setQ(spec.getQ());
        this.setBP(spec.getBP());
        this.m_BD = spec.getBD();
        this.setBQ(spec.getBQ());
        this.m_S = spec.getFrequency();
    }

    public void setModel(IArimaModel value) {
        this.setModel((SarimaModel)value);
    }

    public void setModel(SarimaModel value) {
        int i;
        SarimaSpecification spec = value.getSpecification();
        this.setP(spec.getP());
        this.m_D = spec.getD();
        this.setQ(spec.getQ());
        this.setBP(spec.getBP());
        this.m_BD = spec.getBD();
        this.setBQ(spec.getBQ());
        this.m_S = spec.getFrequency();
        Parameter[] p = this.m_phi;
        for (i = 0; i < spec.getP(); ++i) {
            p[i] = new Parameter(value.phi(i + 1), ParameterType.Estimated);
        }
        p = this.m_theta;
        for (i = 0; i < spec.getQ(); ++i) {
            p[i] = new Parameter(value.theta(i + 1), ParameterType.Estimated);
        }
        p = this.m_bphi;
        for (i = 0; i < spec.getBP(); ++i) {
            p[i] = new Parameter(value.bphi(i + 1), ParameterType.Estimated);
        }
        p = this.m_btheta;
        for (i = 0; i < spec.getBQ(); ++i) {
            p[i] = new Parameter(value.btheta(i + 1), ParameterType.Estimated);
        }
    }

    public int getParametersCount() {
        return this.getP() + this.getBP() + this.getQ() + this.getBQ();
    }

    public int getFreeParametersCount() {
        int n = Parameter.countFreeParameters(this.m_phi);
        n += Parameter.countFreeParameters(this.m_bphi);
        n += Parameter.countFreeParameters(this.m_theta);
        return n += Parameter.countFreeParameters(this.m_btheta);
    }

    public int getFixedParametersCount() {
        int n = Parameter.countFixedParameters(this.m_phi);
        n += Parameter.countFixedParameters(this.m_bphi);
        n += Parameter.countFixedParameters(this.m_theta);
        return n += Parameter.countFixedParameters(this.m_btheta);
    }

    public boolean[] getFixedConstraints() {
        int i;
        int n = this.getParametersCount();
        boolean[] fixed = new boolean[n];
        int j = 0;
        if (this.m_phi != null) {
            i = 0;
            while (i < this.m_phi.length) {
                if (this.m_phi[i] != null && this.m_phi[i].getType() == ParameterType.Fixed) {
                    fixed[j] = true;
                }
                ++i;
                ++j;
            }
        }
        if (this.m_bphi != null) {
            i = 0;
            while (i < this.m_bphi.length) {
                if (this.m_bphi[i] != null && this.m_bphi[i].getType() == ParameterType.Fixed) {
                    fixed[j] = true;
                }
                ++i;
                ++j;
            }
        }
        if (this.m_theta != null) {
            i = 0;
            while (i < this.m_theta.length) {
                if (this.m_theta[i] != null && this.m_theta[i].getType() == ParameterType.Fixed) {
                    fixed[j] = true;
                }
                ++i;
                ++j;
            }
        }
        if (this.m_btheta != null) {
            i = 0;
            while (i < this.m_btheta.length) {
                if (this.m_btheta[i] != null && this.m_btheta[i].getType() == ParameterType.Fixed) {
                    fixed[j] = true;
                }
                ++i;
                ++j;
            }
        }
        return fixed;
    }

    public double[] getParameters() {
        int i;
        int n = this.getParametersCount();
        double[] p = new double[n];
        int j = 0;
        if (this.m_phi != null) {
            i = 0;
            while (i < this.m_phi.length) {
                if (this.m_phi[i] != null) {
                    p[j] = this.m_phi[i].getValue();
                }
                ++i;
                ++j;
            }
        }
        if (this.m_bphi != null) {
            i = 0;
            while (i < this.m_bphi.length) {
                if (this.m_bphi[i] != null) {
                    p[j] = this.m_bphi[i].getValue();
                }
                ++i;
                ++j;
            }
        }
        if (this.m_theta != null) {
            i = 0;
            while (i < this.m_theta.length) {
                if (this.m_theta[i] != null) {
                    p[j] = this.m_theta[i].getValue();
                }
                ++i;
                ++j;
            }
        }
        if (this.m_btheta != null) {
            i = 0;
            while (i < this.m_btheta.length) {
                if (this.m_btheta[i] != null) {
                    p[j] = this.m_btheta[i].getValue();
                }
                ++i;
                ++j;
            }
        }
        return p;
    }

    public void setParameters(IReadDataBlock p, IReadDataBlock stde, ParameterType type) {
        int i;
        int j = 0;
        if (this.m_phi != null) {
            i = 0;
            while (i < this.m_phi.length) {
                if (this.m_phi[i] == null) {
                    this.m_phi[i] = new Parameter(p.get(j), type);
                } else if (!this.m_phi[i].isFixed()) {
                    this.m_phi[i].setValue(p.get(j));
                    this.m_phi[i].setType(type);
                }
                if (stde != null) {
                    this.m_phi[i].setStde(stde.get(j));
                }
                ++i;
                ++j;
            }
        }
        if (this.m_bphi != null) {
            i = 0;
            while (i < this.m_bphi.length) {
                if (this.m_bphi[i] == null) {
                    this.m_bphi[i] = new Parameter(p.get(j), type);
                } else if (!this.m_bphi[i].isFixed()) {
                    this.m_bphi[i].setValue(p.get(j));
                    this.m_bphi[i].setType(type);
                }
                if (stde != null) {
                    this.m_bphi[i].setStde(stde.get(j));
                }
                ++i;
                ++j;
            }
        }
        if (this.m_theta != null) {
            i = 0;
            while (i < this.m_theta.length) {
                if (this.m_theta[i] == null) {
                    this.m_theta[i] = new Parameter(p.get(j), type);
                } else if (!this.m_theta[i].isFixed()) {
                    this.m_theta[i].setValue(p.get(j));
                    this.m_theta[i].setType(type);
                }
                if (stde != null) {
                    this.m_theta[i].setStde(stde.get(j));
                }
                ++i;
                ++j;
            }
        }
        if (this.m_btheta != null) {
            i = 0;
            while (i < this.m_btheta.length) {
                if (this.m_btheta[i] == null) {
                    this.m_btheta[i] = new Parameter(p.get(j), type);
                } else if (!this.m_btheta[i].isFixed()) {
                    this.m_btheta[i].setValue(p.get(j));
                    this.m_btheta[i].setType(type);
                }
                if (stde != null) {
                    this.m_btheta[i].setStde(stde.get(j));
                }
                ++i;
                ++j;
            }
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SarimaComponent && this.equals((SarimaComponent)obj);
    }

    private boolean equals(SarimaComponent other) {
        return other.m_BD == this.m_BD && other.m_D == this.m_D && other.m_S == this.m_S && Arrays.deepEquals(this.m_phi, this.m_phi) && Arrays.deepEquals(this.m_bphi, this.m_bphi) && Arrays.deepEquals(this.m_theta, this.m_theta) && Arrays.deepEquals(this.m_btheta, this.m_btheta);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + this.m_D;
        hash = 97 * hash + this.m_BD;
        hash = 97 * hash + this.m_S;
        hash = 97 * hash + Arrays.deepHashCode(this.m_phi);
        hash = 97 * hash + Arrays.deepHashCode(this.m_theta);
        hash = 97 * hash + Arrays.deepHashCode(this.m_bphi);
        hash = 97 * hash + Arrays.deepHashCode(this.m_btheta);
        return hash;
    }
}

