/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.diagnostics;

import ec.businesscycle.impl.HodrickPrescott;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.maths.matrices.HouseholderR;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.stats.Anova;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.Jdk6;
import java.util.Collection;

public class IBTest {
    private TsDomain common_;
    private TsData[] series_;
    private TsData[] aseries_;
    private double lambda_ = 1600.0;
    private RegModel model_;
    private HouseholderR qr_;

    public boolean process(Collection<TsData> series) {
        if (!this.initSeries(series)) {
            return false;
        }
        if (!this.initModel()) {
            return false;
        }
        return this.computeModel();
    }

    private boolean initSeries(Collection<TsData> series) {
        if (Jdk6.Collections.isNullOrEmpty(series) || Jdk6.Collections.hasEmptyElements(series)) {
            return false;
        }
        this.common_ = null;
        for (TsData s : series) {
            this.common_ = TsDomain.and(this.common_, s.getDomain());
        }
        if (this.common_.isEmpty()) {
            return false;
        }
        if (this.common_.getFrequency() == TsFrequency.Yearly) {
            return false;
        }
        this.series_ = Jdk6.Collections.toArray(series, TsData.class);
        this.series_ = new TsData[series.size()];
        this.aseries_ = new TsData[this.series_.length];
        HodrickPrescott hp = new HodrickPrescott();
        hp.setLambda(this.getLambda());
        int idx = 0;
        for (TsData s : series) {
            TsData sc = s.fittoDomain(this.common_);
            sc.normalize();
            this.series_[idx] = sc;
            if (!hp.process(sc)) {
                return false;
            }
            TsData n = new TsData(this.common_.getStart(), hp.getNoise(), false);
            this.aseries_[idx] = n.abs();
            ++idx;
        }
        return true;
    }

    private boolean initModel() {
        int i;
        int n = this.common_.getLength();
        int m = this.aseries_.length;
        if (m == 1) {
            return false;
        }
        DataBlock tot = new DataBlock(n * m);
        DataBlock x = tot.extract(0, n);
        for (int i2 = 0; i2 < this.aseries_.length; ++i2) {
            x.copy(this.aseries_[i2]);
            x.slide(n);
        }
        int ifreq = this.common_.getFrequency().intValue();
        Matrix month = new Matrix(m * n, ifreq);
        for (int j = 0; j < m; ++j) {
            SubMatrix Q = month.subMatrix(j * n, (j + 1) * n, 0, ifreq);
            for (int i3 = 0; i3 < ifreq; ++i3) {
                Q.column(i3).extract(i3, -1, ifreq).set(1.0);
            }
        }
        Matrix series = new Matrix(m * n, m);
        for (int i4 = 0; i4 < m; ++i4) {
            series.column(i4).extract(i4 * n, n).set(1.0);
        }
        int ny = this.common_.getYearsCount();
        if (ny == 1) {
            return false;
        }
        Matrix year = new Matrix(m * n, ny);
        for (int j = 0; j < m; ++j) {
            SubMatrix Z = year.subMatrix(j * n, (j + 1) * n, 0, ny);
            TsPeriod start = this.common_.getStart();
            start.move(start.getPosition());
            for (int i5 = 0; i5 < ny; ++i5) {
                int i0 = this.common_.search(start);
                if (i0 < 0) {
                    i0 = 0;
                }
                int i1 = Math.min(i0 + ifreq, n);
                Z.column(i5).extract(i0, i1 - i0).set(1.0);
                start.move(ifreq);
            }
        }
        this.model_ = new RegModel();
        this.model_.setY(tot);
        this.model_.setMeanCorrection(true);
        for (i = 1; i < ifreq; ++i) {
            this.model_.addX(month.column(i));
        }
        for (i = 1; i < ny; ++i) {
            this.model_.addX(year.column(i));
        }
        for (i = 1; i < m; ++i) {
            this.model_.addX(series.column(i));
        }
        return true;
    }

    private boolean computeModel() {
        this.qr_ = new HouseholderR(false);
        this.qr_.setEpsilon(1.0E-9);
        this.qr_.decompose(this.model_.variables());
        return true;
    }

    public int getPeriodVarsCount() {
        return this.common_.getFrequency().intValue() - 1;
    }

    public int getYearVarsCount() {
        return this.common_.getYearsCount() - 1;
    }

    public int getSeriesVarsCount() {
        return this.series_.length - 1;
    }

    public RegModel getModel() {
        return this.model_;
    }

    public TsDomain getDomain() {
        return this.common_;
    }

    public TsData getStationaryAbsoluteSeries(int i) {
        return this.aseries_[i];
    }

    public TsData getSeries(int i) {
        return this.series_[i];
    }

    public int getSeriesCount() {
        return this.series_.length;
    }

    public double getLambda() {
        return this.lambda_;
    }

    public void setLambda(double lambda) {
        this.lambda_ = lambda;
    }

    public Anova anova() {
        return new Anova(this.model_, new int[]{this.getPeriodVarsCount(), this.getYearVarsCount(), this.getSeriesVarsCount()});
    }
}

