/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.tramo.AbstractTramoModule;
import ec.tstoolkit.modelling.arima.tramo.LogLevelTest;
import ec.tstoolkit.modelling.arima.tramo.OutliersDetector;
import ec.tstoolkit.modelling.arima.tramo.RegressionVariablesTest;
import ec.tstoolkit.modelling.arima.tramo.TramoModelEstimator;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.EasterVariable;
import ec.tstoolkit.timeseries.regression.GregorianCalendarVariables;
import ec.tstoolkit.timeseries.regression.LeapYearVariable;
import ec.tstoolkit.timeseries.simplets.AverageInterpolator;
import ec.tstoolkit.timeseries.simplets.TsData;

public class TramoMonitors {
    static void addEaster(ModelDescription desc) {
        EasterVariable easter = new EasterVariable();
        easter.setDuration(6);
        easter.includeEaster(true);
        easter.setType(EasterVariable.Correction.Simple);
        desc.getMovingHolidays().add(Variable.movingHolidayVariable(easter, RegStatus.ToRemove));
    }

    static void addTradingDays(ModelDescription desc, int ntd) {
        GregorianCalendarVariables td;
        if (ntd == 1 || ntd == 2) {
            td = GregorianCalendarVariables.getDefault(TradingDaysType.WorkingDays);
            desc.addVariable(Variable.calendarVariable(td, RegStatus.ToRemove));
        } else if (ntd == 6 || ntd == 7) {
            td = GregorianCalendarVariables.getDefault(TradingDaysType.TradingDays);
            desc.addVariable(Variable.calendarVariable(td, RegStatus.ToRemove));
        }
        if (ntd == 2 || ntd == 7) {
            LeapYearVariable lp = new LeapYearVariable(LengthOfPeriodType.LeapYear);
            desc.addVariable(Variable.calendarVariable(lp, RegStatus.ToRemove));
        }
    }

    static IPreprocessingModule buildOutliers() {
        OutliersDetector outliers = new OutliersDetector();
        outliers.setDefault();
        return outliers;
    }

    static class Rsa2
    extends AbstractTramoModule
    implements IPreprocessor {
        IPreprocessingModule loglevel = new LogLevelTest();
        IPreprocessingModule regression = new RegressionVariablesTest(false);
        IPreprocessingModule outliers = TramoMonitors.buildOutliers();

        Rsa2() {
        }

        @Override
        public PreprocessingModel process(TsData originalTs, ModellingContext context) {
            context.description = new ModelDescription(originalTs, null);
            if (!this.check(context)) {
                return null;
            }
            context.automodelling = false;
            context.outliers = true;
            this.initContext(context);
            if (!context.description.updateMissing(new AverageInterpolator())) {
                return null;
            }
            this.loglevel.process(context);
            this.regression.process(context);
            this.outliers.process(context);
            IParametricMapping<SarimaModel> mapping = context.description.defaultMapping();
            TramoModelEstimator estimator = new TramoModelEstimator(mapping);
            estimator.setPrecision(1.0E-7);
            context.estimation = new ModelEstimation(context.description.buildRegArima(), context.description.getLikelihoodCorrection());
            context.estimation.compute(estimator, mapping.getDim());
            return context.current(true);
        }

        private void initContext(ModellingContext context) {
            context.description.setTransformation(DefaultTransformationType.Auto);
            context.description.setAirline(context.hasseas);
            TramoMonitors.addTradingDays(context.description, 2);
            TramoMonitors.addEaster(context.description);
        }

        private boolean check(ModellingContext context) {
            double[] y = context.description.getY();
            return y != null && y.length >= 3 * context.description.getFrequency();
        }
    }

    static class Rsa1
    extends AbstractTramoModule
    implements IPreprocessor {
        IPreprocessingModule loglevel = new LogLevelTest();
        IPreprocessingModule outliers = TramoMonitors.buildOutliers();

        Rsa1() {
        }

        @Override
        public PreprocessingModel process(TsData originalTs, ModellingContext context) {
            context.description = new ModelDescription(originalTs, null);
            context.automodelling = false;
            context.outliers = true;
            this.initContext(context);
            if (!context.description.updateMissing(new AverageInterpolator())) {
                return null;
            }
            this.loglevel.process(context);
            this.outliers.process(context);
            IParametricMapping<SarimaModel> mapping = context.description.defaultMapping();
            TramoModelEstimator estimator = new TramoModelEstimator(mapping);
            estimator.setPrecision(1.0E-7);
            context.estimation = new ModelEstimation(context.description.buildRegArima(), context.description.getLikelihoodCorrection());
            context.estimation.compute(estimator, mapping.getDim());
            return context.current(true);
        }

        private void initContext(ModellingContext context) {
            context.description.setTransformation(DefaultTransformationType.Auto);
            context.description.setAirline(context.hasseas);
        }
    }

    static class Rsa0
    extends AbstractTramoModule
    implements IPreprocessor {
        Rsa0() {
        }

        @Override
        public PreprocessingModel process(TsData originalTs, ModellingContext context) {
            context.description = new ModelDescription(originalTs, null);
            context.automodelling = false;
            context.outliers = false;
            this.initContext(context);
            if (!context.description.updateMissing(new AverageInterpolator())) {
                return null;
            }
            IParametricMapping<SarimaModel> mapping = context.description.defaultMapping();
            TramoModelEstimator estimator = new TramoModelEstimator(mapping);
            estimator.setPrecision(1.0E-7);
            context.estimation = new ModelEstimation(context.description.buildRegArima());
            context.estimation.compute(estimator, mapping.getDim());
            return context.current(true);
        }

        private void initContext(ModellingContext context) {
            context.description.setTransformation(DefaultTransformationType.Auto);
            context.description.setAirline(context.hasseas);
        }
    }
}

