/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.IArmaFilter;
import ec.tstoolkit.arima.estimation.MaLjungBoxFilter;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.polynomials.Polynomial;

public class ModifiedLjungBoxFilter
implements IArmaFilter {
    private int m_n;
    private int m_p;
    private int m_q;
    private Polynomial m_ar;
    private Polynomial m_ma;
    private double m_s;
    private MaLjungBoxFilter m_malb;
    private Matrix m_L;
    private Matrix m_C;

    @Override
    public ModifiedLjungBoxFilter exemplar() {
        return new ModifiedLjungBoxFilter();
    }

    @Override
    public void filter(IReadDataBlock rw, DataBlock wl) {
        DataBlock w;
        DataBlock z = w = new DataBlock(rw);
        if (this.m_p > 0) {
            z = new DataBlock(w.getLength() - this.m_p);
            DataBlock x = w.drop(this.m_p, 0);
            z.copy(x);
            for (int i = 1; i <= this.m_p; ++i) {
                x.move(-1);
                z.addAY(this.m_ar.get(i), x);
            }
        }
        if (this.m_malb != null) {
            this.m_malb.filter(z, wl.drop(this.m_p, 0));
        } else {
            wl.drop(this.m_p, 0).copy(z);
        }
        if (this.m_C != null) {
            for (int i = 0; i < this.m_p; ++i) {
                wl.set(i, w.get(i) - this.m_C.column(i).dot(wl.drop(this.m_p, 0)));
            }
        } else {
            wl.range(0, this.m_p).copy(w.range(0, this.m_p));
        }
        if (this.m_L != null) {
            LowerTriangularMatrix.rsolve(this.m_L, wl.range(0, this.m_p));
        }
    }

    @Override
    public double getLogDeterminant() {
        double s = this.m_s;
        if (this.m_malb != null) {
            s += this.m_malb.getLogDeterminant();
        }
        return s;
    }

    @Override
    public int initialize(IArimaModel arima, int n) {
        this.clear();
        this.m_ar = arima.getAR().getPolynomial().adjustDegree();
        this.m_ma = arima.getMA().getPolynomial().adjustDegree();
        this.m_n = n;
        this.m_p = this.m_ar.getDegree();
        this.m_q = this.m_ma.getDegree();
        if (this.m_q > 0) {
            this.m_malb = new MaLjungBoxFilter();
            this.m_malb.initialize(arima, n - this.m_p);
        }
        if (this.m_p > 0) {
            this.m_L = new Matrix(this.m_p, this.m_p);
            SubMatrix W = this.m_L.subMatrix();
            double[] cov = arima.getAutoCovarianceFunction().values(this.m_p);
            W.diagonal().set(cov[0]);
            for (int i = 1; i < this.m_p; ++i) {
                W.subDiagonal(i).set(cov[i]);
            }
            if (this.m_q > 0) {
                double[] psi = arima.getPsiWeights().getRationalFunction().coefficients(this.m_q);
                Matrix C = new Matrix(this.m_n - this.m_p, this.m_p);
                this.m_C = new Matrix(this.m_n + this.m_q - this.m_p, this.m_p);
                for (int c = 0; c < this.m_p; ++c) {
                    int imin;
                    DataBlock col = C.column(c);
                    for (int r = 0; r < this.m_q && (imin = this.m_p + r - c) <= this.m_q; ++r) {
                        double s = 0.0;
                        for (int i = imin; i <= this.m_q; ++i) {
                            s += this.m_ma.get(i) * psi[i - imin];
                        }
                        col.set(r, s);
                    }
                    if (this.m_malb == null) continue;
                    this.m_malb.filter(col, this.m_C.column(c));
                }
                for (int i = 0; i < this.m_p; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        double z = this.m_C.column(i).dot(this.m_C.column(j));
                        this.m_L.add(j, i, -z);
                    }
                }
            }
            SymmetricMatrix.fromUpper(this.m_L);
            SymmetricMatrix.lcholesky(this.m_L);
            this.m_s = 2.0 * this.m_L.diagonal().sumLog().value;
        }
        return n + this.m_q;
    }

    private void clear() {
        this.m_malb = null;
        this.m_s = 0.0;
        this.m_L = null;
        this.m_C = null;
    }
}

