/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.maths.matrices.Matrix;

class JHouseholder {
    private static final double m_eps = 1.0E-15;

    JHouseholder() {
    }

    public boolean triangularize(Matrix m, int ISsf2, int maxRow) {
        int nc;
        int nr = m.getRowsCount();
        int n = Math.min(nr, nc = m.getColumnsCount());
        if (n > maxRow) {
            n = maxRow;
        }
        if (n == nr) {
            --n;
        }
        double[] v = new double[nc];
        for (int r = 0; r < n; ++r) {
            double jsigma = 0.0;
            double sigma = 0.0;
            for (int c = r + 1; c < nc; ++c) {
                double tmp = m.get(r, c);
                jsigma = c < ISsf2 ? (jsigma += tmp * tmp) : (jsigma -= tmp * tmp);
                sigma += tmp * tmp;
                v[c] = tmp;
            }
            if (sigma <= 1.0E-15) continue;
            double d = m.get(r, r);
            double xJx = jsigma + d * d;
            if (xJx <= 0.0) {
                return false;
            }
            double jnrm = Math.sqrt(xJx);
            v[r] = d < 0.0 ? d - jnrm : -jsigma / (d + jnrm);
            m.set(r, r, jnrm);
            for (int c = r + 1; c < nc; ++c) {
                m.set(r, c, 0.0);
            }
            double beta = 2.0 / (jsigma + v[r] * v[r]);
            for (int k = r + 1; k < nr; ++k) {
                int c;
                double s = 0.0;
                for (c = r; c < nc; ++c) {
                    if (v[c] == 0.0) continue;
                    if (c < ISsf2) {
                        s += m.get(k, c) * v[c];
                        continue;
                    }
                    s -= m.get(k, c) * v[c];
                }
                s *= beta;
                for (c = r; c < nc; ++c) {
                    if (v[c] == 0.0) continue;
                    m.set(k, c, m.get(k, c) - s * v[c]);
                }
            }
        }
        return true;
    }
}

