/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.stats;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.dstats.Chi2;
import ec.tstoolkit.dstats.Normal;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.stats.RunsTestKind;
import ec.tstoolkit.stats.StatisticalTest;

public class TestofUpDownRuns
extends StatisticalTest {
    DescriptiveStatistics stats;
    private int m_r;
    private int[] m_nr;
    private RunsTestKind m_kind = RunsTestKind.Number;
    private double[] obs;

    private static double dfact(double x, int k) {
        for (int i = 2; i <= k; ++i) {
            if (x == 0.0) {
                return 0.0;
            }
            x /= (double)i;
        }
        return x;
    }

    private void calcRuns() {
        int n = this.obs.length;
        this.m_nr = new int[n - 1];
        this.m_r = 1;
        if (n < 2) {
            return;
        }
        boolean up = this.obs[1] >= this.obs[0];
        int curlength = 1;
        for (int i = 2; i < n; ++i) {
            boolean curup;
            boolean bl = curup = this.obs[i] >= this.obs[i - 1];
            if (up != curup) {
                ++this.m_r;
                up = curup;
                int n2 = curlength - 1;
                this.m_nr[n2] = this.m_nr[n2] + 1;
                curlength = 1;
                continue;
            }
            ++curlength;
        }
        int n3 = curlength - 1;
        this.m_nr[n3] = this.m_nr[n3] + 1;
    }

    public RunsTestKind getKind() {
        return this.m_kind;
    }

    @Override
    public boolean isValid() {
        return this.stats != null && this.stats.getObservationsCount() > 10;
    }

    public int runsCount(int length) {
        return length <= 0 ? this.m_r : this.m_nr[length - 1];
    }

    public void setKind(RunsTestKind value) {
        if (this.m_kind != value) {
            this.m_kind = value;
            this.updateResults();
        }
    }

    private void test() {
        this.obs = this.stats.observations();
        this.calcRuns();
        this.updateResults();
    }

    public void test(DescriptiveStatistics stats) {
        this.stats = stats;
        this.test();
    }

    public void test(IReadDataBlock data) {
        this.stats = new DescriptiveStatistics(data);
        this.test();
    }

    private void testLength() {
        int n = this.obs.length;
        double x = 0.0;
        for (int i = 1; i < n; ++i) {
            double ei = 0.0;
            if (i != n - 1) {
                ei = 2 * (n * (i * i + 3 * i + 1) - (i * i * i + 3 * i * i - i - 4));
                ei = TestofUpDownRuns.dfact(ei, i + 3);
            } else {
                ei = TestofUpDownRuns.dfact(2.0, n);
            }
            double oi = this.m_nr[i - 1];
            if (oi == 0.0) {
                x += ei;
                continue;
            }
            if (ei != 0.0) {
                x += (oi - ei) / ei * (oi - ei);
                continue;
            }
            x += 999999.0;
        }
        Chi2 dist = new Chi2();
        dist.setDegreesofFreedom(n - 1);
        this.m_dist = dist;
        this.m_val = x;
        this.m_type = TestType.Upper;
        this.m_asympt = true;
    }

    private void testNumber() {
        double n = this.obs.length;
        double E = (2.0 * n - 1.0) / 3.0;
        double V = (16.0 * n - 29.0) / 90.0;
        Normal dist = new Normal();
        this.m_dist = dist;
        this.m_val = ((double)this.m_r - E) / Math.sqrt(V);
        this.m_type = TestType.TwoSided;
        this.m_asympt = true;
    }

    private void updateResults() {
        if (this.m_kind == RunsTestKind.Number) {
            this.testNumber();
        } else {
            this.testLength();
        }
    }
}

