/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.modelling.arima.IModelEstimator;
import ec.tstoolkit.modelling.arima.IOutliersDetectionModule;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.tramo.TramoModelEstimator;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;

public class ModelEstimator
implements IModelEstimator {
    private IOutliersDetectionModule outliers_;
    private double eps_ = 1.0E-7;

    @Override
    public boolean estimate(ModellingContext context) {
        context.description.setOutliers(null);
        if (this.outliers_ != null) {
            this.outliers_.process(context);
        }
        return this.calc(context);
    }

    private boolean simplify(ModellingContext context) {
        double t;
        double s;
        double v;
        double cval = 1.0;
        SarimaModel m = context.estimation.getRegArima().getArima();
        SarimaSpecification spec = m.getSpecification();
        if (spec.getParametersCount() <= 1) {
            return false;
        }
        IReadDataBlock pm = m.getParameters();
        int icpr = 0;
        int icps = 0;
        int icqr = 0;
        int icqs = 0;
        double bmin = 99999.0;
        int k = -1;
        int nnsig = 0;
        double tmin = cval;
        DataBlock diag = context.estimation.getParametersCovariance().diagonal();
        k += spec.getP();
        if (spec.getP() > 0) {
            v = Math.abs(pm.get(k));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin) {
                icpr = 1;
                bmin = t;
            }
        }
        k += spec.getBP();
        if (spec.getBP() > 0) {
            v = Math.abs(pm.get(k));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && bmin > t) {
                icps = 1;
                bmin = t;
                icpr = 0;
            }
        }
        k += spec.getQ();
        if (spec.getQ() > 0) {
            v = Math.abs(pm.get(k));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && bmin > t) {
                bmin = t;
                icqr = 1;
                icpr = 0;
                icps = 0;
            }
        }
        k += spec.getBQ();
        if (spec.getBQ() > 0) {
            v = Math.abs(pm.get(k));
            s = diag.get(k);
            if (s > 0.0 && (t = v / Math.sqrt(s)) < tmin && bmin > t) {
                icqs = 1;
                icpr = 0;
                icps = 0;
                icqr = 0;
            }
        }
        if ((nnsig = icpr + icps + icqr + icqs) == 0) {
            return false;
        }
        SarimaSpecification nspec = spec.clone();
        if (icpr > 0) {
            nspec.setP(nspec.getP() - 1);
        }
        if (icps > 0) {
            nspec.setBP(nspec.getBP() - 1);
        }
        if (icqr > 0) {
            nspec.setQ(nspec.getQ() - 1);
        }
        if (icqs > 0) {
            nspec.setBQ(nspec.getBQ() - 1);
        }
        context.description.setSpecification(nspec);
        context.estimation = null;
        return true;
    }

    private boolean calc(ModellingContext context) {
        IParametricMapping<SarimaModel> mapping = context.description.defaultMapping();
        ModelDescription model = context.description;
        context.estimation = new ModelEstimation(model.buildRegArima(), model.getLikelihoodCorrection());
        int ndim = mapping.getDim();
        TramoModelEstimator monitor = new TramoModelEstimator(mapping);
        monitor.setPrecision(this.eps_);
        if (context.estimation.compute(monitor, ndim)) {
            context.estimation.updateParametersCovariance(monitor.getParametersCovariance());
            if (ndim > 0) {
                context.information.subSet("optimization").set("score", monitor.getScore());
            }
            return true;
        }
        return false;
    }

    public IOutliersDetectionModule getOutliersDetectionModule() {
        return this.outliers_;
    }

    public void setOutliersDetectionModule(IOutliersDetectionModule outliers_) {
        this.outliers_ = outliers_;
    }

    public double getPrecision() {
        return this.eps_;
    }

    public void setPrecision(double eps) {
        this.eps_ = eps;
    }
}

