/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.ElementaryTransformations;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.ArrayState;
import ec.tstoolkit.ssf.IArrayFilteringResults;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;

public class ArrayFilter {
    private ISsf m_ssf;
    private Matrix m_X;
    private Matrix m_Res;
    private int m_r;
    private int m_rdim;
    private ArrayState m_state;

    public void setSsf(ISsf value) {
        this.m_ssf = value;
        this.initSsf();
    }

    public boolean process(ISsfData data, IArrayFilteringResults rslts) {
        if (rslts != null) {
            rslts.prepare(this.m_ssf, data);
        }
        int pos = 0;
        do {
            if (!this.m_ssf.isTransitionResidualTimeInvariant()) {
                this.getModelInfo(pos);
            }
            this.predict(pos, data);
            this.preArray(pos);
            if (!this.triangularize()) {
                return false;
            }
            this.updateState(pos);
            if (rslts == null) continue;
            rslts.save(pos, this.m_state);
        } while (pos++ < data.getCount());
        return true;
    }

    private boolean triangularize() {
        try {
            int r = this.m_X.getRowsCount();
            int c = this.m_X.getColumnsCount();
            SubMatrix L = this.m_X.subMatrix();
            do {
                ElementaryTransformations.rowGivens(L);
                L = L.extract(1, r, 1, c);
                --r;
                --c;
            } while (!L.isEmpty());
            return true;
        }
        catch (BaseException err) {
            return false;
        }
    }

    private void initSsf() {
        this.m_r = this.m_ssf.getStateDim();
        this.m_rdim = this.m_ssf.getTransitionResDim();
        int nc = 1 + this.m_r + this.m_rdim;
        this.m_X = new Matrix(this.m_r + 1, nc);
        this.m_Res = new Matrix(this.m_r, this.m_rdim);
        Matrix p0 = new Matrix(this.m_r, this.m_r);
        this.m_ssf.Pf0(p0.subMatrix());
        SymmetricMatrix.lcholesky(p0, 0.0);
        SubMatrix V = this.m_X.subMatrix(1, this.m_r + 1, 1, this.m_r + 1);
        V.copy(p0.subMatrix());
        if (this.m_ssf.isTransitionResidualTimeInvariant()) {
            this.getModelInfo(0);
        }
        this.m_state = new ArrayState(V, true);
    }

    private void preArray(int pos) {
        int r1 = this.m_r + 1;
        DataBlock X = this.m_X.row(0).range(1, r1);
        X.set(0.0);
        this.m_X.column(0).set(0.0);
        SubMatrix Y = this.m_X.subMatrix(1, r1, 1, r1);
        this.m_ssf.ZM(pos, Y, X);
        DataBlockIterator lcols = Y.columns();
        DataBlock lcol = lcols.getData();
        do {
            this.m_ssf.TX(pos, lcol);
        } while (lcols.next());
        SubMatrix Z = this.m_X.subMatrix(1, r1, r1, r1 + this.m_rdim);
        Z.copy(this.m_Res.subMatrix());
    }

    private void getModelInfo(int pos) {
        int rcount = this.m_ssf.getTransitionResCount();
        Matrix Q = new Matrix(this.m_rdim, this.m_rdim);
        this.m_ssf.Q(pos, Q.subMatrix());
        SymmetricMatrix.lcholesky(Q, 1.0E-9);
        Matrix W = new Matrix(rcount, this.m_rdim);
        this.m_ssf.W(pos, W.subMatrix());
        if (!this.m_ssf.hasR()) {
            this.m_Res.subMatrix().product(W.subMatrix(), Q.subMatrix());
        } else {
            int[] idx = new int[rcount];
            this.m_ssf.R(0, SubArrayOfInt.create(idx));
            int j = this.m_r - rcount;
            this.m_Res.subMatrix(j, this.m_r, 0, this.m_rdim).product(W.subMatrix(), Q.subMatrix());
            for (int i = 0; i < idx.length && idx[i] != j + i; ++i) {
                this.m_Res.row(idx[i]).copy(this.m_Res.row(j + i));
            }
        }
    }

    private void updateState(int pos) {
        double r;
        this.m_state.K.copy(this.m_X.column(0).drop(1, 0));
        this.m_state.r = r = this.m_X.get(0, 0);
        this.m_ssf.TX(pos, this.m_state.A);
        if (!this.m_state.isMissing()) {
            this.m_state.A.addAY(this.m_state.e / r, this.m_state.K);
        }
    }

    private void predict(int pos, ISsfData data) {
        double y;
        this.m_state.e = data.hasData() ? (Double.isNaN(y = data.get(pos)) ? Double.NaN : y - this.m_ssf.ZX(pos, this.m_state.A)) : 0.0;
    }
}

