/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.x11.X11Exception;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

public final class X11Context {
    private DecompositionMode mode;
    private TsDomain edomain;
    private boolean[] validDecomposition;
    private final int nfcasts;
    private final int nbcasts;

    @Deprecated
    public X11Context(DecompositionMode mode, int nfcasts) {
        this.mode = mode;
        this.nfcasts = nfcasts;
        this.nbcasts = 0;
    }

    public X11Context(DecompositionMode mode, int nbcasts, int nfcasts) {
        this.mode = mode;
        this.nfcasts = nfcasts;
        this.nbcasts = nbcasts;
    }

    public TsDomain getEstimationDomain() {
        return this.edomain;
    }

    public boolean[] getValidDecomposition() {
        return this.validDecomposition;
    }

    public int getForecastHorizon() {
        if (this.nfcasts >= 0) {
            return this.nfcasts;
        }
        int freq = this.edomain.getFrequency().intValue();
        return -this.nfcasts * freq;
    }

    public int getBackcastHorizon() {
        if (this.nbcasts >= 0) {
            return this.nbcasts;
        }
        int freq = this.edomain.getFrequency().intValue();
        return -this.nbcasts * freq;
    }

    public int getFrequency() {
        return this.edomain.getFrequency().intValue();
    }

    public double getMean() {
        return this.mode == DecompositionMode.Multiplicative || this.mode == DecompositionMode.PseudoAdditive ? 1.0 : 0.0;
    }

    public DecompositionMode getMode() {
        return this.mode;
    }

    public final boolean isMultiplicative() {
        return this.mode == DecompositionMode.Multiplicative;
    }

    public final boolean isPseudoAdditive() {
        return this.mode == DecompositionMode.PseudoAdditive;
    }

    public final boolean isLogAdditive() {
        return this.mode == DecompositionMode.LogAdditive;
    }

    public final TsData op(TsData l, TsData r) {
        if (this.mode != DecompositionMode.Multiplicative && this.mode != DecompositionMode.PseudoAdditive) {
            return TsData.subtract(l, r);
        }
        return TsData.divide(l, r);
    }

    public final TsData invOp(TsData l, TsData r) {
        if (this.mode != DecompositionMode.Multiplicative && this.mode != DecompositionMode.PseudoAdditive) {
            return TsData.add(l, r);
        }
        return TsData.multiply(l, r);
    }

    public final TsData pseudoOp(TsData y, TsData t, TsData s) {
        double cur;
        int i;
        TsData sa = new TsData(y.getDomain());
        int beg = t.getStart().minus(y.getStart());
        int end = t.getLength() + beg;
        for (i = 0; i < beg; ++i) {
            cur = s.get(i);
            if (cur == 0.0) {
                throw new X11Exception("Unexpected 0 in peudo-additive");
            }
            sa.set(i, y.get(i) / cur);
        }
        for (i = beg; i < end; ++i) {
            sa.set(i, y.get(i) - t.get(i - beg) * (s.get(i) - 1.0));
        }
        for (i = end; i < sa.getLength(); ++i) {
            cur = s.get(i);
            if (cur == 0.0) {
                throw new X11Exception("Unexpected 0 in peudo-additive");
            }
            sa.set(i, y.get(i) / cur);
        }
        return sa;
    }

    public void check(TsData s) {
        int freq;
        this.edomain = s.getDomain();
        if (this.mode == DecompositionMode.PseudoAdditive) {
            this.validDecomposition = new boolean[s.getLength()];
            for (int i = 0; i < this.validDecomposition.length; ++i) {
                this.validDecomposition[i] = s.get(i) > 0.0;
            }
        } else {
            this.validDecomposition = null;
        }
        if ((freq = s.getFrequency().intValue()) != 4 && freq != 12 && freq != 2) {
            throw new X11Exception("Invalid frequency");
        }
        if (s.getLength() < 3 * freq) {
            throw new X11Exception("Not enough observations");
        }
        if (s.hasMissingValues()) {
            throw new X11Exception("Missing values are not allowed");
        }
        if (this.mode != DecompositionMode.Additive && this.mode != DecompositionMode.PseudoAdditive) {
            double[] vals = s.internalStorage();
            for (int i = 0; i < vals.length; ++i) {
                if (!(vals[i] <= 0.0)) continue;
                throw new X11Exception("Multiplicative decomposition of non positive series");
            }
        }
    }

    public void setMode(DecompositionMode mode) {
        this.mode = mode;
    }
}

