/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special.mixedfrequencies;

import ec.benchmarking.Cumulator;
import ec.benchmarking.ssf.SsfDisaggregation;
import ec.satoolkit.DecompositionMode;
import ec.satoolkit.DefaultSeriesDecomposition;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.ssf.DiffuseFilteringResults;
import ec.tstoolkit.ssf.DiffuseSquareRootInitializer;
import ec.tstoolkit.ssf.Filter;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.Smoother;
import ec.tstoolkit.ssf.SmoothingResults;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.ssf.ucarima.SsfUcarima;
import ec.tstoolkit.timeseries.DataType;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.ucarima.ModelDecomposer;
import ec.tstoolkit.ucarima.SeasonalSelector;
import ec.tstoolkit.ucarima.TrendCycleSelector;
import ec.tstoolkit.ucarima.UcarimaModel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class MixedFrequenciesModelDecomposition
implements IProcResults {
    public static final String SEASONALITY = "seasonality";
    private UcarimaModel ucm_;
    private DefaultSeriesDecomposition decomposition_;
    private static double EPS = 0.001;
    private double ur_ = 1.0;
    private TsDomain domain_;
    private SsfData y_;
    private int c_;
    private boolean mul;
    private boolean mean;
    private static final InformationMapping<MixedFrequenciesModelDecomposition> MAPPING = new InformationMapping<MixedFrequenciesModelDecomposition>(MixedFrequenciesModelDecomposition.class);

    public void setUr(double ur) {
        this.ur_ = ur;
    }

    public double getUr() {
        return this.ur_;
    }

    public boolean decompose(TsData hdata, TsData ldata, SarimaModel arima, boolean mean, DataType type, boolean mul) {
        this.clear();
        this.mul = mul;
        this.mean = mean;
        if (!this.calcDomain(hdata, ldata)) {
            return false;
        }
        SarimaModel clone = arima.clone();
        this.ucm_ = this.doCanonicalDecomposition(clone, mean, this.ur_);
        if (this.ucm_ == null) {
            return false;
        }
        this.buildSsfY(hdata, ldata, type);
        return this.calcEstimates();
    }

    public DefaultSeriesDecomposition getDecomposition() {
        return this.decomposition_;
    }

    public UcarimaModel getUcarimaModel() {
        return this.ucm_;
    }

    public boolean isMultiplicative() {
        return this.mul;
    }

    private void clear() {
        this.domain_ = null;
        this.ucm_ = null;
        this.decomposition_ = null;
        this.y_ = null;
        this.c_ = 0;
    }

    private boolean calcDomain(TsData hdata, TsData ldata) {
        TsFrequency freq = hdata.getFrequency();
        TsDomain hdom = hdata.getDomain();
        TsDomain ldom = ldata.getDomain();
        this.domain_ = hdom.union(ldom.changeFrequency(freq, false));
        this.c_ = freq.ratio(ldom.getFrequency());
        return !this.domain_.isEmpty();
    }

    private void buildSsfY(TsData hdata, TsData ldata, DataType type) {
        TsFrequency freq = hdata.getFrequency();
        TsData s = hdata.fittoDomain(this.domain_.extend(0, freq.intValue()));
        DataBlock y = new DataBlock(this.mul ? s.log() : s);
        if (type == DataType.Flow) {
            Cumulator cumul = new Cumulator(this.c_);
            cumul.transform(y);
        }
        int j = this.domain_.search(ldata.getStart().lastPeriod(hdata.getFrequency()));
        if (this.mul) {
            double cl = Math.log(this.c_);
            int i = 0;
            while (i < ldata.getLength()) {
                double cur = Math.log(ldata.get(i));
                if (type == DataType.Flow) {
                    y.set(j, (double)this.c_ * (cur - cl));
                } else {
                    y.set(j, cur);
                }
                ++i;
                j += this.c_;
            }
        } else {
            int i = 0;
            while (i < ldata.getLength()) {
                y.set(j, ldata.get(i));
                ++i;
                j += this.c_;
            }
        }
        this.y_ = new SsfData(y, null);
    }

    private UcarimaModel doCanonicalDecomposition(SarimaModel arima, boolean mean, double ur) {
        if (ur == 1.0) {
            this.fixMaUnitRoots(arima, EPS);
        } else {
            this.checkModel(arima, ur);
        }
        ModelDecomposer decomposer = new ModelDecomposer();
        decomposer.add(new TrendCycleSelector());
        decomposer.add(new SeasonalSelector(arima.getFrequency()));
        UcarimaModel ucm = decomposer.decompose(arima);
        ucm.setVarianceMax(-1);
        if (mean) {
            UcarimaModel tmp = new UcarimaModel();
            ArimaModel tm = ucm.getComponent(0);
            BackFilter urb = BackFilter.D1;
            tm = tm.isNull() ? new ArimaModel(null, urb, urb, 0.0) : new ArimaModel(tm.getStationaryAR(), tm.getNonStationaryAR().times(urb), tm.getMA().times(urb), tm.getInnovationVariance());
            tmp.addComponent(tm);
            for (int i = 1; i < ucm.getComponentsCount(); ++i) {
                tmp.addComponent(ucm.getComponent(i));
            }
            ucm = tmp;
        }
        if (ucm.isValid()) {
            ucm.compact(2, 2);
            return ucm;
        }
        return null;
    }

    private boolean fixMaUnitRoots(SarimaModel arima, double eps) {
        boolean changed;
        block10: {
            double ur;
            SarimaSpecification spec;
            block8: {
                double th;
                block9: {
                    spec = arima.getSpecification();
                    changed = false;
                    ur = 1.0 - eps;
                    if (spec.getBQ() > 0) {
                        double sur = Math.pow(ur, arima.getFrequency());
                        double bth = arima.btheta(1);
                        if (bth < -sur) {
                            changed = true;
                            arima.setBTheta(1, -1.0);
                        } else if (bth > sur) {
                            changed = true;
                            arima.setBTheta(1, 1.0);
                        }
                    }
                    if (spec.getQ() != 1) break block8;
                    th = arima.theta(1);
                    if (!(th < -ur)) break block9;
                    changed = true;
                    arima.setTheta(1, -1.0);
                    break block10;
                }
                if (!(th > ur)) break block10;
                changed = true;
                arima.setBTheta(1, 1.0);
                break block10;
            }
            if (spec.getQ() > 1) {
                int i;
                Polynomial q = arima.getRegularMA();
                Complex[] roots = q.roots();
                boolean qchanged = false;
                for (i = 0; i < roots.length; ++i) {
                    double l = roots[i].abs();
                    if (!(l < ur)) continue;
                    qchanged = true;
                    roots[i] = roots[i].div(l);
                }
                if (qchanged) {
                    q = Polynomial.fromComplexRoots(roots);
                    for (i = 1; i <= spec.getQ(); ++i) {
                        arima.setTheta(i, q.get(i) / q.get(0));
                    }
                }
            }
        }
        return changed;
    }

    private boolean checkModel(SarimaModel arima, double ur) {
        boolean changed;
        block10: {
            SarimaSpecification spec;
            block8: {
                double th;
                block9: {
                    spec = arima.getSpecification();
                    changed = false;
                    if (spec.getBQ() > 0) {
                        double sur = Math.pow(ur, arima.getFrequency());
                        double bth = arima.btheta(1);
                        if (bth < -sur) {
                            changed = true;
                            arima.setBTheta(1, -sur);
                        } else if (bth > sur) {
                            changed = true;
                            arima.setBTheta(1, sur);
                        }
                    }
                    if (spec.getQ() != 1) break block8;
                    th = arima.theta(1);
                    if (!(th < -ur)) break block9;
                    changed = true;
                    arima.setTheta(1, -ur);
                    break block10;
                }
                if (!(th > ur)) break block10;
                changed = true;
                arima.setBTheta(1, ur);
                break block10;
            }
            if (spec.getQ() > 1) {
                int i;
                Polynomial q = arima.getRegularMA();
                Complex[] roots = q.roots();
                boolean qchanged = false;
                for (i = 0; i < roots.length; ++i) {
                    double l = roots[i].abs() * ur;
                    if (!(l < 1.0)) continue;
                    qchanged = true;
                    roots[i] = roots[i].times(1.0 / l);
                }
                if (qchanged) {
                    q = Polynomial.fromComplexRoots(roots);
                    for (i = 1; i <= spec.getQ(); ++i) {
                        arima.setTheta(i, q.get(i) / q.get(0));
                    }
                }
            }
        }
        return changed;
    }

    private boolean calcEstimates() {
        int k;
        int ipos;
        int spos;
        SsfUcarima ussf = new SsfUcarima(this.ucm_);
        SsfDisaggregation<SsfUcarima> disagg = new SsfDisaggregation<SsfUcarima>(this.c_, ussf);
        Smoother smoother = new Smoother();
        smoother.setCalcVar(true);
        smoother.setSsf(disagg);
        DiffuseFilteringResults frslts = new DiffuseFilteringResults(true);
        frslts.getVarianceFilter().setSavingP(true);
        frslts.getFilteredData().setSavingA(true);
        Filter<ISsf> filter = new Filter<ISsf>();
        filter.setInitializer(new DiffuseSquareRootInitializer());
        filter.setSsf(disagg);
        if (!filter.process(this.y_, frslts)) {
            return false;
        }
        SmoothingResults srslts = new SmoothingResults(true, true);
        if (!smoother.process(this.y_, frslts, srslts)) {
            return false;
        }
        double[] t = null;
        double[] s = null;
        double[] i = null;
        double[] et = null;
        double[] es = null;
        double[] ei = null;
        int tpos = ussf.cmpPos(0);
        DataBlock z = new DataBlock(disagg.getStateDim());
        DataBlock zsa = new DataBlock(disagg.getStateDim());
        if (tpos >= 0) {
            z.set(tpos + 1, 1.0);
            zsa.set(tpos + 1, 1.0);
            t = srslts.component(tpos + 1);
            et = srslts.componentStdev(tpos + 1);
        }
        if ((spos = ussf.cmpPos(1)) >= 0) {
            z.set(spos + 1, 1.0);
            s = srslts.component(spos + 1);
            es = srslts.componentStdev(spos + 1);
        }
        if ((ipos = ussf.cmpPos(2)) >= 0) {
            z.set(ipos + 1, 1.0);
            zsa.set(ipos + 1, 1.0);
            i = srslts.component(ipos + 1);
            ei = srslts.componentStdev(ipos + 1);
        }
        double[] sa = srslts.zcomponent(zsa);
        double[] esa = srslts.zvariance(zsa);
        double[] y = srslts.zcomponent(z);
        double[] ey = srslts.zvariance(z);
        for (k = 0; k < y.length; ++k) {
            ey[k] = ey[k] < 1.0E-9 ? 0.0 : Math.sqrt(ey[k]);
        }
        for (k = 0; k < y.length; ++k) {
            esa[k] = esa[k] < 1.0E-9 ? 0.0 : Math.sqrt(esa[k]);
        }
        this.decomposition_ = new DefaultSeriesDecomposition(DecompositionMode.Additive);
        int len = this.domain_.getLength();
        TsPeriod start = this.domain_.getStart();
        TsPeriod fstart = start.plus(len);
        if (t != null) {
            DataBlock T2 = new DataBlock(t);
            DataBlock ET = new DataBlock(et);
            this.decomposition_.add(new TsData(start, T2.range(0, len)), ComponentType.Trend);
            this.decomposition_.add(new TsData(start, ET.range(0, len)), ComponentType.Trend, ComponentInformation.Stdev);
            this.decomposition_.add(new TsData(fstart, T2.extract(len, -1)), ComponentType.Trend, ComponentInformation.Forecast);
            this.decomposition_.add(new TsData(fstart, ET.extract(len, -1)), ComponentType.Trend, ComponentInformation.StdevForecast);
        }
        if (s != null) {
            DataBlock S = new DataBlock(s);
            DataBlock ES = new DataBlock(es);
            this.decomposition_.add(new TsData(start, S.range(0, len)), ComponentType.Seasonal);
            this.decomposition_.add(new TsData(start, ES.range(0, len)), ComponentType.Seasonal, ComponentInformation.Stdev);
            this.decomposition_.add(new TsData(fstart, S.extract(len, -1)), ComponentType.Seasonal, ComponentInformation.Forecast);
            this.decomposition_.add(new TsData(fstart, ES.extract(len, -1)), ComponentType.Seasonal, ComponentInformation.StdevForecast);
        }
        if (i != null) {
            DataBlock I = new DataBlock(i);
            DataBlock EI = new DataBlock(ei);
            this.decomposition_.add(new TsData(start, I.range(0, len)), ComponentType.Irregular);
            this.decomposition_.add(new TsData(start, EI.range(0, len)), ComponentType.Irregular, ComponentInformation.Stdev);
            this.decomposition_.add(new TsData(fstart, I.extract(len, -1)), ComponentType.Irregular, ComponentInformation.Forecast);
            this.decomposition_.add(new TsData(fstart, EI.extract(len, -1)), ComponentType.Irregular, ComponentInformation.StdevForecast);
        }
        DataBlock Y = new DataBlock(y);
        DataBlock EY = new DataBlock(ey);
        DataBlock SA = new DataBlock(sa);
        DataBlock ESA = new DataBlock(esa);
        this.decomposition_.add(new TsData(start, Y.range(0, len)), ComponentType.Series);
        this.decomposition_.add(new TsData(start, EY.range(0, len)), ComponentType.Series, ComponentInformation.Stdev);
        this.decomposition_.add(new TsData(fstart, Y.extract(len, -1)), ComponentType.Series, ComponentInformation.Forecast);
        this.decomposition_.add(new TsData(fstart, EY.extract(len, -1)), ComponentType.Series, ComponentInformation.StdevForecast);
        this.decomposition_.add(new TsData(start, SA.range(0, len)), ComponentType.SeasonallyAdjusted);
        this.decomposition_.add(new TsData(start, ESA.range(0, len)), ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev);
        this.decomposition_.add(new TsData(fstart, SA.extract(len, -1)), ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
        this.decomposition_.add(new TsData(fstart, ESA.extract(len, -1)), ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast);
        return true;
    }

    public TsData getSeries(ComponentType componentType, ComponentInformation componentInformation) {
        TsData s = this.decomposition_.getSeries(componentType, componentInformation);
        return s != null && this.mul ? s.exp() : s;
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        MAPPING.fillDictionary(null, map, false);
        return map;
    }

    @Override
    public boolean contains(String id) {
        return MAPPING.contains(id);
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        return MAPPING.getData(this, id, tclass);
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.emptyList();
    }

    public static void fillDictionary(String prefix, Map<String, Class> map, boolean compact) {
        MAPPING.fillDictionary(prefix, map, compact);
    }

    public static InformationMapping<MixedFrequenciesModelDecomposition> getMapping() {
        return MAPPING;
    }

    public static <T> void setMapping(String name, Class<T> tclass, Function<MixedFrequenciesModelDecomposition, T> extractor) {
        MAPPING.set(name, tclass, extractor);
    }

    public static <T> void setTsData(String name, Function<MixedFrequenciesModelDecomposition, TsData> extractor) {
        MAPPING.set(name, extractor);
    }

    static {
        MAPPING.set("y_cmp", source -> {
            TsData s = source.decomposition_.getSeries(ComponentType.Series, ComponentInformation.Value);
            return s != null && source.mul ? s.exp() : s;
        });
        MAPPING.set("t_cmp", source -> {
            TsData s = source.decomposition_.getSeries(ComponentType.Trend, ComponentInformation.Value);
            return s != null && source.mul ? s.exp() : s;
        });
        MAPPING.set("sa_cmp", source -> {
            TsData s = source.decomposition_.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value);
            return s != null && source.mul ? s.exp() : s;
        });
        MAPPING.set("s_cmp", source -> {
            TsData s = source.decomposition_.getSeries(ComponentType.Seasonal, ComponentInformation.Value);
            return s != null && source.mul ? s.exp() : s;
        });
        MAPPING.set("i_cmp", source -> {
            TsData s = source.decomposition_.getSeries(ComponentType.Irregular, ComponentInformation.Value);
            return s != null && source.mul ? s.exp() : s;
        });
        MAPPING.set("y_cmp_f", source -> {
            TsData s = source.decomposition_.getSeries(ComponentType.Series, ComponentInformation.Forecast);
            return s != null && source.mul ? s.exp() : s;
        });
        MAPPING.set("t_cmp_f", source -> {
            TsData s = source.decomposition_.getSeries(ComponentType.Trend, ComponentInformation.Forecast);
            return s != null && source.mul ? s.exp() : s;
        });
        MAPPING.set("sa_cmp_f", source -> {
            TsData s = source.decomposition_.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
            return s != null && source.mul ? s.exp() : s;
        });
        MAPPING.set("s_cmp_f", source -> {
            TsData s = source.decomposition_.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast);
            return s != null && source.mul ? s.exp() : s;
        });
        MAPPING.set("i_cmp_f", source -> {
            TsData s = source.decomposition_.getSeries(ComponentType.Irregular, ComponentInformation.Forecast);
            return s != null && source.mul ? s.exp() : s;
        });
        MAPPING.set("y_lin", source -> source.decomposition_.getSeries(ComponentType.Series, ComponentInformation.Value));
        MAPPING.set("y_lin_e", source -> source.decomposition_.getSeries(ComponentType.Series, ComponentInformation.Stdev));
        MAPPING.set("t_lin", source -> source.decomposition_.getSeries(ComponentType.Trend, ComponentInformation.Value));
        MAPPING.set("t_lin_e", source -> source.decomposition_.getSeries(ComponentType.Trend, ComponentInformation.Stdev));
        MAPPING.set("sa_lin", source -> source.decomposition_.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value));
        MAPPING.set("sa_lin_e", source -> source.decomposition_.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev));
        MAPPING.set("s_lin", source -> source.decomposition_.getSeries(ComponentType.Seasonal, ComponentInformation.Value));
        MAPPING.set("s_lin_e", source -> source.decomposition_.getSeries(ComponentType.Seasonal, ComponentInformation.Stdev));
        MAPPING.set("i_lin", source -> source.decomposition_.getSeries(ComponentType.Irregular, ComponentInformation.Value));
        MAPPING.set("i_lin_e", source -> source.decomposition_.getSeries(ComponentType.Irregular, ComponentInformation.Stdev));
        MAPPING.set("y_lin_f", source -> source.decomposition_.getSeries(ComponentType.Series, ComponentInformation.Forecast));
        MAPPING.set("y_lin_ef", source -> source.decomposition_.getSeries(ComponentType.Series, ComponentInformation.StdevForecast));
        MAPPING.set("t_lin_f", source -> source.decomposition_.getSeries(ComponentType.Trend, ComponentInformation.Forecast));
        MAPPING.set("t_lin_ef", source -> source.decomposition_.getSeries(ComponentType.Trend, ComponentInformation.StdevForecast));
        MAPPING.set("sa_lin_f", source -> source.decomposition_.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast));
        MAPPING.set("sa_lin_ef", source -> source.decomposition_.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast));
        MAPPING.set("s_lin_f", source -> source.decomposition_.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast));
        MAPPING.set("s_lin_ef", source -> source.decomposition_.getSeries(ComponentType.Seasonal, ComponentInformation.StdevForecast));
        MAPPING.set("i_lin_f", source -> source.decomposition_.getSeries(ComponentType.Irregular, ComponentInformation.Forecast));
        MAPPING.set("i_lin_ef", source -> source.decomposition_.getSeries(ComponentType.Irregular, ComponentInformation.StdevForecast));
        MAPPING.set("si_lin", source -> {
            TsData i = source.decomposition_.getSeries(ComponentType.Irregular, ComponentInformation.Value);
            TsData s = source.decomposition_.getSeries(ComponentType.Seasonal, ComponentInformation.Value);
            TsData si = TsData.add(s, i);
            if (source.mul) {
                return si.exp();
            }
            return si;
        });
        MAPPING.set("mode", DecompositionMode.class, source -> source.mul ? DecompositionMode.Multiplicative : DecompositionMode.Additive);
        MAPPING.set(SEASONALITY, Boolean.class, source -> !source.ucm_.getComponent(1).isNull());
    }
}

