/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.multivariate;

import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.ssf.multivariate.IMSsfData;
import ec.tstoolkit.ssf.multivariate.M2uData;

public class MultivariateSsfData
implements IMSsfData {
    private final Matrix m_data;
    private double[] m_a0;

    public MultivariateSsfData(Matrix data, double[] a0) {
        this.m_data = data;
        if (a0 != null) {
            this.m_a0 = (double[])a0.clone();
        }
    }

    @Override
    public int count(int v) {
        return this.m_data.getColumnsCount();
    }

    @Override
    public double get(int v, int n) {
        return n >= this.m_data.getColumnsCount() ? Double.NaN : this.m_data.get(v, n);
    }

    @Override
    public double[] getInitialState() {
        return this.m_a0;
    }

    @Override
    public int getVarsCount() {
        return this.m_data.getRowsCount();
    }

    @Override
    public boolean hasData() {
        return true;
    }

    public boolean hasMissingValues() {
        double[] a = this.m_data.internalStorage();
        for (int i = 0; i < a.length; ++i) {
            if (!Double.isNaN(a[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMissing(int v, int pos) {
        return pos >= this.m_data.getColumnsCount() || Double.isNaN(this.m_data.get(v, pos));
    }

    @Override
    public int obsCount(int v) {
        int n = 0;
        for (int i = 0; i < this.m_data.getColumnsCount(); ++i) {
            if (Double.isNaN(this.m_data.get(v, i))) continue;
            ++n;
        }
        return n;
    }

    public M2uData UConvert() {
        return new M2uData(this.m_data, this.m_a0);
    }
}

