/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking;

import ec.benchmarking.Cumulator;
import ec.benchmarking.DisaggregationData;
import ec.benchmarking.DisaggregationType;
import ec.tstoolkit.data.AbsMeanNormalizer;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class DisaggregationModel
implements Cloneable {
    private TsFrequency defFreq_ = TsFrequency.Quarterly;
    private int nFcast_;
    private TsData y_;
    private TsVariableList regressors_ = new TsVariableList();
    private TsAggregationType aType_ = TsAggregationType.Sum;
    private DisaggregationType dType_ = DisaggregationType.Level;

    public DisaggregationModel() {
    }

    public DisaggregationModel(TsFrequency deffreq) {
        this.defFreq_ = deffreq;
    }

    public DisaggregationModel clone() {
        try {
            DisaggregationModel model = (DisaggregationModel)super.clone();
            if (this.y_ != null) {
                model.y_ = this.y_.clone();
            }
            if (this.regressors_ != null) {
                model.regressors_ = this.regressors_.clone();
            }
            return model;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public DisaggregationData data(TsDomain domain, boolean rescale) {
        DisaggregationData data = this.startDataPreparation(domain);
        if (data == null) {
            return null;
        }
        if (!this.prepare(data, rescale)) {
            return null;
        }
        return data;
    }

    public TsAggregationType getAggregationType() {
        return this.aType_;
    }

    public int getDefaultForecastsCount() {
        return this.nFcast_;
    }

    public TsFrequency getDefaultFrequency() {
        return this.defFreq_;
    }

    public DisaggregationType getDisaggregationType() {
        return this.dType_;
    }

    public TsVariableList getX() {
        return this.regressors_;
    }

    public TsData getY() {
        return this.y_;
    }

    private boolean prepare(DisaggregationData data, boolean rescale) {
        TsDomain lDom = this.y_.getDomain();
        int lN = lDom.getLength();
        int hN = data.hDom.getLength();
        if (lN == 0 || hN == 0) {
            return false;
        }
        TsPeriod lStart = lDom.getStart();
        TsPeriod hStart = data.hDom.getStart();
        TsPeriod hEnd = data.hDom.getLast();
        TsPeriod cStart = new TsPeriod(lStart.getFrequency(), hStart);
        TsPeriod cEnd = new TsPeriod(lStart.getFrequency(), hEnd);
        if (this.aType_ != TsAggregationType.Last && hStart.getPosition() % data.FrequencyRatio != 0) {
            cStart.move(1);
        }
        if (this.aType_ != TsAggregationType.First && hEnd.getPosition() % data.FrequencyRatio != data.FrequencyRatio - 1) {
            cEnd.move(-1);
        }
        int cn = cEnd.minus(cStart) + 1;
        TsDomain yDom = lDom.intersection(new TsDomain(cStart, cn));
        cStart = yDom.getStart();
        int ny = yDom.getLength();
        if (ny == 0) {
            return false;
        }
        int pos = this.aType_ == TsAggregationType.Last ? data.FrequencyRatio - 1 : 0;
        hStart.set(cStart.getYear(), cStart.getPosition() * data.FrequencyRatio + pos);
        int nxe = ny * data.FrequencyRatio;
        if (this.aType_ == TsAggregationType.Last || this.aType_ == TsAggregationType.First) {
            nxe -= data.FrequencyRatio - 1;
        }
        data.hEDom = new TsDomain(hStart, nxe);
        this.prepareY(data, yDom);
        if (!this.regressors_.isEmpty()) {
            this.prepareX(data, rescale);
        } else {
            data.scale(rescale ? new AbsMeanNormalizer() : null);
        }
        return true;
    }

    private void prepareX(DisaggregationData data, boolean rescale) {
        data.hX = this.regressors_.all().matrix(data.hDom);
        if (rescale) {
            data.scale(new AbsMeanNormalizer());
        } else {
            data.scale(null);
        }
        if (this.aType_ != TsAggregationType.Average && this.aType_ != TsAggregationType.Sum) {
            data.hEX = data.hX;
        } else {
            data.hEX = data.hX.clone();
            Cumulator cumul = new Cumulator(data.FrequencyRatio);
            DataBlockIterator cX = data.hEX.columns();
            DataBlock col = cX.getData();
            do {
                cumul.transform(col);
            } while (cX.next());
        }
    }

    private void prepareY(DisaggregationData data, TsDomain yDom) {
        double[] s = this.y_.internalStorage();
        if (this.dType_ != DisaggregationType.Level) {
            for (int i = 0; i < s.length; ++i) {
                s[i] = Math.log(s[i]);
            }
            if (this.aType_ == TsAggregationType.Sum) {
                double lc = (double)data.FrequencyRatio * Math.log(data.FrequencyRatio);
                for (int i = 0; i < s.length; ++i) {
                    s[i] = s[i] * (double)data.FrequencyRatio - lc;
                }
            }
        }
        int ny = yDom.getLength();
        int pos = this.aType_ == TsAggregationType.First || this.aType_ == TsAggregationType.Last ? 0 : data.FrequencyRatio - 1;
        double[] y = new double[data.hDom.getLength()];
        for (int i = 0; i < y.length; ++i) {
            y[i] = Double.NaN;
        }
        int xstart = data.hEDom.getStart().minus(data.hDom.getStart());
        int ystart = yDom.getStart().minus(this.y_.getStart());
        int i = 0;
        int j = xstart + pos;
        int k = ystart;
        while (i < ny) {
            y[j] = s[k];
            ++i;
            j += data.FrequencyRatio;
            ++k;
        }
        data.hY = y;
    }

    public void setAggregationType(TsAggregationType value) {
        this.aType_ = value;
    }

    public void setDefaultForecastCount(int value) {
        this.nFcast_ = value;
    }

    public void setDisaggregationType(DisaggregationType value) {
        this.dType_ = value;
    }

    public void setX(TsVariableList value) {
        this.regressors_ = value.clone();
    }

    public void setY(TsData value) {
        this.y_ = value.clone();
    }

    private DisaggregationData startDataPreparation(TsDomain domain) {
        if (this.y_ == null) {
            return null;
        }
        TsDomain lDom = this.y_.getDomain();
        TsDomain hDom = this.regressors_.getDomain();
        int lFreq = lDom.getFrequency().intValue();
        int hFreq = this.regressors_.getFrequency().intValue();
        if (hFreq == 0) {
            hFreq = this.defFreq_.intValue();
        }
        if (lFreq >= hFreq || hFreq % lFreq != 0) {
            return null;
        }
        int c = hFreq / lFreq;
        if (hDom == null && domain == null) {
            TsPeriod lstart = lDom.get(0);
            TsPeriod hstart = new TsPeriod(TsFrequency.valueOf(hFreq));
            hstart.set(lstart.getYear(), lstart.getPosition() * c);
            hDom = new TsDomain(hstart, this.nFcast_ + lDom.getLength() * c);
        } else if (hDom != null && domain != null) {
            if (hDom.getFrequency() != domain.getFrequency()) {
                return null;
            }
            if ((hDom = hDom.intersection(domain)) == null || hDom.getLength() == 0) {
                return null;
            }
        } else if (hDom == null) {
            hDom = domain;
        }
        DisaggregationData data = new DisaggregationData();
        data.FrequencyRatio = c;
        data.hDom = hDom;
        data.lowFrequency = lFreq;
        data.highFrequency = hFreq;
        return data;
    }
}

