/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IDataNormalizer;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.InPlaceNormalizer;

public class ThousandNormalizer
implements IDataNormalizer,
InPlaceNormalizer {
    private static final double D_MAX = 1000.0;
    private static final double D_MIN = 0.001;
    private final double dmax_;
    private final double dmin_;
    private int k;
    private double factor;
    private double[] y;

    private void clear() {
        this.factor = 1.0;
        this.k = 0;
        this.y = null;
    }

    public ThousandNormalizer() {
        this.dmin_ = 0.001;
        this.dmax_ = 1000.0;
    }

    public ThousandNormalizer(double dmin, double dmax) {
        this.dmin_ = dmin;
        this.dmax_ = dmax;
    }

    @Override
    public boolean process(IReadDataBlock data) {
        double ycur;
        double ymax;
        int i;
        this.clear();
        this.y = new double[data.getLength()];
        data.copyTo(this.y, 0);
        for (i = 0; i < this.y.length && !Double.isFinite(this.y[i]); ++i) {
        }
        if (i == this.y.length) {
            return false;
        }
        double ymin = ymax = Math.abs(this.y[i++]);
        while (i < this.y.length) {
            if (Double.isFinite(this.y[i])) {
                ycur = Math.abs(this.y[i]);
                if (ycur < ymin) {
                    ymin = ycur;
                } else if (ycur > ymax) {
                    ymax = ycur;
                }
            }
            ++i;
        }
        this.k = 0;
        if (ymax < this.dmax_ && ymin > this.dmin_) {
            return false;
        }
        while (ymin > 1000.0) {
            --this.k;
            ymin /= 1000.0;
        }
        while (ymax < 0.1) {
            ++this.k;
            ymax *= 1000.0;
        }
        if (this.k != 0) {
            this.factor = 1.0;
            for (i = 0; i < this.k; ++i) {
                this.factor *= 1000.0;
            }
            for (i = this.k; i < 0; ++i) {
                this.factor /= 1000.0;
            }
            for (i = 0; i < this.y.length; ++i) {
                ycur = Math.abs(this.y[i]);
                if (Double.isNaN(ycur)) continue;
                this.y[i] = this.factor * ycur;
            }
        }
        return true;
    }

    @Override
    public double getFactor() {
        return this.factor;
    }

    @Override
    public double[] getNormalizedData() {
        return this.y;
    }

    public int getUnits() {
        return this.k;
    }

    public double getMax() {
        return this.dmax_;
    }

    public double getMin() {
        return this.dmin_;
    }

    @Override
    public double normalize(IDataBlock data) {
        double ymax;
        int n = data.getLength();
        int i = data.first(x -> Double.isFinite(x));
        if (i == n) {
            return 1.0;
        }
        double ymin = ymax = data.get(i++);
        while (i < n) {
            double ycur = data.get(i);
            if (Double.isFinite(ycur)) {
                if ((ycur = Math.abs(ycur)) < ymin) {
                    ymin = ycur;
                } else if (ycur > ymax) {
                    ymax = ycur;
                }
            }
            ++i;
        }
        int q = 0;
        if (ymax < this.dmax_ && ymin > this.dmin_) {
            return 1.0;
        }
        while (ymin < 1000.0) {
            ++q;
            ymin *= 1000.0;
        }
        while (ymax > 1000.0) {
            --q;
            ymax /= 1000.0;
        }
        if (q != 0) {
            double f = 1.0;
            for (i = 0; i < q; ++i) {
                f *= 1000.0;
            }
            for (i = q; i < 0; ++i) {
                f /= 1000.0;
            }
            double c = f;
            data.apply(x -> x * c);
            return c;
        }
        return 1.0;
    }
}

