/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.design.Internal;
import ec.tstoolkit.timeseries.simplets.ObsLists;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.utilities.ObjLongToIntFunction;

@Internal
public interface ObsList {
    public int size();

    public void sortByPeriod();

    public int getPeriodId(TsFrequency var1, int var2) throws IndexOutOfBoundsException;

    public double getValue(int var1) throws IndexOutOfBoundsException;

    default public double[] getValues() {
        double[] result = new double[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getValue(i);
        }
        return result;
    }

    public static LongObsList newLongObsList(boolean preSorted, ObjLongToIntFunction<TsFrequency> tsPeriodIdFunc) {
        return preSorted ? new ObsLists.PreSortedLongObsList(tsPeriodIdFunc, 32) : new ObsLists.SortableLongObsList(tsPeriodIdFunc);
    }

    @Internal
    public static interface LongObsList
    extends ObsList {
        public void clear();

        public void add(long var1, double var3);
    }
}

