/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v21;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Message;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.parser.v20.GenericDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LocalizedText;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CompactDataParser {
    private static final String sourceClass = CompactDataParser.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    private static final String DATASET = "DataSet";
    private static final String ACTION = "action";
    private static final String VALID_FROM = "validFromDate";
    private static final String VALID_TO = "validToDate";
    private static final String SERIES = "Series";
    private static final String OBS = "Obs";
    private static final String FOOTER = "Footer";
    private static final String MESSAGE = "Message";
    private static final String CODE = "code";
    private static final String SEVERITY = "severity";
    private static final String TEXT = "Text";

    public static DataParsingResult parse(InputStreamReader inputStreamReader, DataFlowStructure dataFlowStructure, String string, boolean bl) throws XMLStreamException, UnsupportedEncodingException, SdmxException {
        logger.entering(sourceClass, "parse");
        ArrayList<PortableTimeSeries> arrayList = new ArrayList<PortableTimeSeries>();
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        BufferedReader bufferedReader = GenericDataParser.skipBOM(inputStreamReader);
        XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(bufferedReader);
        DataParsingResult dataParsingResult = new DataParsingResult();
        PortableTimeSeries portableTimeSeries = null;
        String string2 = null;
        Object object = null;
        Object object2 = null;
        while (xMLEventReader.hasNext()) {
            Iterator<Attribute> iterator;
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            logger.finest(xMLEvent2.toString());
            if (xMLEvent2.isStartElement()) {
                Object object3;
                String string3;
                Object object4;
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart() == DATASET) {
                    logger.finer("Got new dataset");
                    iterator = xMLEvent.getAttributes();
                    while (iterator.hasNext()) {
                        object4 = iterator.next();
                        string3 = object4.getName().getLocalPart().toString();
                        object3 = object4.getValue();
                        if (string3.equalsIgnoreCase(ACTION)) {
                            logger.finer("action: " + (String)object3);
                            string2 = object3;
                            continue;
                        }
                        if (string3.equalsIgnoreCase(VALID_FROM)) {
                            logger.finer("VALID_FROM: " + (String)object3);
                            object = object3;
                            continue;
                        }
                        if (!string3.equalsIgnoreCase(VALID_TO)) continue;
                        logger.finer("VALID_TO: " + (String)object3);
                        object2 = object3;
                    }
                }
                if (xMLEvent.getName().getLocalPart() == SERIES) {
                    logger.finer("Got new time series");
                    portableTimeSeries = new PortableTimeSeries();
                    portableTimeSeries.setDataflow(string);
                    iterator = xMLEvent.getAttributes();
                    CompactDataParser.setMetadata(portableTimeSeries, dataFlowStructure, iterator, string2, object, object2);
                }
                if (xMLEvent.getName().getLocalPart() == FOOTER) {
                    CompactDataParser.setFooter(xMLEventReader, dataParsingResult);
                }
                if (xMLEvent.getName().getLocalPart().equals(OBS) && bl) {
                    xMLEvent2 = xMLEventReader.nextEvent();
                    logger.finest(xMLEvent2.toString());
                    iterator = xMLEvent.getAttributes();
                    object4 = null;
                    string3 = null;
                    object3 = new Hashtable();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        String string4 = attribute.getName().toString();
                        if (string4.equals(dataFlowStructure.getTimeDimension())) {
                            object4 = attribute.getValue();
                            continue;
                        }
                        if (string4.equals("TIME") && object4 == null) {
                            object4 = attribute.getValue();
                            continue;
                        }
                        if (string4.equals(dataFlowStructure.getMeasure())) {
                            string3 = attribute.getValue();
                            continue;
                        }
                        ((Hashtable)object3).put(string4, attribute.getValue());
                    }
                    portableTimeSeries.addObservation(string3, (String)object4, (Hashtable<String, String>)object3);
                    continue;
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != SERIES) continue;
            logger.finer("Adding time series " + portableTimeSeries);
            iterator = portableTimeSeries.getTimeSlots();
            int n = iterator.size();
            if (n > 1 && ((String)iterator.get(n - 1)).compareToIgnoreCase((String)iterator.get(0)) < 0) {
                portableTimeSeries.reverse();
            }
            arrayList.add(portableTimeSeries);
        }
        dataParsingResult.setData(arrayList);
        logger.exiting(sourceClass, "parse");
        return dataParsingResult;
    }

    private static void setMetadata(PortableTimeSeries portableTimeSeries, DataFlowStructure dataFlowStructure, Iterator<Attribute> iterator, String string, String string2, String string3) {
        logger.entering(sourceClass, "setMetadata");
        if (string != null) {
            portableTimeSeries.addAttribute("action=" + string);
        }
        if (string2 != null) {
            portableTimeSeries.addAttribute("validFromDate=" + string2);
        }
        if (string3 != null) {
            portableTimeSeries.addAttribute("validToDate=" + string3);
        }
        String[] stringArray = new String[dataFlowStructure.getDimensions().size()];
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            String string4 = attribute.getName().toString();
            String string5 = attribute.getValue();
            if (dataFlowStructure.isDimension(string4)) {
                stringArray[dataFlowStructure.getDimensionPosition((String)string4) - 1] = string4 + "=" + string5;
                if (string4.equalsIgnoreCase("FREQ") || string4.equalsIgnoreCase("FREQUENCY")) {
                    portableTimeSeries.setFrequency(string5);
                }
            } else {
                portableTimeSeries.addAttribute(string4 + "=" + string5);
            }
            portableTimeSeries.setDimensions(Arrays.asList(stringArray));
        }
        logger.exiting(sourceClass, "setMetadata");
    }

    private static void setFooter(XMLEventReader xMLEventReader, DataParsingResult dataParsingResult) throws XMLStreamException {
        logger.entering(sourceClass, "setFooter");
        Message message = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            logger.finest(xMLEvent2.toString());
            if (xMLEvent2.isStartElement()) {
                Object object;
                Object object2;
                Object object3;
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart() == MESSAGE) {
                    message = new Message();
                    object3 = xMLEvent.getAttributes();
                    while (object3.hasNext()) {
                        object2 = object3.next();
                        object = object2.getName().toString();
                        String string = object2.getValue();
                        if (((String)object).equalsIgnoreCase(CODE)) {
                            message.setCode(string);
                            continue;
                        }
                        if (!((String)object).equalsIgnoreCase(SEVERITY)) continue;
                        message.setSeverity(string);
                    }
                }
                if (xMLEvent.getName().getLocalPart() == TEXT) {
                    object3 = null;
                    object2 = new LocalizedText(Configuration.getLang());
                    ((LocalizedText)object2).setText((StartElement)xMLEvent, xMLEventReader);
                    object3 = ((LocalizedText)object2).getText();
                    message.addText((String)object3);
                    try {
                        object = new URL((String)object3);
                        message.setUrl((String)object3);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != MESSAGE) continue;
            logger.finer("Adding footer message");
            dataParsingResult.setMessage(message);
            break;
        }
        logger.exiting(sourceClass, "setFooter");
    }
}

