% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset02}
\alias{dataset02}
\title{dataset02}
\format{A list with 8 elements:
\itemize{
\item{\code{NL}}{ Ratings array [1:2, 1:5, 1:114, 1], of false positives, FPs}
\item{\code{LL}}{ Ratings array [1:2, 1:5, 1:45, 1], of true positives, TPs}
\item{\code{lesionNum}}{ array [1:45], number of lesions per diseased case, all set to 1}
\item{\code{lesionID}}{ array [1:45, 1], labels of lesions on diseased cases, all set to 1}
\item{\code{lesionWeight}}{ array [1:45, 1], weights (or clinical importances) of lesions, all set to 1}
\item{\code{dataType}}{ "ROC", the data type}
\item{\code{modalityID}}{ [1:2] "0" "1", modality labels}
\item{\code{readerID}}{ [1:5] "0" "1" "2" ..., reader labels}
}}
\usage{
dataset02
}
\description{
This is referred to in the book as the "VD" dataset. It consists of 114 cases, 
45 of which are diseased, interpreted in two modalities
("0" = single spin echo MRI, "1" = cine-MRI) by five radiologists using the ROC paradigm. 
Each diseased cases had an aortic dissection; the ROC paradigm grenerates one 
rating per case.  Often referred to in the ROC literature as the 
Van Dyke dataset, which, along the the Franken dataset, has been widely used to illustrate
advances in ROC methodology. The example below displays the ROC plot for 
the first modality and first reader.
}
\examples{
str(dataset02)
PlotEmpiricalOperatingCharacteristics(dataset = dataset02)$Plot



}
\references{
Van Dyke CW, et al. Cine MRI in the diagnosis of thoracic 
aortic dissection. 79th RSNA Meetings. 1993.
}
\keyword{datasets}
