/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.impl;

import com.hp.hpl.jena.iri.impl.AbsIRIImpl;
import com.hp.hpl.jena.iri.impl.IRIFactoryImpl;
import com.hp.hpl.jena.iri.impl.Parser;
import com.hp.hpl.jena.iri.impl.SchemeSpecificPart;

public class ResolvedRelativeIRI
extends AbsIRIImpl {
    private final AbsIRIImpl base;
    private final AbsIRIImpl rel;
    int useBaseUntilThisComponent;
    long pathErrors;
    final String iri;

    public ResolvedRelativeIRI(AbsIRIImpl base, AbsIRIImpl rel) {
        this.base = base;
        this.rel = rel;
        this.transformReferences();
        this.iri = this.createIRIString();
        this.allErrors = 0L;
        int i = 0;
        while (i < Parser.fields.length) {
            this.allErrors |= this.errors(Parser.fields[i]);
            ++i;
        }
    }

    private void transformReferences() {
        this.pathErrors = 0L;
        this.path = null;
        if (!(!this.rel.has(2) || this.getFactory().getSameSchemaRelativeReferences() && this.base.has(2) && this.rel.getScheme().equalsIgnoreCase(this.base.getScheme()))) {
            this.useBaseUntilThisComponent = 2;
        } else if (this.rel.has(4)) {
            this.useBaseUntilThisComponent = 4;
        } else {
            String rPath = this.rel.getRawPath();
            if (rPath.equals("")) {
                this.useBaseUntilThisComponent = this.rel.has(13) ? 13 : 15;
            } else if (rPath.charAt(0) == '/') {
                this.useBaseUntilThisComponent = 11;
            } else {
                this.useBaseUntilThisComponent = 11;
                this.path = this.mergePathsRemoveDots();
                this.pathErrors = this.base.errors(11);
            }
        }
        if (this.useBaseUntilThisComponent <= 11) {
            this.pathErrors |= this.rel.errors(11);
            if (this.path == null) {
                this.path = this.rel.pathRemoveDots();
            }
        } else {
            this.pathErrors |= this.base.errors(11);
            this.path = this.base.getRawPath();
        }
    }

    private String createIRIString() {
        StringBuffer iriBuf = new StringBuffer();
        if (this.has(2)) {
            iriBuf.append(this.getScheme());
            iriBuf.append(':');
        }
        if (this.has(4)) {
            iriBuf.append("//");
            iriBuf.append(this.getRawAuthority());
        }
        iriBuf.append(this.getRawPath());
        if (this.has(13)) {
            iriBuf.append('?');
            iriBuf.append(this.getRawQuery());
        }
        if (this.has(15)) {
            iriBuf.append('#');
            iriBuf.append(this.getRawFragment());
        }
        return iriBuf.toString();
    }

    private String mergePathsRemoveDots() {
        if (this.base.has(4) && this.base.getRawPath().equals("")) {
            return this.mergePathsRemoveDots("/");
        }
        return this.mergePathsRemoveDots(this.base.getRawPath());
    }

    /*
     * Unable to fully structure code
     */
    private String mergePathsRemoveDots(String basePath) {
        block4: {
            slash = basePath.lastIndexOf(47);
            output = new StringBuffer();
            if (slash != -1) {
                output.append(basePath.substring(0, slash + 1));
            }
            if (!this.base.dotsOK() || !this.rel.dotsOK()) break block4;
            relPath = this.rel.getRawPath();
            if (!relPath.startsWith("./")) ** GOTO lbl12
            return String.valueOf(basePath) + relPath.substring(2);
lbl-1000:
            // 1 sources

            {
                relPath = relPath.substring(3);
                ResolvedRelativeIRI.removeLastSeqment2(output);
lbl12:
                // 2 sources

                ** while (relPath.startsWith((String)"../"))
            }
lbl13:
            // 1 sources

            if (relPath.equals("..")) {
                relPath = "";
                ResolvedRelativeIRI.removeLastSeqment2(output);
            }
            if (relPath.equals(".")) {
                relPath = "";
            }
            output.append(relPath);
            return output.toString();
        }
        output.append(this.rel.getRawPath());
        return ResolvedRelativeIRI.removeDotSegments(output.toString());
    }

    /*
     * Unable to fully structure code
     */
    private static void removeLastSeqment2(StringBuffer output) {
        ix = output.length() - 1;
        if (ix != -1) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            if (output.charAt(--ix) != '/') continue;
            ++ix;
            break;
lbl7:
            // 2 sources

            ** while (ix > 0)
        }
lbl8:
        // 2 sources

        output.setLength(ix);
    }

    protected IRIFactoryImpl getFactory() {
        return this.base.getFactory();
    }

    long errors(int field) {
        return field == 11 ? this.pathErrors : (field < this.useBaseUntilThisComponent ? this.base.errors(field) : this.rel.errors(field));
    }

    boolean has(int field) {
        return field == 11 || !(field < this.useBaseUntilThisComponent ? !this.base.has(field) : !this.rel.has(field));
    }

    String get(int field) {
        return field == 11 ? this.path : (field < this.useBaseUntilThisComponent ? this.base.get(field) : this.rel.get(field));
    }

    public String toString() {
        return this.iri;
    }

    String pathRemoveDots() {
        return this.useBaseUntilThisComponent > 11 ? this.base.pathRemoveDots() : this.path;
    }

    boolean dotsOK() {
        return true;
    }

    SchemeSpecificPart getSchemeSpec() {
        if (this.useBaseUntilThisComponent == 2) {
            return this.rel.getSchemeSpec();
        }
        return this.base.getSchemeSpec();
    }
}

