% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KorAPQuery.R
\docType{class}
\name{KorAPQuery-class}
\alias{KorAPQuery-class}
\alias{KorAPQuery}
\alias{initialize,KorAPQuery-method}
\alias{fetchNext,KorAPQuery-method}
\alias{fetchNext}
\alias{fetchAll,KorAPQuery-method}
\alias{fetchAll}
\alias{fetchRest,KorAPQuery-method}
\alias{fetchRest}
\alias{frequencyQuery,KorAPConnection-method}
\alias{frequencyQuery}
\alias{format.KorAPQuery}
\alias{show,KorAPQuery-method}
\alias{collocationScoreQuery,KorAPConnection-method}
\alias{collocationScoreQuery}
\title{Class KorAPQuery}
\usage{
\S4method{initialize}{KorAPQuery}(
  .Object,
  korapConnection = NULL,
  request = NULL,
  vc = "",
  totalResults = 0,
  nextStartIndex = 0,
  fields = c("corpusSigle", "textSigle", "pubDate", "pubPlace", "availability",
    "textClass", "snippet"),
  requestUrl = "",
  webUIRequestUrl = "",
  apiResponse = NULL,
  hasMoreMatches = FALSE,
  collectedMatches = NULL
)

\S4method{fetchNext}{KorAPQuery}(
  kqo,
  offset = kqo@nextStartIndex,
  maxFetch = maxResultsPerPage,
  verbose = kqo@korapConnection@verbose
)

\S4method{fetchAll}{KorAPQuery}(kqo, verbose = kqo@korapConnection@verbose)

\S4method{fetchRest}{KorAPQuery}(kqo, verbose = kqo@korapConnection@verbose)

\S4method{frequencyQuery}{KorAPConnection}(
  kco,
  query,
  vc = "",
  conf.level = 0.95,
  as.alternatives = FALSE,
  ...
)

\method{format}{KorAPQuery}(x, ...)

\S4method{show}{KorAPQuery}(object)

\S4method{collocationScoreQuery}{KorAPConnection}(
  kco,
  node,
  collocate,
  vc = "",
  lemmatizeNodeQuery = FALSE,
  lemmatizeCollocateQuery = FALSE,
  leftContextSize = 5,
  rightContextSize = 5,
  scoreFunctions = defaultAssociationScoreFunctions(),
  smoothingConstant = 0.5
)
}
\arguments{
\item{.Object}{…}

\item{korapConnection}{KorAPConnection object}

\item{request}{query part of the request URL}

\item{vc}{string describing the virtual corpus in which the query should be performed. An empty string (default) means the whole corpus, as far as it is license-wise accessible.}

\item{totalResults}{number of hits the query has yielded}

\item{nextStartIndex}{at what index to start the next fetch of query results}

\item{fields}{what data / metadata fields should be collected}

\item{requestUrl}{complete URL of the API request}

\item{webUIRequestUrl}{URL of a web frontend request corresponding to the API request}

\item{apiResponse}{data-frame representation of the JSON response of the API request}

\item{hasMoreMatches}{logical that signals if more query results can be fetched}

\item{collectedMatches}{matches already fetched from the KorAP-API-server}

\item{kqo}{object obtained from \code{\link{corpusQuery}}}

\item{offset}{start offset for query results to fetch}

\item{maxFetch}{maximum number of query results to fetch}

\item{verbose}{print progress information if true}

\item{kco}{\code{\link{KorAPConnection}} object (obtained e.g. from \code{new("KorAPConnection")}}

\item{query}{string that contains the corpus query. The query language depends on the \code{ql} parameter. Either \code{query} must be provided or \code{KorAPUrl}.}

\item{conf.level}{confidence level of the returned confidence interval (passed through \code{\link{ci}}  to \code{\link{prop.test}}).}

\item{as.alternatives}{LOGICAL that specifies if the query terms should be treated as alternatives. If \code{as.alternatives} is TRUE, the sum over all query hits, instead of the respective vc token sizes is used as total for the calculation of relative frequencies.}

\item{...}{further arguments passed to or from other methods}

\item{x}{KorAPQuery object}

\item{object}{KorAPQuery object}

\item{node}{target word}

\item{collocate}{collocate of target word}

\item{lemmatizeNodeQuery}{logical, set to TRUE if node query should be lemmatized, i.e. x -> [tt/l=x]}

\item{lemmatizeCollocateQuery}{logical, set to TRUE if collocate query should be lemmatized, i.e. x -> [tt/l=x]}

\item{leftContextSize}{size of the left context window}

\item{rightContextSize}{size of the right context window}

\item{scoreFunctions}{named list of score functions of the form function(O1, O2, O, N, E, window_size), see e.g. \link{pmi}}

\item{smoothingConstant}{smoothing constant will be added to all observed values}
}
\value{
The \code{kqo} input object with updated slots \code{collectedMatches}, \code{apiResponse}, \code{nextStartIndex}, \code{hasMoreMatches}

tibble with query KorAP web request URL, all observed values and association scores
}
\description{
This class provides methods to perform different kinds of queries on the KorAP API server.
\code{KorAPQuery} objects, which are typically created by the \code{\link{corpusQuery}} method,
represent the current state of a query to a KorAP server.

\bold{\code{fetchNext}} fetches the next bunch of results of a KorAP query.

\bold{\code{fetchAll}} fetches allf results of a KorAP query.

\bold{\code{frequencyQuery}} combines \code{\link{corpusQuery}}, \code{\link{corpusStats}} and
\code{\link{ci}} to compute a table with the relative frequencies and
confidence intervals of one ore multiple search terms across one or multiple
virtual corpora.

\bold{\code{collocationScoreQuery}} computes various collocation association scores
based on \code{\link{frequencyQuery}}s for a target word and a collocate.
}
\examples{
\donttest{q <- new("KorAPConnection") \%>\% corpusQuery("Ameisenplage") \%>\% fetchNext()
q@collectedMatches
}

\donttest{
q <- new("KorAPConnection") \%>\% corpusQuery("Ameisenplage") \%>\% fetchAll()
q@collectedMatches
}

\donttest{
q <- new("KorAPConnection") \%>\% corpusQuery("Ameisenplage") \%>\% fetchRest()
q@collectedMatches
}

\donttest{
new("KorAPConnection", verbose = TRUE) \%>\%
  frequencyQuery(c("Mücke", "Schnake"), paste0("pubDate in ", 2000:2003))
}

\donttest{
new("KorAPConnection", verbose = TRUE) \%>\%
  collocationScoreQuery("Grund", "triftiger")
}

\donttest{
new("KorAPConnection", verbose = TRUE) \%>\%
collocationScoreQuery("Grund", c("guter", "triftiger"),
   scoreFunctions = list(localMI = function(O1, O2, O, N, E, window_size) { O * log2(O/E) }) )
}

\donttest{
library(highcharter)
library(tidyr)
new("KorAPConnection", verbose = TRUE) \%>\%
  collocationScoreQuery("Team", "agil", vc = paste("pubDate in", c(2014:2018)),
                        lemmatizeNodeQuery = TRUE, lemmatizeCollocateQuery = TRUE) \%>\%
                         pivot_longer(14:last_col(), names_to = "measure", values_to = "score") \%>\%
  hchart(type="spline", hcaes(label, score, group=measure)) \%>\%
  hc_add_onclick_korap_search()
}

}
\references{
\url{https://ids-pub.bsz-bw.de/frontdoor/index/index/docId/9026}
}
