% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_MC_TL_TUN.R
\encoding{UTF-8}
\name{run_MC_TL_TUN}
\alias{run_MC_TL_TUN}
\title{Run Monte-Carlo Simulation for TL (tunnelling transitions)}
\usage{
run_MC_TL_TUN(
  s,
  E,
  rho,
  r_c = 0,
  times,
  b = 1,
  clusters = 10,
  N_e = 200,
  delta.r = 0.1,
  method = "par",
  output = "signal",
  ...
)
}
\arguments{
\item{s}{\link{list} (\strong{required}): The effective frequency factor for the tunnelling process (s^-1)}

\item{E}{\link{numeric} (\strong{required}): Thermal activation energy of the trap (eV)}

\item{rho}{\link{numeric} (\strong{required}): The dimensionless density of recombination centres
(defined as \eqn{\rho}' in Huntley 2006)}

\item{r_c}{\link{numeric} (\emph{with default}): Critical distance (>0) that is to be used if
the sample has been thermally and/or optically pretreated. This parameter expresses the fact
that electron-hole pairs within a critical radius \code{r_c} have already recombined.}

\item{times}{\link{numeric} (\strong{required}): The sequence of temperature steps within the simulation (s).
The default heating rate is set to 1 K/s. The final temperature is \code{max(times) * b}}

\item{b}{\link{numeric} (\emph{with default}): the heating rate in K/s}

\item{clusters}{\link{numeric} (\emph{with default}): The number of created clusters for the MC runs. The input can be the output of \link{create_ClusterSystem}. In that case \code{n_filled} indicate absolute numbers of a system.}

\item{N_e}{\link{numeric} (\emph{with default}): The total number of electron traps available (dimensionless). Can be a vector of \code{length(clusters)}, shorter values are recycled.}

\item{delta.r}{\link{numeric} (\emph{with default}): The increments of the dimensionless distance r'}

\item{method}{\link{character} (\emph{with default}): Sequential \code{'seq'} or parallel \code{'par'}processing. In
the parallel mode the function tries to run the simulation on multiple CPU cores (if available) with
a positive effect on the computation time.}

\item{output}{\link{character} (\emph{with default}): output is either the \code{'signal'} (the default)
or \code{'remaining_e'} (the remaining charges/electrons in the trap)}

\item{\dots}{further arguments, such as \code{cores} to control the number of used CPU cores or \code{verbose} to silence the terminal}
}
\value{
This function returns an object of class \code{RLumCarlo_Model_Output} which
is a \link{list} consisting of an \link{array} with dimension length(times) x length(r) x clusters
and a \link{numeric} time vector.
}
\description{
Runs a Monte-Carlo (MC) simulation of thermoluminescence (TL) caused by
tunnelling (TUN) transitions. Tunnelling refers to quantum mechanical
tunnelling processes from the excited state of the trap into a recombination centre.
The heating rate in this function is assumed to be 1 K/s.
}
\details{
\strong{The model}

\deqn{
I_{TUN}(r',t) = -dn/dt = (s * exp(-E/(k_{B} * T))) * exp(-(\rho')^{-1/3} * r') * n(r',t)
}

Where in the function: \cr
s := frequency for the tunnelling process (s^-1) \cr
E := thermal activation energy (eV) \cr
\eqn{k_{B}} := Boltzmann constant (8.617 x 10^-5 eV K^-1)\cr
T := temperature (°C)\cr
r' := the dimensionless tunnelling radius \cr
\eqn{\rho}' := \verb{rho'}, the dimensionless density of recombination centres (see Huntley (2006)) \cr
t := time (s) \cr
n := the instantaneous number of electrons at distance r'
}
\section{Function version}{
 0.1.0
}

\examples{
## the short example
run_MC_TL_TUN(
 s = 1e12,
 E = 0.9,
 rho = 1,
 r_c = 0.1,
 times = 80:120,
 b = 1,
 clusters = 50,
 method = 'seq',
 delta.r = 1e-1) \%>\%
plot_RLumCarlo()

\dontrun{
## the long (meaningful example)
results <- run_MC_TL_TUN(
 s = 1e12,
 E = 0.9,
 rho = 0.01,
 r_c = 0.1,
 times = 80:220,
 clusters = 100,
 method = 'par',
 delta.r = 1e-1)

## plot
plot_RLumCarlo(results)
}

} 

\section{How to cite}{
Friedrich, J., Kreutzer, S., 2022. run_MC_TL_TUN(): Run Monte-Carlo Simulation for TL (tunnelling transitions). Function version 0.1.0. In: Friedrich, J., Kreutzer, S., Pagonis, V., Schmidt, C., 2022. RLumCarlo: Monte-Carlo Methods for Simulating Luminescence Phenomena. R package version 0.1.8. https://CRAN.R-project.org/package=RLumCarlo
}

\references{
Huntley, D.J., 2006. An explanation of the power-law decay of luminescence.
Journal of Physics: Condensed Matter, 18(4), 1359.

Pagonis, V. and Kulp, C., 2017. Monte Carlo simulations of tunneling
phenomena and nearest neighbor hopping mechanism in feldspars.
Journal of Luminescence 181, 114–120. \doi{10.1016/j.jlumin.2016.09.014}

Pagonis, V., Friedrich, J., Discher, M., Müller-Kirschbaum, A., Schlosser, V., Kreutzer, S.,
Chen, R. and Schmidt, C., 2019. Excited state luminescence signals from a random
distribution of defects: A new Monte Carlo simulation approach for feldspar.
Journal of Luminescence 207, 266–272. \doi{10.1016/j.jlumin.2018.11.024}

\strong{Further reading}

Aitken, M.J., 1985. Thermoluminescence dating. Academic Press.

Jain, M., Guralnik, B., Andersen, M.T., 2012. Stimulated luminescence emission from
localized recombination in randomly distributed defects.
Journal of Physics: Condensed Matter 24, 385402.
}
\author{
Johannes Friedrich, University of Bayreuth (Germany), Sebastian Kreutzer,
Geography & Earth Sciences, Aberystwyth University (United Kingdom)
}
\keyword{data}
\keyword{models}
