
NULL

#' 
#' Interpolates monthly data to daily data using \code{\link{spline}}  and preserving monthly mean values
#' 
#' @param nday number of days on which the daily data is requested, e.g. number of days in one year 
#' @param val matrix containing monthly mean data
#' @param origin  date corresponding to the first row of the returned matrix
#' @param first_row row corresponding the first day of time interval where montlhy mean conservation is applied
#' @param last_row corresponding the last day of time interval where montlhy mean conservation is applied
#' 
#' @export 
#'  
#' @return a matrix with interpolated daily data 
#' 
#' @seealso \code{\link{spline}},\code{\link{splineInterpolateMonthlytoDailyforSeveralYears}}
#' 
#' @author Emanuele Cordano, Emanuele Eccel

splineInterpolateMonthlytoDaily <-
function(nday=365,val=as.matrix(cbind(1*(0.5:11.5)*nday/12,2*(0.5:11.5)*nday/12)),origin="1961-1-1",first_row=1,last_row=nday) {
	
	nmonth=nrow(val)
	
	
	frac <- as.double(nday/nmonth)
	x <- ((1:nmonth)-0.5)*frac
	x_out <- 1:nday
	
	i_out <- as.integer((x_out-1)/frac)+1
	
	
	
	
	output <- array(NA,c(nday,ncol(val)))
	
	sval <- as.matrix(array(NA,c(nday,ncol(val))))
	

	
	
	for (i in 1:ncol(val)) {
		out <- spline(x=x,y=val[,i],xout=x_out)
		
		
		out1 <- as.vector(out$y) # insert monthds correctly!!!
		out2 <- out1
		
		months <- months((0.5:11.5)*365/12,abbreviate=TRUE)

		for (m in 1:length(months)) {
			
			i_months <- extractmonths(data=1:length(out2),when=months[m],origin=origin)

			

			out2[i_months[i_months %in% first_row:last_row]] <-  out1[i_months[i_months %in% first_row:last_row]]-mean(out1[i_months[i_months %in% first_row:last_row]])+val[m,i] 

	 	}	
#		for (m in 1:nmonth) {
			
#			out2[i_months] <-  out1[i_months]-mean(out1[i_months])+val[m,i] 
	
#		}
#		
		
		output[,i] <- out2
	}
	
	
	
	
	
	return(output)
	
}

