% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrometheeS4.R
\name{SensitivityAnalysis}
\alias{SensitivityAnalysis}
\alias{SensitivityAnalysis,RPrometheeArguments-method}
\title{SensitivityAnalysis}
\usage{
SensitivityAnalysis(RPrometheeArguments, method = "RPrometheeII")
}
\arguments{
\item{RPrometheeArguments}{An object with all RPromethee arguments. For
PROMETHEE IV, it's important that \code{parms} argument isn't compound of NA
values. See \code{\link{RPrometheeConstructor}} for more information.}

\item{method}{A character object used to choose how the SensitivityAnalysis is going to be calculated. The method can be \code{"RPrometheeII"} or \code{"RPrometheeIV"}. The standard is \code{"RPrometheeII"}}
}
\value{
\itemize{
  \item{Solution} {The solution resulting from linear programming problem.}
  \item{alternatives} {The alternatives names.}
  \item{criterias} {The criterias names.}
  \item{datMat} {The data used corresponding to criterias and alternatives.}
 }
}
\description{
Sensitivity Analysis is a method developed by Wolters & Mareschal (1995) to
  evaluate how \code{\link{RPrometheeII}} and \code{\link{RPrometheeIV}}
  results are sensitive to changes in weights of criterias. That is, how the
  solution to the decision problem can be affected by the distribution of
  criterias weights.
}
\examples{
## Create objects for each argument
data <- matrix(c(5.2, -3.5,
                 4.3, -1.2,
                 6.7, -2.0,
                 5.4, -5.0,
                 4.8,  0.0,
                 2.8, -3.4), byrow = TRUE, ncol = 2)

parms<-matrix(c(1.0, -2.3), byrow = TRUE, ncol = 1, nrow = 2)
vecWeights <- c(0.3, 0.7)
vecMaximiz <- c(FALSE, TRUE)
prefFunction <- c(0, 0)
constraintDir <- rep("<=", ncol(data))
bounds <- c(7,-1)
normalize <- FALSE
alternatives <- c("Alt 1", "Alt 2", "Alt 3")

## Create RPrometheeArguments object
PromObj <- RPrometheeConstructor(datMat = data, vecWeights = vecWeights,
vecMaximiz = vecMaximiz, prefFunction = prefFunction, parms = parms,
normalize = normalize, alternatives = alternatives, bounds = bounds,
constraintDir = constraintDir)

## Run RPrometheeV using standard method ("RPrometheeII")
(result <- SensitivityAnalysis(PromObj))

## Run RPrometheeV using RPrometheeIV
(result <- SensitivityAnalysis(PromObj, "RPrometheeIV"))

## Updating alternatives name using UpdateRPrometheeAlternatives
newAlternatives <- c("A", "B", "C", "D", "E", "F")
result <- UpdateRPrometheeAlternatives(result, newAlternatives)

## Updating any argument using UpdateRPrometheeArguments
newParms <- matrix(c(1.6, 4.2), byrow = TRUE, ncol = 1)
PromObj <- UpdateRPrometheeArguments(PromObj, "parms", newParms)
(result <- SensitivityAnalysis(PromObj))
}
\references{
\itemize{

      \item
      M. Behzadian et al. \cr
      \emph{PROMETHEE: A comprehensive literature review on methodologies and
       applications}\cr
       European Journal of Operational Research v. 200, p.198-215, 2010.\cr
      \url{https://www.sciencedirect.com/science/article/abs/pii/S0377221709000071}
      \item
      J. P. Brans, Ph. Vincke\cr
      \emph{A Preference Ranking Organisation Method: (The PROMETHEE Method
      for Multiple Criteria Decision-Making)}\cr
      Management science, v. 31, n. 6, p. 647-656, 1985.\cr
      \url{https://pdfs.semanticscholar.org/edd6/f5ae9c1bfb2fdd5c9a5d66e56bdb22770460.pdf}

      \item
      J. P. Brans, B. Mareschal \cr
      \emph{PROMETHEE methods. In: Figueria J, Greco S, Ehrgott M (eds)
      Multiple criteria decision analysis: state of the art surveys.}\cr
      Springer Science, Business Media Inc., Boston pp 163???195.\cr
      \url{http://www.springer.com/la/book/9780387230818}

      \item
      W.T.M. Wolters, B. Mareschal\cr
      \emph{Novel types of sensitivity analysis for additive MCDM
      ethods}.\cr
      European Journal of Operational Research, v. 81, p. 281-290, 1995.\cr
      \url{https://www.sciencedirect.com/science/article/abs/pii/0377221793E0343V}
   }
}
\seealso{
Other RPromethee methods: \code{\link{PrometheeIIIPlot}},
  \code{\link{PrometheeIIPlot}},
  \code{\link{PrometheeIPlot}},
  \code{\link{PrometheeIVPlot}},
  \code{\link{RPrometheeConstructor}},
  \code{\link{RPrometheeIII}}, \code{\link{RPrometheeII}},
  \code{\link{RPrometheeIVKernel}},
  \code{\link{RPrometheeIV}}, \code{\link{RPrometheeI}},
  \code{\link{RPrometheeV}},
  \code{\link{UpdateRPrometheeAlternatives}},
  \code{\link{UpdateRPrometheeArguments}},
  \code{\link{WalkingWeightsPlot}},
  \code{\link{plot,RPrometheeI-method}}
}
\author{
Pedro Henrique Melo Albuquerque, \email{pedroa@unb.br}

Gustavo Monteiro Pereira, \email{monteirogustavop@gmail.com}
}
\keyword{decision-analysis}
\keyword{decision-method}
\keyword{mcda}
\keyword{promethee}
