% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{imputedGLMnetwork}
\alias{imputedGLMnetwork}
\title{Multiple hot-deck imputation and network inference from RNA-seq data.}
\usage{
imputedGLMnetwork(X, Y, sigma, m = 50, lambdas = NULL, B = 20)
}
\arguments{
\item{X}{n x p numeric matrix containing RNA-seq expression with missing rows
(numeric matrix or data frame)}

\item{Y}{auxiliary dataset (n' x q numeric matrix or data frame)}

\item{sigma}{affinity threshold for donor pool}

\item{m}{number of replicates in multiple imputation (integer). Default to 50}

\item{lambdas}{a sequence of decreasing positive numbers to control the
regularization (numeric vector). Default to \code{NULL}}

\item{B}{number of iterations for stability selection. Default to 20}
}
\value{
S3 object of class \code{HDpath}: a list consisting of
\itemize{
  \item{\code{path}}{ a list of \code{m} data frames, each containing the
  adjacency matrix of the inferred network obtained from the corresonding
  imputed dataset. The regularization parameter is selected by StARS}
  \item{\code{efreq}}{ a numeric matrix of size p x p,  which indicates the
  number of times an edge has been predicted among the \code{m} inferred
  networks}
}
}
\description{
\code{imputedGLMnetwork} performs a multiple hot-deck imputation and infers a
network for each imputed dataset with a log-linear Poisson graphical model
(LLGM).
}
\details{
When input \code{lambdas} are null the default sequence of
\code{\link[glmnet]{glmnet}} for the first model (the one with the first
column of \code{count} as the target) is used. A common default sequence is
generated for all imputed datasets using this method.
}
\examples{
data(lung)
data(thyroid)
nobs <- nrow(lung)
miss_ind <- sample(1:nobs, round(0.2 * nobs), replace = FALSE)
lung[miss_ind, ] <- NA
lung <- na.omit(lung)
lambdas <- 4 * 10^(seq(0, -2, length = 10))
\dontrun{
lung_hdmi <- imputedGLMnetwork(lung, thyroid, sigma = 2, lambdas = lambdas,
                               m = 10, B = 5)
}

}
\references{
{Imbert, A., Valsesia, A., Le Gall, C., Armenise, C., Lefebvre,
G. Gourraud, P.A., Viguerie, N. and Villa-Vialaneix, N. (2018) Multiple
hot-deck imputation for network inference from RNA sequencing data.
\emph{Bioinformatics}. \doi{10.1093/bioinformatics/btx819}.}
}
\author{
{Alyssa Imbert, \email{alyssa.imbert@inra.fr}

Nathalie Villa-Vialaneix, \email{nathalie.villa-vialaneix@inra.fr}}
}
