\name{Q_constraint}
\alias{Q_constraint}
\title{Quadratic Constraints}
\usage{Q_constraint(Q, L, dir, rhs)
}
\description{Quadratic constraints are typically of the form
\eqn{\frac{1}{2}x^{\top}Qx + c^{\top}x \leq b}. \eqn{A} is a
(sparse) matrix of coefficients to the objective variables \eqn{x}
of the quadratic part and \eqn{c} is the vector of coefficients of
the linear part of a given constraint. \eqn{b} is called the right
hand side of the constraints.}
\value{an object of class \code{"Q_constraint"} which inherits
from \code{"constraint"}.}
\author{Stefan Theussl}
\arguments{\item{Q}{a list of (sparse) matrices representing the quadratic
part of each constraint.}
\item{L}{a numeric vector of length \eqn{n} (a single constraint)
or a matrix of dimension \eqn{n \times m}, where \eqn{n} is the
number of objective variables and \eqn{m} is the number of
constraints. Matrices can be of class
\code{"simple_triplet_matrix"} to allow a sparse representation of
constraints.}
\item{dir}{a character vector with the directions of the
constraints. Each element must be one of \code{"<"}, \code{"<="},
\code{">"}, \code{">="}, \code{"=="} or \code{"!="}.}
\item{rhs}{a numeric vector with the right hand side of the
constraints.}
}

