% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.GEV.R
\name{GEV}
\alias{GEV}
\title{GEV}
\description{
GEV distribution in OOP way. Based on AbstractDist
}
\details{
See AbstractDist for generic methods
}
\examples{
## Generate sample
loc   = 0
scale = 0.5
shape = -0.3
gev = ROOPSD::GEV$new( loc = loc , scale = scale , shape = shape )
X   = gev$rvs( n = 1000 )

## And fit parameters
gev$fit(X)

}
\section{Super class}{
\code{\link[ROOPSD:AbstractDist]{ROOPSD::AbstractDist}} -> \code{GEV}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{loc}}{[double] location of the GEV law}

\item{\code{scale}}{[double] scale of the GEV law}

\item{\code{shape}}{[double] shape of the GEV law}

\item{\code{params}}{[vector] params of the GEV law}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GEV-new}{\code{GEV$new()}}
\item \href{#method-GEV-qgradient}{\code{GEV$qgradient()}}
\item \href{#method-GEV-pgradient}{\code{GEV$pgradient()}}
\item \href{#method-GEV-clone}{\code{GEV$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="cdf"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-cdf'><code>ROOPSD::AbstractDist$cdf()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="density"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-density'><code>ROOPSD::AbstractDist$density()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="diagnostic"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-diagnostic'><code>ROOPSD::AbstractDist$diagnostic()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="fit"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-fit'><code>ROOPSD::AbstractDist$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="icdf"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-icdf'><code>ROOPSD::AbstractDist$icdf()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="isf"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-isf'><code>ROOPSD::AbstractDist$isf()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="logdensity"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-logdensity'><code>ROOPSD::AbstractDist$logdensity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="pdeltaCI"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-pdeltaCI'><code>ROOPSD::AbstractDist$pdeltaCI()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="qdeltaCI"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-qdeltaCI'><code>ROOPSD::AbstractDist$qdeltaCI()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="rvs"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-rvs'><code>ROOPSD::AbstractDist$rvs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="sf"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-sf'><code>ROOPSD::AbstractDist$sf()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GEV-new"></a>}}
\if{latex}{\out{\hypertarget{method-GEV-new}{}}}
\subsection{Method \code{new()}}{
Create a new GEV object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GEV$new(loc = 0, scale = 1, shape = -0.1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{loc}}{[double] location parameter}

\item{\code{scale}}{[double] scale parameter}

\item{\code{shape}}{[double] shape parameter}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `GEV` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GEV-qgradient"></a>}}
\if{latex}{\out{\hypertarget{method-GEV-qgradient}{}}}
\subsection{Method \code{qgradient()}}{
Gradient of the quantile function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GEV$qgradient(p, lower.tail = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities}

\item{\code{lower.tail}}{[bool] If CDF or SF.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] gradient
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GEV-pgradient"></a>}}
\if{latex}{\out{\hypertarget{method-GEV-pgradient}{}}}
\subsection{Method \code{pgradient()}}{
Gradient of the CDF function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GEV$pgradient(x, lower.tail = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{[vector] Quantiles}

\item{\code{lower.tail}}{[bool] If CDF or SF.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] gradient
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GEV-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GEV-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GEV$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
