% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous.R
\name{continuous.schmidt.decompose}
\alias{continuous.schmidt.decompose}
\title{Perform a continuous Schmidt decomposition}
\usage{
continuous.schmidt.decompose(bifunc, x1lo, x1hi, x2lo, x2hi, nbx1 = 100,
  nbx2 = 100, keep = min(10, nbx1, nbx2))
}
\arguments{
\item{bifunc}{bipartitite continuous wavefunction}

\item{x1lo}{lower limit of \code{x1}}

\item{x1hi}{upper limit of \code{x1}}

\item{x2lo}{lower limit of \code{x2}}

\item{x2hi}{upper limit of \code{x2}}

\item{nbx1}{number of discretized x1 (default: 100)}

\item{nbx2}{number of discretized x2 (default: 100)}

\item{keep}{number of Schmidt modes to keep (default: minimum of 10, \code{nbx1}, and \code{nbx2})}
}
\value{
Schmidt modes, including the eigenvalues, and the lambda interpolated function of the Schmidt modes
}
\description{
Perform a continuous Schmidt decomposition
}
\examples{
coupled.harm.fcn<- function(x1,x2) exp(-((0.5*(x1+x2))**2))*exp(-(x1-x2)**2)*sqrt(2./pi)
continuous.schmidt.decompose(coupled.harm.fcn, -10, 10, -10, 10)

}
