% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{get_usage}
\alias{get_usage}
\title{Get usage of a specific GIS function}
\usage{
get_usage(alg = NULL, qgis_env = set_env(), intern = FALSE)
}
\arguments{
\item{alg}{Name of the function whose parameters are being
searched for.}

\item{qgis_env}{Environment containing all the paths to run the QGIS API. For
more information, refer to \code{\link{set_env}}.}

\item{intern}{Logical which indicates whether to capture the output of the
command as an \code{R} character vector (see also
\code{\link[base]{system}}.}
}
\description{
\code{get_usage} lists all function parameters of a specific GIS
  function.
}
\details{
Function \code{get_usage} simply calls
  \code{processing.alghelp} using Python.
}
\examples{
\dontrun{
# find a function which adds coordinates
find_algorithms(search_term = "add")
# find function arguments of saga:addcoordinatestopoints
get_usage(alg = "saga:addcoordinatestopoints")
}
}
\author{
Jannes Muenchow, Victor Olaya, QGIS core team
}

