% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{get_usage}
\alias{get_usage}
\title{Get usage of a specific QGIS geoalgorithm}
\usage{
get_usage(alg = NULL, intern = FALSE, qgis_env = set_env())
}
\arguments{
\item{alg}{Name of the function whose parameters are being searched for.}

\item{intern}{Logical, if \code{TRUE} the function captures the command line
output as an \code{R} character vector\code{. If}FALSE`, the default, the output is
printed to the console in a pretty way.}

\item{qgis_env}{Environment containing all the paths to run the QGIS API. For
more information, refer to \code{\link[=set_env]{set_env()}}.}
}
\description{
\code{get_usage} lists all function parameters of a specific
QGIS geoalgorithm.
}
\details{
Function \code{get_usage} simply calls
\code{processing.alghelp} of the QGIS Python API.
}
\examples{
\dontrun{
# find a function which adds coordinates
find_algorithms(search_term = "add")
# find function arguments of saga:addcoordinatestopoints
get_usage(alg = "saga:addcoordinatestopoints")
}
}
\author{
Jannes Muenchow, Victor Olaya, QGIS core team
}
