% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQGIS.R
\docType{package}
\name{RQGIS-package}
\alias{RQGIS}
\alias{RQGIS-package}
\title{RQGIS: Integrating R with QGIS}
\description{
RQGIS establishes an interface between R and 'QGIS', i.e. it
allows the user to access 'QGIS' functionalities from the R console. It
achieves this by using the QGIS' Python API via the command line. Hence,
RQGIS extends R's statistical power by the incredible vast
geo-functionality of 'QGIS' (including also 'GDAL', 'SAGA'- and 'GRASS'-GIS
among other third-party providers). This in turn creates a powerful
environment for advanced and innovative (geo-)statistical geocomputing.
'QGIS' is licensed under GPL version 2 or greater and is available from
\url{http://www.qgis.org/en/site/}. Before running RQGIS you need to make sure
to have installed correctly all external software such as QGIS, GRASS and
SAGA.
}
\details{
Our vignette helps to correctly install all third-party
dependencies (e.g., QGIS, GRASS, SAGA):\cr\cr
\code{vignette("install_guide", package = "RQGIS")} \cr\cr
To get started with RQGIS, have a peak at the example on our github
page:\cr\cr
\url{https://github.com/jannes-m/RQGIS}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/jannes-m/RQGIS}
  \item Report bugs at \url{https://github.com/jannes-m/RQGIS/issues}
}

}
\author{
\strong{Maintainer}: Jannes Muenchow \email{jannes.muenchow@uni-jena.de} (0000-0001-7834-4717)

Authors:
\itemize{
  \item Patrick Schratz \email{patrick.schratz@uni-jena.de} (0000-0003-0748-6624)
}

}
