% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RQdeltaCT.R
\name{delta_Ct}
\alias{delta_Ct}
\title{delta_Ct}
\usage{
delta_Ct(data, ref, save.to.txt = FALSE, name.txt = "data_dCt")
}
\arguments{
\item{data}{Data object returned from make_Ct_ready function,}

\item{ref}{Character vector with name of one or more reference genes.}

\item{save.to.txt}{Logical: if TRUE, returned data will be saved to .txt file. Default to FALSE.}

\item{name.txt}{Character: name of saved .txt file, without ".txt" name of extension. Default to "data_dCt".}
}
\value{
Data frame with dCt values.
}
\description{
This function calculates delta Ct (dCt) values by subtracting Ct values of reference gene or genes from Ct values of remaining genes.
}
\examples{
library(tidyverse)
data(data.Ct)
data.CtF <- filter_Ct(data.Ct,
                      remove.Gene = c("Gene2","Gene5","Gene6","Gene9","Gene11"),
                      remove.Sample = c("Control08","Control16","Control22"))
data.CtF.ready <- make_Ct_ready(data.CtF, imput.by.mean.within.groups = TRUE)
data.dCt <- delta_Ct(data.CtF.ready, ref = "Gene8")
head(data.dCt)

}
