% Generated by roxygen2 (4.0.2): do not edit by hand
\name{RRuni}
\alias{RRuni}
\title{Univariate analysis of randomized response data}
\usage{
RRuni(response, data, model, p, group = NULL, MLest = TRUE)
}
\arguments{
\item{response}{either vector of responses containing 0 (No) and 1 (Yes) or name of response variable in \code{data}. In Kuk's card playing method (\code{Kuk}), the observed response variable gives the number of red cards. For the Forced Response (\code{FR}) model, response values are integers from 0 to (m-1), where 'm' is the number of response categories.}

\item{data}{optional \code{data.frame} containing the response variable}

\item{model}{choose RR model. Available models: \code{"Warner","UQTknown","UQTunknown","Mangat","Kuk","FR","Crosswise","CDM","CDMsym","SLD", "mix.norm", "mix.exp","mix.unknown"}. See \code{vignette('RRreg')} for detailed specifications.}

\item{p}{randomization probability. For the Cheating Detection Model (\code{CDM}) or the Stochastic Lie Detector (\code{SLD}): a vector with two values. For the Forced Response model (\code{FR}): a vector of the length of the number of categories}

\item{group}{a group vector of the same length as \code{response} containing values 1 or 2, only required for two-group models, which specify different randomization probabilities for two groups, e.g., \code{CDM} or \code{SLD}. If a data.frame \code{data} is provided, the variable \code{group} is searched within it.}

\item{MLest}{if \code{TRUE}, least-squares estimates of pi outside of [0,1] are corrected to obtain maximum likelihood estimates}
}
\value{
an \code{RRuni} object, can by analyzed by using \code{\link{summary}}
}
\description{
Analyse a data vector \code{response} with a specified RR model (e.g., \code{Warner}) with known randomization probability \code{p}
}
\examples{
# Generate responses of 1000 people according to Warner's model
# with an underlying true proportion of .3
genData <- RRgen(n=1000, pi=.3, model="Warner", p=.7)
# Analyse univariate data to estimate 'pi'
analyse <- RRuni(response=genData$response, model="Warner", p=.7)
summary(analyse)

# Generate data in line with the Stochastic Lie Detector
# assuming that 90\% of the respondents answer truthfully
genData2 <- RRgen(n=1000, pi=.3, model="SLD", p=c(.2,.8), complyRates=c(.8,1),groupRatio=0.4)
analyse2 <- RRuni(response=genData2$response, model="SLD", p=c(.2,.8), group=genData2$group)
summary(analyse2)
}
\seealso{
\code{vignette('RRreg')} or \url{https://dl.dropboxusercontent.com/u/21456540/RRreg/index.html} for a detailed description of the RR models and the appropriate definition of \code{p}
}

