% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRlin.getPW.R
\name{getPW}
\alias{getPW}
\title{Get Misclassification Matrices for RR Models}
\usage{
getPW(model, p, group = 1, par2 = NULL, Kukrep = 1)
}
\arguments{
\item{model}{one of the available models in the package \code{RRreg}:}

\item{p}{randomization probability}

\item{group}{group index (1 or 2) for two-group designs such as  \code{"UQTunknown"} or \code{"SLD"}}

\item{par2}{the second, estimated parameter in two-group designs (e.g., the unknown prevalence of the irrelevant question in \code{"UQTunknown"}, the t-parameter for truth in the \code{"SLD"})}

\item{Kukrep}{number of replications in Kuk's RR design (how many cards are drawn)}
}
\description{
Given some randomization probabilities \code{p}, each RR design corresponds to a misclassification matrix PW.  This square matrix has entries defined as: \code{PW[i,j] = P(respond i | true state j)}.
}
\details{
The method is used internally for estimation. Moreover, the method might be useful to check the exact definition of the RR designs.

Note that for two-group designs, the matrix dependends on a second parameter that is estimated from the data (e.g., the unknown prevalence of the unknown question in the unrelated question technique). Hence, the matrix itself is not constant, but an estimate of a random variable itself.
}
\examples{
getPW(model = "Warner", p = 2/12)
getPW(model = "UQTknown", p = c(2/12, .3))
getPW(model = "UQTunknown", p = c(2/12, .10/12), group=2, par2=.4)
}
\references{
van den Hout, A., & Kooiman, P. (2006). Estimating the Linear Regression Model with Categorical Covariates Subject to Randomized Response. Computational Statistics & Data Analysis, 50(11), 3311–3323.
}
