% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aictab.R
\name{aictab}
\alias{aictab}
\title{Show a table of AIC model comparisons}
\usage{
aictab(
  x,
  plot = FALSE,
  bw = FALSE,
  models = names(x$models)[!names(x$models) \%in\% c("absdiff", "absunc")],
  digits = NA
)
}
\arguments{
\item{x}{An RSA object}

\item{plot}{Should a plot of the AICc table be plotted?}

\item{bw}{Should the plot be black & white?}

\item{models}{A vector with all model names of the candidate set. Defaults to all polynomial models in the RSA object.}

\item{digits}{The output is rounded to this number of digits. No rounding if NA (default).}
}
\value{
\describe{
 \item{Modnames}{Model names.}
 \item{K}{Number of estimated parameters (including the intercept, residual variance, and, if present in the model, control variables).}
 \item{LL}{Model log-likelihood.}
 \item{AICc}{Akaike Information Criterion (corrected).}
 \item{Delta_AICc}{Difference in AICc between this model and the best model.}
 \item{AICcWt}{The Akaike weights, also termed "model probabilities" by Burnham and Anderson (2002). Indicates the level of support (i.e., weight of evidence) of a model being the most parsimonious among the candidate model set.}
 \item{Cum.Wt}{Cumulative Akaike weight. One possible strategy is to restrict interpretation to the "confidence set" of models, that is, discard models with a Cum.Wt > .95 (see Burnham & Anderson, 2002, for details and alternatives).}
 \item{evidence.ratio}{Likelihood ratio of this model vs. the best model.}
 \item{cfi}{Comparative Fit Index (CFI).}
 \item{R2}{Coefficient of determination (R-squared).}
 \item{R2.adj}{Adjusted R-squared.}
 \item{R2.baseline}{Only provided if the model contains control variables. Difference in R-squared as compared to the baseline model with intercept and control variables (= the model "null"). This R^2 increment will typically be of interest because it refers to the amount of variance explained by the two predictors X and Y (plus their squared and interaction terms) in the RSA model.}
 \item{R2.baseline.p}{Only provided if the model contains control variables. p-value for the F-test of the model against the baseline model.}
}
}
\description{
Show a table of AIC model comparisons
}
\note{
This function is similar to the function \code{\link[AICcmodavg]{aictab}} in the \code{AICcmodavg} package.
}
\examples{
\dontrun{
data(motcon)
r.m <- RSA(postVA~ePow*iPow, motcon, verbose=FALSE)
aictab(r.m, plot=TRUE)
}
}
\references{
Burnham, K. P., & Anderson, D. R. (2002). \emph{Model selection and multimodel inference: A practical information-theoretic approach.} Springer Science & Business Media.
}
