% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.pisr2}
\alias{rsaga.pisr2}
\title{Potential incoming solar radiation SAGA 2.2.2+}
\usage{
rsaga.pisr2(in.dem, in.svf.grid = NULL, in.vapour.grid = NULL,
  in.linke.grid = NULL, out.direct.grid, out.diffuse.grid,
  out.total.grid = NULL, out.ratio.grid = NULL, out.duration, out.sunrise,
  out.sunset, local.svf = TRUE, location = c("latitude", "grid"),
  latitude = 53, unit = c("kWh/m2", "kJ/m2", "J/cm2"), solconst = 1367,
  method = c("height", "components", "lumped", "hofierka"),
  hgt.atmosphere = 12000, cmp.pressure = 1013, cmp.water.content = 1.68,
  cmp.dust = 100, lmp.transmittance = 70, time.range = c(0, 24),
  time.step = 0.5, start.date = list(day = 31, month = 10, year = 2015),
  end.date = NULL, day.step = 5, env = rsaga.env(), ...)
}
\arguments{
\item{in.dem}{name of input digital elevation model (DEM) grid in SAGA grid format (default extension: \code{.sgrd})}

\item{in.svf.grid}{Optional input grid in SAGA format:  Sky View Factor; see also \code{local.svf}}

\item{in.vapour.grid}{Optional input grid in SAGA format:  Water vapour pressure (mbar), for use with \code{method = "height"}; default 10 mbar}

\item{in.linke.grid}{Optional input grid in SAGA format: Linke turbidity coefficient, for use with \code{method = "hofierka"}; default 3.0}

\item{out.direct.grid}{Output grid: Direct insolation (unit selected by \code{unit} argument)}

\item{out.diffuse.grid}{Output grid: Diffuse insolation}

\item{out.total.grid}{Optional output grid: Total insolation, i.e. sum of direct and diffuse incoming solar radiation}

\item{out.ratio.grid}{Optional output grid: Direct to diffuse ratio}

\item{out.duration}{Optional output grid: Duration of insolation}

\item{out.sunrise}{Optional output grid: time of sunrise; only calculated if time span is set to single day}

\item{out.sunset}{Time of sunset; see \code{out.sunrise}}

\item{local.svf}{logical (default: \code{TRUE}; if TRUE, use sky view factor based on local slope (after Oke, 1988), if no sky view factor grid is provided in \code{in.svf.grid}}

\item{location}{specified whether to use constant latitude supplied by \code{latitude} below (\code{"latitude"} or code \code{0}; default) or as calculated from the grid system (\code{"grid"} or code \code{1})}

\item{latitude}{Geographical latitude in degree North (negative values indicate southern hemisphere)}

\item{unit}{unit of insolation output grids: \code{"kWh/m2"} (default) \code{"kJ/m2"}, or \code{"J/cm2"}}

\item{solconst}{solar constant, defaults to 1367 W/m2}

\item{method}{specifies how the atmospheric components should be  accounted for: either based on the height of atmosphere and vapour pressure (\code{"height"}, or numeric code 0), or air pressure, water and dust content (\code{"components"}, code 1), or lumped atmospheric transmittance (\code{"lumped"}, code \code{2}), or by the method of Hofierka and Suri, 2009 (\code{"hofierka"}, code \code{3}). Default: \code{"lumped"}.}

\item{hgt.atmosphere}{Height of atmosphere (in m); default 12000 m. For use with \code{method = "height"}}

\item{cmp.pressure}{atmospheric pressure in mbar, defaults to 1013 mbar. For use with \code{method = "components"}}

\item{cmp.water.content}{water content of a vertical slice of the atmosphere in cm: between 1.5 and 1.7cm, average 1.68cm (default). For use with \code{method = "components"}}

\item{cmp.dust}{dust factor in ppm; defaults to 100 ppm. For use with \code{method = "components"}}

\item{lmp.transmittance}{transmittance of the atmosphere in percent; usually between 60 (humid areas) and 80 percent (deserts)}

\item{time.range}{numeric vector of length 2:  time span (hours of the day) for numerical integration}

\item{time.step}{time step in hours for numerical integration}

\item{start.date}{list of length three, giving the start date in \code{day}, \code{month}, and \code{year} components as numbers; month is one-based (SAGA_CMD uses zero-based numbers internally), i.e. Jan. 1st 2015 is \code{list(day=1,month=1,year=2015)}}

\item{end.date}{see \code{start.date}}

\item{day.step}{if \code{days} indicates a range of days, this specifies the time step (number of days) for calculating the incoming solar radiation}

\item{env}{RSAGA geoprocessing environment obtained with \code{\link[=rsaga.env]{rsaga.env()}}; this argument is required for version control (see Note)}

\item{...}{optional arguments to be passed to \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}}
}
\description{
This function calculates the potential incoming solar radiation in an area using different atmospheric models; This function reflects changes to the module with SAGA 2.2.2+.
For SAGA versions 2.0.6 to 2.2.1 please see \code{\link[=rsaga.pisr]{rsaga.pisr()}}.
}
\details{
According to SAGA GIS 2.0.7 documentation, "Most options should do well, but TAPES-G based diffuse irradiance calculation ("Atmospheric Effects" methods 2 and 3) needs further revision!" I.e. be careful with \code{method = "components"} and \code{method = "lumped"}.
}
\note{
SAGA_CMD uses zero-based months, but this R function uses the standard one-based months (e.g. day 1 is the first day of the month, month 1 is January) and translates to the SAGA system.

This function uses module Potential Incoming Solar Radiation from SAGA library \code{ta_lighting} in SAGA version 2.0.6+.
Changes to the module with SAGA 2.2.2+ include adding \code{year} to the \code{*.date} arguments to allow calculation across years.
The method of Hofierka and Suri (2009) is added, which uses the Linke turbidity coefficient.
Duration of insolation (\code{"out.duration"}) is only calculated when the time period is set to a single day.
}
\references{
Boehner, J., Antonic, O. (2009): Land surface parameters specific to topo-climatology. In: Hengl, T. and Reuter, H. I. (eds.): Geomorphometry - Concepts, Software, Applications. Elsevier.

Oke, T.R. (1988): Boundary layer climates. London, Taylor and Francis.

Wilson, J.P., Gallant, J.C. (eds.), 2000: Terrain analysis - principles and applications. New York, John Wiley and Sons.

Hofierka, J., Suri, M. (2002): The solar radiation model for Open source GIS: implementation and applications. International GRASS users conference in Trento, Italy, September 2002
}
\seealso{
\code{\link[=rsaga.pisr]{rsaga.pisr()}}; for similar modules in older SAGA versions (pre-2.0.6) see \code{\link[=rsaga.solar.radiation]{rsaga.solar.radiation()}} and \code{\link[=rsaga.insolation]{rsaga.insolation()}}; \code{\link[=rsaga.hillshade]{rsaga.hillshade()}}
}
\author{
Alexander Brenning & Donovan Bangs (R interface), Olaf Conrad (SAGA module)
}
\keyword{interface}
\keyword{spatial}
