% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym_regression.R
\name{sym.knn}
\alias{sym.knn}
\title{Symbolic k-Nearest Neighbor Regression}
\usage{
sym.knn(
  formula,
  sym.data,
  method = c("cm", "crm"),
  scale = TRUE,
  kmax = 20,
  kernel = "triangular"
)
}
\arguments{
\item{formula}{a formula object.}

\item{sym.data}{symbolc data.table}

\item{method}{cm or crm}

\item{scale}{logical, scale variable to have equal sd.}

\item{kmax}{maximum number of k, if ks is not specified.}

\item{kernel}{kernel to use. Possible choices are "rectangular" (which is standard unweighted knn), "triangular", "epanechnikov" (or beta(2,2)), "biweight" (or beta(3,3)), "triweight" (or beta(4,4)), "cos", "inv", "gaussian" and "optimal".}
}
\description{
Symbolic k-Nearest Neighbor Regression
}
\references{
Lima-Neto, E.A., De Carvalho, F.A.T., (2008). Centre and range method to fitting a linear regression model on symbolic interval data. Computational Statistics and Data Analysis52, 1500-1515


Lima-Neto, E.A., De Carvalho, F.A.T., (2010). Constrained linear regression models for symbolic interval-valued variables.  Computational Statistics and Data Analysis 54, 333-347


Lima Neto, E.d.A., de Carvalho, F.d.A.T. Nonlinear regression applied to interval-valued data. Pattern Anal Applic 20, 809–824 (2017). https://doi.org/10.1007/s10044-016-0538-y


Rodriguez, O. (2018). Shrinkage linear regression for symbolic interval-valued variables.Journal MODULAD 2018, vol. Modulad 45, pp.19-38
}
