% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobMethods.R
\name{getJobAssetFiles}
\alias{getJobAssetFiles}
\title{Get Job Asset Files}
\usage{
getJobAssetFiles(account, username = Sys.getenv("SLUSER"), jobID,
  fileName = "selenium-server.log", ...)
}
\arguments{
\item{account}{An object of class "account". An account object see \code{\link{account}}.}

\item{username}{SauceLabs username}

\item{jobID}{Id of the job to get assets from}

\item{fileName}{Accepted Values for fileName "selenium-server.log" "video.flv" "XXXXscreenshot.png" (where XXXX is a number between 0000 and 9999) "final_screenshot.png"}

\item{...}{Additonal function arguments - Currently unused.}
}
\description{
Download job assets. After a job completes, all assets created during the job are available via this API. These include the screencast recording, logs, and screenshots taken on crucial steps.
The job assests will be deleted from the test page after 30 days. Thus, after 30 days all your test commands, logs, screenshots and the screencast recording will be gone. This is the reason why we strongly recommend to download your job assets if this is an information that you must keep in your records.
}
\examples{
\dontrun{
myAcc <- account()
myJobs <- getJobs(myAcc)
#> myJobs$data[1,]
#id
#1: 4152e0a185f945bfa43e091eef1e7c30
myJobs <- getJobs(myAcc, getFullJobs = TRUE)
#> myJobs$data[1,.(id, browser)]
#id      browser
#1: 4152e0a185f945bfa43e091eef1e7c30 googlechrome
testId <- myJobs$data[1, id]

#> myJobs$data[1,.(build, passed)]
#build passed
#1:    24  FALSE

# update this job
updateJob(myAcc, jobID = testId, passed = TRUE, build = 20)
myJobs <- getJobs(myAcc, getFullJobs = TRUE)
#> myJobs$data[1,.(build, passed)]
#build passed
#1:    20   TRUE
# deleteJob(myAcc, jobID = testId)
stopJob(myAcc, jobID = testId)

jobAssets <- getJobAssetNames(myAcc, jobID = testId)
#> jobAssets[["selenium-log"]]
#[1] "selenium-server.log"

jobLog <- getJobAssetFiles(myAcc, jobID = testId)
# deleteJobAssets(myAcc, jobID = testId)
}

}
\seealso{
Other jobMethods: \code{\link{deleteJobAssets}},
  \code{\link{deleteJob}}, \code{\link{getJobAssetNames}},
  \code{\link{getJobs}}, \code{\link{stopJob}},
  \code{\link{updateJob}}
}

